/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.opengl.GLES20;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.Util;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.OverlaySettings;
import androidx.media3.effect.SamplerOverlayMatrixProvider;
import androidx.media3.effect.TextureOverlay;
import com.google.common.collect.ImmutableList;

final class OverlayShaderProgram
extends BaseGlShaderProgram {
    private final GlProgram glProgram;
    private final SamplerOverlayMatrixProvider samplerOverlayMatrixProvider;
    private final ImmutableList<TextureOverlay> overlays;

    public OverlayShaderProgram(boolean useHdr, ImmutableList<TextureOverlay> overlays) throws VideoFrameProcessingException {
        super(useHdr, 1);
        Assertions.checkArgument((!useHdr ? 1 : 0) != 0, (Object)"OverlayShaderProgram does not support HDR colors yet.");
        Assertions.checkArgument((overlays.size() <= 15 ? 1 : 0) != 0, (Object)"OverlayShaderProgram does not support more than 15 overlays in the same instance.");
        this.overlays = overlays;
        this.samplerOverlayMatrixProvider = new SamplerOverlayMatrixProvider();
        try {
            this.glProgram = new GlProgram(OverlayShaderProgram.createVertexShader(overlays.size()), OverlayShaderProgram.createFragmentShader(overlays.size()));
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
        this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        Size videoSize = new Size(inputWidth, inputHeight);
        this.samplerOverlayMatrixProvider.configure(videoSize);
        for (TextureOverlay overlay : this.overlays) {
            overlay.configure(videoSize);
        }
        return videoSize;
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        try {
            this.glProgram.use();
            if (!this.overlays.isEmpty()) {
                for (int texUnitIndex = 1; texUnitIndex <= this.overlays.size(); ++texUnitIndex) {
                    TextureOverlay overlay = (TextureOverlay)this.overlays.get(texUnitIndex - 1);
                    this.glProgram.setSamplerTexIdUniform(Util.formatInvariant((String)"uOverlayTexSampler%d", (Object[])new Object[]{texUnitIndex}), overlay.getTextureId(presentationTimeUs), texUnitIndex);
                    OverlaySettings overlaySettings = overlay.getOverlaySettings(presentationTimeUs);
                    Size overlaySize = overlay.getTextureSize(presentationTimeUs);
                    this.glProgram.setFloatsUniform(Util.formatInvariant((String)"uTransformationMatrix%d", (Object[])new Object[]{texUnitIndex}), this.samplerOverlayMatrixProvider.getTransformationMatrix(overlaySize, overlaySettings));
                    this.glProgram.setFloatUniform(Util.formatInvariant((String)"uOverlayAlphaScale%d", (Object[])new Object[]{texUnitIndex}), overlaySettings.alphaScale);
                }
            }
            this.glProgram.setSamplerTexIdUniform("uVideoTexSampler0", inputTexId, 0);
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e, presentationTimeUs);
        }
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            this.glProgram.delete();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
        for (int i = 0; i < this.overlays.size(); ++i) {
            ((TextureOverlay)this.overlays.get(i)).release();
        }
    }

    private static String createVertexShader(int numOverlays) {
        int texUnitIndex;
        StringBuilder shader = new StringBuilder().append("#version 100\n").append("attribute vec4 aFramePosition;\n").append("varying vec2 vVideoTexSamplingCoord0;\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"uniform mat4 uTransformationMatrix%s;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"varying vec2 vOverlayTexSamplingCoord%s;\n", (Object[])new Object[]{texUnitIndex}));
        }
        shader.append("vec2 getTexSamplingCoord(vec2 ndcPosition){\n").append("  return vec2(ndcPosition.x * 0.5 + 0.5, ndcPosition.y * 0.5 + 0.5);\n").append("}\n").append("void main() {\n").append("  gl_Position = aFramePosition;\n").append("  vVideoTexSamplingCoord0 = getTexSamplingCoord(aFramePosition.xy);\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"  vec4 aOverlayPosition%d = \n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"  uTransformationMatrix%s * aFramePosition;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"  vOverlayTexSamplingCoord%d = getTexSamplingCoord(aOverlayPosition%d.xy);\n", (Object[])new Object[]{texUnitIndex, texUnitIndex}));
        }
        shader.append("}\n");
        return shader.toString();
    }

    private static String createFragmentShader(int numOverlays) {
        int texUnitIndex;
        StringBuilder shader = new StringBuilder().append("#version 100\n").append("precision mediump float;\n").append("uniform sampler2D uVideoTexSampler0;\n").append("varying vec2 vVideoTexSamplingCoord0;\n").append("// Manually implementing the CLAMP_TO_BORDER texture wrapping option\n").append("// (https://open.gl/textures) since it's not implemented until OpenGL ES 3.2.\n").append("vec4 getClampToBorderOverlayColor(\n").append("    sampler2D texSampler, vec2 texSamplingCoord, float alphaScale){\n").append("  if (texSamplingCoord.x > 1.0 || texSamplingCoord.x < 0.0\n").append("      || texSamplingCoord.y > 1.0 || texSamplingCoord.y < 0.0) {\n").append("    return vec4(0.0, 0.0, 0.0, 0.0);\n").append("  } else {\n").append("    vec4 overlayColor = vec4(texture2D(texSampler, texSamplingCoord));\n").append("    overlayColor.a = alphaScale * overlayColor.a;\n").append("    return overlayColor;\n").append("  }\n").append("}\n").append("\n").append("float getMixAlpha(float videoAlpha, float overlayAlpha) {\n").append("  if (videoAlpha == 0.0) {\n").append("    return 1.0;\n").append("  } else {\n").append("    return clamp(overlayAlpha/videoAlpha, 0.0, 1.0);\n").append("  }\n").append("}\n").append("").append("float srgbEotfSingleChannel(float srgb) {\n").append("  return srgb <= 0.04045 ? srgb / 12.92 : pow((srgb + 0.055) / 1.055, 2.4);\n").append("}\n").append("// sRGB EOTF.\n").append("vec3 applyEotf(const vec3 srgb) {\n").append("// Reference implementation:\n").append("// https://cs.android.com/android/platform/superproject/+/master:frameworks/native/libs/renderengine/gl/ProgramCache.cpp;drc=de09f10aa504fd8066370591a00c9ff1cafbb7fa;l=235\n").append("  return vec3(\n").append("    srgbEotfSingleChannel(srgb.r),\n").append("    srgbEotfSingleChannel(srgb.g),\n").append("    srgbEotfSingleChannel(srgb.b)\n").append("  );\n").append("}\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"uniform sampler2D uOverlayTexSampler%d;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"uniform float uOverlayAlphaScale%d;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"varying vec2 vOverlayTexSamplingCoord%d;\n", (Object[])new Object[]{texUnitIndex}));
        }
        shader.append("void main() {\n").append("  vec4 videoColor = vec4(texture2D(uVideoTexSampler0, vVideoTexSamplingCoord0));\n").append("  vec4 fragColor = videoColor;\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"  vec4 electricalOverlayColor%d = getClampToBorderOverlayColor(\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"    uOverlayTexSampler%d, vOverlayTexSamplingCoord%d, uOverlayAlphaScale%d);\n", (Object[])new Object[]{texUnitIndex, texUnitIndex, texUnitIndex})).append(Util.formatInvariant((String)"  vec4 opticalOverlayColor%d = vec4(\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"    applyEotf(electricalOverlayColor%d.rgb), electricalOverlayColor%d.a);\n", (Object[])new Object[]{texUnitIndex, texUnitIndex})).append("  fragColor = mix(\n").append(Util.formatInvariant((String)"    fragColor, opticalOverlayColor%d, getMixAlpha(videoColor.a, opticalOverlayColor%d.a));\n", (Object[])new Object[]{texUnitIndex, texUnitIndex}));
        }
        shader.append("  gl_FragColor = fragColor;\n").append("}\n");
        return shader.toString();
    }
}

