/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.graphics.Matrix;
import androidx.annotation.FloatRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.MatrixTransformation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class Presentation
implements MatrixTransformation {
    public static final int LAYOUT_SCALE_TO_FIT = 0;
    public static final int LAYOUT_SCALE_TO_FIT_WITH_CROP = 1;
    public static final int LAYOUT_STRETCH_TO_FIT = 2;
    private static final float ASPECT_RATIO_UNSET = -1.0f;
    private final int requestedWidthPixels;
    private final int requestedHeightPixels;
    private float requestedAspectRatio;
    private final int layout;
    private float outputWidth;
    private float outputHeight;
    private @MonotonicNonNull Matrix transformationMatrix;

    private static void checkLayout(int layout) {
        Assertions.checkArgument((layout == 0 || layout == 1 || layout == 2 ? 1 : 0) != 0, (Object)("invalid layout " + layout));
    }

    public static Presentation createForAspectRatio(@FloatRange(from=0.0, fromInclusive=false) float aspectRatio, int layout) {
        Assertions.checkArgument((aspectRatio > 0.0f ? 1 : 0) != 0, (Object)("aspect ratio " + aspectRatio + " must be positive"));
        Presentation.checkLayout(layout);
        return new Presentation(-1, -1, aspectRatio, layout);
    }

    public static Presentation createForHeight(int height) {
        return new Presentation(-1, height, -1.0f, 0);
    }

    public static Presentation createForWidthAndHeight(int width, int height, int layout) {
        Assertions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)("width " + width + " must be positive"));
        Assertions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)("height " + height + " must be positive"));
        Presentation.checkLayout(layout);
        return new Presentation(width, height, -1.0f, layout);
    }

    private Presentation(int width, int height, float aspectRatio, int layout) {
        Assertions.checkArgument((aspectRatio == -1.0f || width == -1 ? 1 : 0) != 0, (Object)"width and aspect ratio should not both be set");
        this.requestedWidthPixels = width;
        this.requestedHeightPixels = height;
        this.requestedAspectRatio = aspectRatio;
        this.layout = layout;
        this.outputWidth = -1.0f;
        this.outputHeight = -1.0f;
        this.transformationMatrix = new Matrix();
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.transformationMatrix = new Matrix();
        this.outputWidth = inputWidth;
        this.outputHeight = inputHeight;
        if (this.requestedWidthPixels != -1 && this.requestedHeightPixels != -1) {
            this.requestedAspectRatio = (float)this.requestedWidthPixels / (float)this.requestedHeightPixels;
        }
        if (this.requestedAspectRatio != -1.0f) {
            this.applyAspectRatio();
        }
        if (this.requestedHeightPixels != -1) {
            this.outputWidth = this.requestedWidthPixels != -1 ? (float)this.requestedWidthPixels : (float)this.requestedHeightPixels * this.outputWidth / this.outputHeight;
            this.outputHeight = this.requestedHeightPixels;
        }
        return new Size(Math.round(this.outputWidth), Math.round(this.outputHeight));
    }

    @Override
    public Matrix getMatrix(long presentationTimeUs) {
        return (Matrix)Assertions.checkStateNotNull((Object)this.transformationMatrix, (Object)"configure must be called first");
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        this.configure(inputWidth, inputHeight);
        return ((Matrix)Assertions.checkStateNotNull((Object)this.transformationMatrix)).isIdentity() && inputWidth == Math.round(this.outputWidth) && inputHeight == Math.round(this.outputHeight);
    }

    @RequiresNonNull(value={"transformationMatrix"})
    private void applyAspectRatio() {
        float inputAspectRatio = this.outputWidth / this.outputHeight;
        if (this.layout == 0) {
            if (this.requestedAspectRatio > inputAspectRatio) {
                this.transformationMatrix.setScale(inputAspectRatio / this.requestedAspectRatio, 1.0f);
                this.outputWidth = this.outputHeight * this.requestedAspectRatio;
            } else {
                this.transformationMatrix.setScale(1.0f, this.requestedAspectRatio / inputAspectRatio);
                this.outputHeight = this.outputWidth / this.requestedAspectRatio;
            }
        } else if (this.layout == 1) {
            if (this.requestedAspectRatio > inputAspectRatio) {
                this.transformationMatrix.setScale(1.0f, this.requestedAspectRatio / inputAspectRatio);
                this.outputHeight = this.outputWidth / this.requestedAspectRatio;
            } else {
                this.transformationMatrix.setScale(inputAspectRatio / this.requestedAspectRatio, 1.0f);
                this.outputWidth = this.outputHeight * this.requestedAspectRatio;
            }
        } else if (this.layout == 2) {
            if (this.requestedAspectRatio > inputAspectRatio) {
                this.outputWidth = this.outputHeight * this.requestedAspectRatio;
            } else {
                this.outputHeight = this.outputWidth / this.requestedAspectRatio;
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Layout {
    }
}

