/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.Effect;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.VideoFrameProcessor;
import androidx.media3.common.VideoGraph;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.Presentation;
import androidx.media3.effect.VideoCompositorSettings;
import java.util.List;
import java.util.concurrent.Executor;

@UnstableApi
public abstract class SingleInputVideoGraph
implements VideoGraph {
    public static final int SINGLE_INPUT_INDEX = 0;
    private final Context context;
    private final VideoFrameProcessor.Factory videoFrameProcessorFactory;
    private final ColorInfo inputColorInfo;
    private final ColorInfo outputColorInfo;
    private final VideoGraph.Listener listener;
    private final DebugViewProvider debugViewProvider;
    private final Executor listenerExecutor;
    private final boolean renderFramesAutomatically;
    private final long initialTimestampOffsetUs;
    @Nullable
    private final Presentation presentation;
    @Nullable
    private VideoFrameProcessor videoFrameProcessor;
    private boolean released;
    private volatile boolean hasProducedFrameWithTimestampZero;

    public SingleInputVideoGraph(Context context, VideoFrameProcessor.Factory videoFrameProcessorFactory, ColorInfo inputColorInfo, ColorInfo outputColorInfo, VideoGraph.Listener listener, DebugViewProvider debugViewProvider, Executor listenerExecutor, VideoCompositorSettings videoCompositorSettings, boolean renderFramesAutomatically, @Nullable Presentation presentation, long initialTimestampOffsetUs) {
        Assertions.checkState((boolean)VideoCompositorSettings.DEFAULT.equals(videoCompositorSettings), (Object)"SingleInputVideoGraph does not use VideoCompositor, and therefore cannot apply VideoCompositorSettings");
        this.context = context;
        this.videoFrameProcessorFactory = videoFrameProcessorFactory;
        this.inputColorInfo = inputColorInfo;
        this.outputColorInfo = outputColorInfo;
        this.listener = listener;
        this.debugViewProvider = debugViewProvider;
        this.listenerExecutor = listenerExecutor;
        this.renderFramesAutomatically = renderFramesAutomatically;
        this.presentation = presentation;
        this.initialTimestampOffsetUs = initialTimestampOffsetUs;
    }

    public void initialize() {
    }

    public int registerInput() throws VideoFrameProcessingException {
        Assertions.checkStateNotNull((Object)(this.videoFrameProcessor == null && !this.released ? 1 : 0));
        this.videoFrameProcessor = this.videoFrameProcessorFactory.create(this.context, this.debugViewProvider, this.inputColorInfo, this.outputColorInfo, this.renderFramesAutomatically, this.listenerExecutor, new VideoFrameProcessor.Listener(){
            private long lastProcessedFramePresentationTimeUs;

            public void onInputStreamRegistered(int inputType, List<Effect> effects, FrameInfo frameInfo) {
            }

            public void onOutputSizeChanged(int width, int height) {
                SingleInputVideoGraph.this.listenerExecutor.execute(() -> SingleInputVideoGraph.this.listener.onOutputSizeChanged(width, height));
            }

            public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
                if (presentationTimeUs == 0L) {
                    SingleInputVideoGraph.this.hasProducedFrameWithTimestampZero = true;
                }
                this.lastProcessedFramePresentationTimeUs = presentationTimeUs;
                SingleInputVideoGraph.this.listenerExecutor.execute(() -> SingleInputVideoGraph.this.listener.onOutputFrameAvailableForRendering(presentationTimeUs));
            }

            public void onError(VideoFrameProcessingException exception) {
                SingleInputVideoGraph.this.listenerExecutor.execute(() -> SingleInputVideoGraph.this.listener.onError(exception));
            }

            public void onEnded() {
                SingleInputVideoGraph.this.listener.onEnded(this.lastProcessedFramePresentationTimeUs);
            }
        });
        return 0;
    }

    public VideoFrameProcessor getProcessor(int inputId) {
        return (VideoFrameProcessor)Assertions.checkStateNotNull((Object)this.videoFrameProcessor);
    }

    public void setOutputSurfaceInfo(@Nullable SurfaceInfo outputSurfaceInfo) {
        ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.videoFrameProcessor)).setOutputSurfaceInfo(outputSurfaceInfo);
    }

    public boolean hasProducedFrameWithTimestampZero() {
        return this.hasProducedFrameWithTimestampZero;
    }

    public void release() {
        if (this.released) {
            return;
        }
        if (this.videoFrameProcessor != null) {
            this.videoFrameProcessor.release();
            this.videoFrameProcessor = null;
        }
        this.released = true;
    }

    protected ColorInfo getInputColorInfo() {
        return this.inputColorInfo;
    }

    protected long getInitialTimestampOffsetUs() {
        return this.initialTimestampOffsetUs;
    }

    @Nullable
    protected Presentation getPresentation() {
        return this.presentation;
    }
}

