/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;

final class TexturePool {
    private final Queue<GlTextureInfo> freeTextures;
    private final Queue<GlTextureInfo> inUseTextures;
    private final int capacity;
    private final boolean useHighPrecisionColorComponents;

    public TexturePool(boolean useHighPrecisionColorComponents, int capacity) {
        this.capacity = capacity;
        this.useHighPrecisionColorComponents = useHighPrecisionColorComponents;
        this.freeTextures = new ArrayDeque<GlTextureInfo>(capacity);
        this.inUseTextures = new ArrayDeque<GlTextureInfo>(capacity);
    }

    public boolean isConfigured() {
        return this.getIteratorToAllTextures().hasNext();
    }

    public int capacity() {
        return this.capacity;
    }

    public int freeTextureCount() {
        if (!this.isConfigured()) {
            return this.capacity;
        }
        return this.freeTextures.size();
    }

    public void ensureConfigured(GlObjectsProvider glObjectsProvider, int width, int height) throws GlUtil.GlException {
        if (!this.isConfigured()) {
            this.createTextures(glObjectsProvider, width, height);
            return;
        }
        GlTextureInfo texture = this.getIteratorToAllTextures().next();
        if (texture.width != width || texture.height != height) {
            this.deleteAllTextures();
            this.createTextures(glObjectsProvider, width, height);
        }
    }

    public GlTextureInfo useTexture() {
        if (this.freeTextures.isEmpty()) {
            throw new IllegalStateException("Textures are all in use. Please release in-use textures before calling useTexture.");
        }
        GlTextureInfo texture = this.freeTextures.remove();
        this.inUseTextures.add(texture);
        return texture;
    }

    public void freeTexture(GlTextureInfo textureInfo) {
        Assertions.checkState((boolean)this.inUseTextures.contains(textureInfo));
        this.inUseTextures.remove(textureInfo);
        this.freeTextures.add(textureInfo);
    }

    public void freeTexture() {
        Assertions.checkState((!this.inUseTextures.isEmpty() ? 1 : 0) != 0);
        GlTextureInfo texture = this.inUseTextures.remove();
        this.freeTextures.add(texture);
    }

    public void freeAllTextures() {
        this.freeTextures.addAll(this.inUseTextures);
        this.inUseTextures.clear();
    }

    public void deleteAllTextures() throws GlUtil.GlException {
        Iterator<GlTextureInfo> allTextures = this.getIteratorToAllTextures();
        while (allTextures.hasNext()) {
            allTextures.next().release();
        }
        this.freeTextures.clear();
        this.inUseTextures.clear();
    }

    private void createTextures(GlObjectsProvider glObjectsProvider, int width, int height) throws GlUtil.GlException {
        Assertions.checkState((boolean)this.freeTextures.isEmpty());
        Assertions.checkState((boolean)this.inUseTextures.isEmpty());
        for (int i = 0; i < this.capacity; ++i) {
            int texId = GlUtil.createTexture((int)width, (int)height, (boolean)this.useHighPrecisionColorComponents);
            GlTextureInfo texture = glObjectsProvider.createBuffersForTexture(texId, width, height);
            this.freeTextures.add(texture);
        }
    }

    private Iterator<GlTextureInfo> getIteratorToAllTextures() {
        return Iterables.concat(this.freeTextures, this.inUseTextures).iterator();
    }
}

