/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.audio.AudioProcessor;
import androidx.media3.transformer.Codec;
import androidx.media3.transformer.FallbackListener;
import androidx.media3.transformer.SamplePipeline;
import androidx.media3.transformer.SegmentSpeedProvider;
import androidx.media3.transformer.SpeedChangingAudioProcessor;
import androidx.media3.transformer.TransformationException;
import androidx.media3.transformer.TransformationRequest;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.dataflow.qual.Pure;

final class AudioTranscodingSamplePipeline
implements SamplePipeline {
    private static final int DEFAULT_ENCODER_BITRATE = 131072;
    private final Codec decoder;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    @Nullable
    private final SpeedChangingAudioProcessor speedChangingAudioProcessor;
    private final Codec encoder;
    private final AudioProcessor.AudioFormat encoderInputAudioFormat;
    private final DecoderInputBuffer encoderInputBuffer = new DecoderInputBuffer(0);
    private final DecoderInputBuffer encoderOutputBuffer = new DecoderInputBuffer(0);
    private ByteBuffer processorOutputBuffer;
    private long nextEncoderInputBufferTimeUs;
    private long encoderBufferDurationRemainder;

    public AudioTranscodingSamplePipeline(Format inputFormat, long streamOffsetUs, TransformationRequest transformationRequest, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, List<String> allowedOutputMimeTypes, FallbackListener fallbackListener) throws TransformationException {
        this.decoder = decoderFactory.createForAudioDecoding(inputFormat);
        AudioProcessor.AudioFormat encoderInputAudioFormat = new AudioProcessor.AudioFormat(inputFormat.sampleRate, inputFormat.channelCount, 2);
        if (transformationRequest.flattenForSlowMotion) {
            this.speedChangingAudioProcessor = new SpeedChangingAudioProcessor(new SegmentSpeedProvider(inputFormat));
            try {
                encoderInputAudioFormat = this.speedChangingAudioProcessor.configure(encoderInputAudioFormat);
            }
            catch (AudioProcessor.UnhandledAudioFormatException impossible) {
                throw new IllegalStateException(impossible);
            }
            this.speedChangingAudioProcessor.flush();
        } else {
            this.speedChangingAudioProcessor = null;
        }
        this.processorOutputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.encoderInputAudioFormat = encoderInputAudioFormat;
        Format requestedOutputFormat = new Format.Builder().setSampleMimeType(transformationRequest.audioMimeType == null ? inputFormat.sampleMimeType : transformationRequest.audioMimeType).setSampleRate(encoderInputAudioFormat.sampleRate).setChannelCount(encoderInputAudioFormat.channelCount).setAverageBitrate(131072).build();
        this.encoder = encoderFactory.createForAudioEncoding(requestedOutputFormat, allowedOutputMimeTypes);
        fallbackListener.onTransformationRequestFinalized(AudioTranscodingSamplePipeline.createFallbackTransformationRequest(transformationRequest, requestedOutputFormat, this.encoder.getConfigurationFormat()));
        this.nextEncoderInputBufferTimeUs = streamOffsetUs;
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() throws TransformationException {
        return this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer) ? this.decoderInputBuffer : null;
    }

    @Override
    public void queueInputBuffer() throws TransformationException {
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
    }

    @Override
    public boolean processData() throws TransformationException {
        if (this.speedChangingAudioProcessor != null) {
            return this.feedEncoderFromProcessor() || this.feedProcessorFromDecoder();
        }
        return this.feedEncoderFromDecoder();
    }

    @Override
    @Nullable
    public Format getOutputFormat() throws TransformationException {
        return this.encoder.getOutputFormat();
    }

    @Override
    @Nullable
    public DecoderInputBuffer getOutputBuffer() throws TransformationException {
        this.encoderOutputBuffer.data = this.encoder.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        this.encoderOutputBuffer.timeUs = ((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoder.getOutputBufferInfo())).presentationTimeUs;
        this.encoderOutputBuffer.setFlags(1);
        return this.encoderOutputBuffer;
    }

    @Override
    public void releaseOutputBuffer() throws TransformationException {
        this.encoder.releaseOutputBuffer(false);
    }

    @Override
    public boolean isEnded() {
        return this.encoder.isEnded();
    }

    @Override
    public void release() {
        if (this.speedChangingAudioProcessor != null) {
            this.speedChangingAudioProcessor.reset();
        }
        this.decoder.release();
        this.encoder.release();
    }

    private boolean feedEncoderFromDecoder() throws TransformationException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (this.decoder.isEnded()) {
            this.queueEndOfStreamToEncoder();
            return false;
        }
        ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        this.feedEncoder(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            this.decoder.releaseOutputBuffer(false);
        }
        return true;
    }

    @RequiresNonNull(value={"speedChangingAudioProcessor"})
    private boolean feedEncoderFromProcessor() throws TransformationException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (!this.processorOutputBuffer.hasRemaining()) {
            this.processorOutputBuffer = this.speedChangingAudioProcessor.getOutput();
            if (!this.processorOutputBuffer.hasRemaining()) {
                if (this.decoder.isEnded() && this.speedChangingAudioProcessor.isEnded()) {
                    this.queueEndOfStreamToEncoder();
                }
                return false;
            }
        }
        this.feedEncoder(this.processorOutputBuffer);
        return true;
    }

    @RequiresNonNull(value={"speedChangingAudioProcessor"})
    private boolean feedProcessorFromDecoder() throws TransformationException {
        if (this.processorOutputBuffer.hasRemaining() || this.speedChangingAudioProcessor.getOutput().hasRemaining()) {
            return false;
        }
        if (this.decoder.isEnded()) {
            this.speedChangingAudioProcessor.queueEndOfStream();
            return false;
        }
        Assertions.checkState((!this.speedChangingAudioProcessor.isEnded() ? 1 : 0) != 0);
        ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        this.speedChangingAudioProcessor.queueInput(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            this.decoder.releaseOutputBuffer(false);
        }
        return true;
    }

    private void feedEncoder(ByteBuffer inputBuffer) throws TransformationException {
        ByteBuffer encoderInputBufferData = (ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data);
        int bufferLimit = inputBuffer.limit();
        inputBuffer.limit(Math.min(bufferLimit, inputBuffer.position() + encoderInputBufferData.capacity()));
        encoderInputBufferData.put(inputBuffer);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.computeNextEncoderInputBufferTimeUs(encoderInputBufferData.position(), this.encoderInputAudioFormat.bytesPerFrame, this.encoderInputAudioFormat.sampleRate);
        this.encoderInputBuffer.setFlags(0);
        this.encoderInputBuffer.flip();
        inputBuffer.limit(bufferLimit);
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void queueEndOfStreamToEncoder() throws TransformationException {
        Assertions.checkState((((ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data)).position() == 0 ? 1 : 0) != 0);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.encoderInputBuffer.addFlag(4);
        this.encoderInputBuffer.flip();
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void computeNextEncoderInputBufferTimeUs(long bytesWritten, int bytesPerFrame, int sampleRate) {
        long numerator = bytesWritten * 1000000L + this.encoderBufferDurationRemainder;
        long denominator = (long)bytesPerFrame * (long)sampleRate;
        long bufferDurationUs = numerator / denominator;
        this.encoderBufferDurationRemainder = numerator - bufferDurationUs * denominator;
        if (this.encoderBufferDurationRemainder > 0L) {
            ++bufferDurationUs;
            this.encoderBufferDurationRemainder -= denominator;
        }
        this.nextEncoderInputBufferTimeUs += bufferDurationUs;
    }

    @Pure
    private static TransformationRequest createFallbackTransformationRequest(TransformationRequest transformationRequest, Format requestedFormat, Format actualFormat) {
        if (Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)actualFormat.sampleMimeType)) {
            return transformationRequest;
        }
        return transformationRequest.buildUpon().setAudioMimeType(actualFormat.sampleMimeType).build();
    }
}

