/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.media.MediaFormat;
import android.view.Surface;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.MediaFormatUtil;
import androidx.media3.common.util.Util;
import androidx.media3.transformer.Codec;
import androidx.media3.transformer.DefaultCodec;
import androidx.media3.transformer.EncoderUtil;
import androidx.media3.transformer.TransformationException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class DefaultDecoderFactory
implements Codec.DecoderFactory {
    DefaultDecoderFactory() {
    }

    @Override
    public Codec createForAudioDecoding(Format format) throws TransformationException {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)format.maxInputSize);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        String mediaCodecName = EncoderUtil.findCodecForFormat(mediaFormat, true);
        if (mediaCodecName == null) {
            throw DefaultDecoderFactory.createTransformationException(format);
        }
        return new DefaultCodec(format, mediaFormat, mediaCodecName, true, null);
    }

    @Override
    public Codec createForVideoDecoding(Format format, Surface outputSurface, boolean enableRequestSdrToneMapping) throws TransformationException {
        String mediaCodecName;
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.width, (int)format.height);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"rotation-degrees", (int)format.rotationDegrees);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)format.maxInputSize);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        if (Util.SDK_INT >= 29) {
            mediaFormat.setInteger("allow-frame-drop", 0);
        }
        if (Util.SDK_INT >= 31 && enableRequestSdrToneMapping) {
            mediaFormat.setInteger("color-transfer-request", 3);
        }
        if ((mediaCodecName = EncoderUtil.findCodecForFormat(mediaFormat, true)) == null) {
            throw DefaultDecoderFactory.createTransformationException(format);
        }
        return new DefaultCodec(format, mediaFormat, mediaCodecName, true, outputSurface);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static TransformationException createTransformationException(Format format) {
        return TransformationException.createForCodec((Throwable)new IllegalArgumentException("The requested decoding format is not supported."), MimeTypes.isVideo((String)format.sampleMimeType), true, format, null, 3003);
    }
}

