/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Size;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.transformer.Codec;
import androidx.media3.transformer.DefaultCodec;
import androidx.media3.transformer.EncoderSelector;
import androidx.media3.transformer.EncoderUtil;
import androidx.media3.transformer.TransformationException;
import androidx.media3.transformer.VideoEncoderSettings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class DefaultEncoderFactory
implements Codec.EncoderFactory {
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final String TAG = "DefaultEncoderFactory";
    private final EncoderSelector videoEncoderSelector;
    private final VideoEncoderSettings requestedVideoEncoderSettings;
    private final boolean enableFallback;

    public DefaultEncoderFactory() {
        this(EncoderSelector.DEFAULT, true);
    }

    public DefaultEncoderFactory(EncoderSelector videoEncoderSelector, boolean enableFallback) {
        this(videoEncoderSelector, VideoEncoderSettings.DEFAULT, enableFallback);
    }

    public DefaultEncoderFactory(EncoderSelector videoEncoderSelector, VideoEncoderSettings requestedVideoEncoderSettings, boolean enableFallback) {
        this.videoEncoderSelector = videoEncoderSelector;
        this.requestedVideoEncoderSettings = requestedVideoEncoderSettings;
        this.enableFallback = enableFallback;
    }

    @Override
    public Codec createForAudioEncoding(Format format, List<String> allowedMimeTypes) throws TransformationException {
        Assertions.checkArgument((!allowedMimeTypes.isEmpty() ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)format.sampleMimeType);
        if (!allowedMimeTypes.contains(format.sampleMimeType)) {
            if (this.enableFallback) {
                format = format.buildUpon().setSampleMimeType(allowedMimeTypes.get(0)).build();
            } else {
                throw DefaultEncoderFactory.createTransformationException(format);
            }
        }
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        mediaFormat.setInteger("bitrate", format.bitrate);
        String mediaCodecName = EncoderUtil.findCodecForFormat(mediaFormat, false);
        if (mediaCodecName == null) {
            throw DefaultEncoderFactory.createTransformationException(format);
        }
        return new DefaultCodec(format, mediaFormat, mediaCodecName, false, null);
    }

    @Override
    public Codec createForVideoEncoding(Format format, List<String> allowedMimeTypes) throws TransformationException {
        if (format.frameRate == -1.0f) {
            format = format.buildUpon().setFrameRate(30.0f).build();
        }
        Assertions.checkArgument((format.width != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height <= format.width ? 1 : 0) != 0);
        Assertions.checkArgument((format.rotationDegrees == 0 ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)format.sampleMimeType);
        Assertions.checkArgument((!allowedMimeTypes.isEmpty() ? 1 : 0) != 0);
        Assertions.checkStateNotNull((Object)this.videoEncoderSelector);
        VideoEncoderQueryResult encoderAndClosestFormatSupport = DefaultEncoderFactory.findEncoderWithClosestFormatSupport(format, this.requestedVideoEncoderSettings, this.videoEncoderSelector, allowedMimeTypes, this.enableFallback);
        if (encoderAndClosestFormatSupport == null) {
            throw DefaultEncoderFactory.createTransformationException(format);
        }
        MediaCodecInfo encoderInfo = encoderAndClosestFormatSupport.encoder;
        format = encoderAndClosestFormatSupport.supportedFormat;
        VideoEncoderSettings supportedVideoEncoderSettings = encoderAndClosestFormatSupport.supportedEncoderSettings;
        String mimeType = (String)Assertions.checkNotNull((Object)format.sampleMimeType);
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)mimeType, (int)format.width, (int)format.height);
        mediaFormat.setFloat("frame-rate", format.frameRate);
        mediaFormat.setInteger("bitrate", supportedVideoEncoderSettings.bitrate != -1 ? supportedVideoEncoderSettings.bitrate : DefaultEncoderFactory.getSuggestedBitrate(format.width, format.height, format.frameRate));
        mediaFormat.setInteger("bitrate-mode", supportedVideoEncoderSettings.bitrateMode);
        if (supportedVideoEncoderSettings.profile != -1 && supportedVideoEncoderSettings.level != -1 && Util.SDK_INT >= 23) {
            mediaFormat.setInteger("profile", supportedVideoEncoderSettings.profile);
            mediaFormat.setInteger("level", supportedVideoEncoderSettings.level);
        }
        if (mimeType.equals("video/avc")) {
            DefaultEncoderFactory.adjustMediaFormatForH264EncoderSettings(mediaFormat, encoderInfo);
        }
        mediaFormat.setInteger("color-format", supportedVideoEncoderSettings.colorProfile);
        if (Util.SDK_INT >= 25) {
            mediaFormat.setFloat("i-frame-interval", supportedVideoEncoderSettings.iFrameIntervalSeconds);
        } else {
            float iFrameIntervalSeconds = supportedVideoEncoderSettings.iFrameIntervalSeconds;
            mediaFormat.setInteger("i-frame-interval", iFrameIntervalSeconds > 0.0f && iFrameIntervalSeconds <= 1.0f ? 1 : (int)Math.floor(iFrameIntervalSeconds));
        }
        if (Util.SDK_INT >= 23) {
            if (supportedVideoEncoderSettings.operatingRate != -1) {
                mediaFormat.setInteger("operating-rate", supportedVideoEncoderSettings.operatingRate);
            }
            if (supportedVideoEncoderSettings.priority != -1) {
                mediaFormat.setInteger("priority", supportedVideoEncoderSettings.priority);
            }
        }
        return new DefaultCodec(format, mediaFormat, encoderInfo.getName(), false, null);
    }

    @Override
    public boolean videoNeedsEncoding() {
        return !this.requestedVideoEncoderSettings.equals(VideoEncoderSettings.DEFAULT);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    @Nullable
    private static VideoEncoderQueryResult findEncoderWithClosestFormatSupport(Format requestedFormat, VideoEncoderSettings videoEncoderSettings, EncoderSelector encoderSelector, List<String> allowedMimeTypes, boolean enableFallback) {
        String requestedMimeType = requestedFormat.sampleMimeType;
        String mimeType = DefaultEncoderFactory.findFallbackMimeType(encoderSelector, requestedMimeType, allowedMimeTypes);
        if (mimeType == null || !enableFallback && !requestedMimeType.equals(mimeType)) {
            return null;
        }
        List<MediaCodecInfo> encodersForMimeType = encoderSelector.selectEncoderInfos(mimeType);
        if (encodersForMimeType.isEmpty()) {
            return null;
        }
        if (!enableFallback) {
            return new VideoEncoderQueryResult(encodersForMimeType.get(0), requestedFormat, videoEncoderSettings);
        }
        ImmutableList<MediaCodecInfo> filteredEncoders = DefaultEncoderFactory.filterEncodersByResolution(encodersForMimeType, mimeType, requestedFormat.width, requestedFormat.height);
        if (filteredEncoders.isEmpty()) {
            return null;
        }
        Size finalResolution = (Size)Assertions.checkNotNull((Object)EncoderUtil.getSupportedResolution((MediaCodecInfo)filteredEncoders.get(0), mimeType, requestedFormat.width, requestedFormat.height));
        int requestedBitrate = videoEncoderSettings.bitrate != -1 ? videoEncoderSettings.bitrate : DefaultEncoderFactory.getSuggestedBitrate(finalResolution.getWidth(), finalResolution.getHeight(), requestedFormat.frameRate);
        if ((filteredEncoders = DefaultEncoderFactory.filterEncodersByBitrate(filteredEncoders, mimeType, requestedBitrate)).isEmpty()) {
            return null;
        }
        if ((filteredEncoders = DefaultEncoderFactory.filterEncodersByBitrateMode(filteredEncoders, mimeType, videoEncoderSettings.bitrateMode)).isEmpty()) {
            return null;
        }
        MediaCodecInfo pickedEncoder = (MediaCodecInfo)filteredEncoders.get(0);
        int closestSupportedBitrate = (Integer)EncoderUtil.getSupportedBitrateRange(pickedEncoder, mimeType).clamp((Comparable)Integer.valueOf(requestedBitrate));
        VideoEncoderSettings.Builder supportedEncodingSettingBuilder = videoEncoderSettings.buildUpon().setBitrate(closestSupportedBitrate);
        if (videoEncoderSettings.profile == -1 || videoEncoderSettings.level == -1 || videoEncoderSettings.level > EncoderUtil.findHighestSupportedEncodingLevel(pickedEncoder, mimeType, videoEncoderSettings.profile)) {
            supportedEncodingSettingBuilder.setEncodingProfileLevel(-1, -1);
        }
        Format supportedEncoderFormat = requestedFormat.buildUpon().setSampleMimeType(mimeType).setWidth(finalResolution.getWidth()).setHeight(finalResolution.getHeight()).setAverageBitrate(closestSupportedBitrate).build();
        return new VideoEncoderQueryResult(pickedEncoder, supportedEncoderFormat, supportedEncodingSettingBuilder.build());
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByResolution(List<MediaCodecInfo> encoders, String mimeType, int requestedWidth, int requestedHeight) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> {
            Size closestSupportedResolution = EncoderUtil.getSupportedResolution(encoderInfo, mimeType, requestedWidth, requestedHeight);
            if (closestSupportedResolution == null) {
                return Integer.MAX_VALUE;
            }
            return Math.abs(requestedWidth * requestedHeight - closestSupportedResolution.getWidth() * closestSupportedResolution.getHeight());
        }, "resolution");
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByBitrate(List<MediaCodecInfo> encoders, String mimeType, int requestedBitrate) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> {
            int achievableBitrate = (Integer)EncoderUtil.getSupportedBitrateRange(encoderInfo, mimeType).clamp((Comparable)Integer.valueOf(requestedBitrate));
            return Math.abs(achievableBitrate - requestedBitrate);
        }, "bitrate");
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByBitrateMode(List<MediaCodecInfo> encoders, String mimeType, int requestedBitrateMode) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> EncoderUtil.isBitrateModeSupported(encoderInfo, mimeType, requestedBitrateMode) ? 0 : Integer.MAX_VALUE, "bitrate mode");
    }

    private static void adjustMediaFormatForH264EncoderSettings(MediaFormat mediaFormat, MediaCodecInfo encoderInfo) {
        String mimeType = "video/avc";
        if (Util.SDK_INT >= 29) {
            int expectedEncodingProfile = 8;
            int supportedEncodingLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            if (supportedEncodingLevel != -1) {
                mediaFormat.setInteger("profile", expectedEncodingProfile);
                mediaFormat.setInteger("level", supportedEncodingLevel);
                mediaFormat.setInteger("max-bframes", 1);
            }
        } else if (Util.SDK_INT >= 26) {
            int expectedEncodingProfile = 8;
            int supportedEncodingLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            if (supportedEncodingLevel != -1) {
                mediaFormat.setInteger("profile", expectedEncodingProfile);
                mediaFormat.setInteger("level", supportedEncodingLevel);
                mediaFormat.setInteger("latency", 1);
            }
        } else if (Util.SDK_INT >= 24) {
            int expectedEncodingProfile = 1;
            int supportedLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            Assertions.checkState((supportedLevel != -1 ? 1 : 0) != 0);
            mediaFormat.setInteger("profile", expectedEncodingProfile);
            mediaFormat.setInteger("level", supportedLevel);
        }
    }

    private static ImmutableList<MediaCodecInfo> filterEncoders(List<MediaCodecInfo> encoders, EncoderFallbackCost cost, String filterName) {
        ArrayList<MediaCodecInfo> filteredEncoders = new ArrayList<MediaCodecInfo>(encoders.size());
        int minGap = Integer.MAX_VALUE;
        for (int i = 0; i < encoders.size(); ++i) {
            MediaCodecInfo encoderInfo = encoders.get(i);
            int gap = cost.getParameterSupportGap(encoderInfo);
            if (gap == Integer.MAX_VALUE) continue;
            if (gap < minGap) {
                minGap = gap;
                filteredEncoders.clear();
                filteredEncoders.add(encoderInfo);
                continue;
            }
            if (gap != minGap) continue;
            filteredEncoders.add(encoderInfo);
        }
        ArrayList<MediaCodecInfo> removedEncoders = new ArrayList<MediaCodecInfo>(encoders);
        removedEncoders.removeAll(filteredEncoders);
        StringBuilder stringBuilder = new StringBuilder("Encoders removed for ").append(filterName).append(":\n");
        for (int i = 0; i < removedEncoders.size(); ++i) {
            MediaCodecInfo encoderInfo = (MediaCodecInfo)removedEncoders.get(i);
            stringBuilder.append(Util.formatInvariant((String)"  %s\n", (Object[])new Object[]{encoderInfo.getName()}));
        }
        Log.d((String)TAG, (String)stringBuilder.toString());
        return ImmutableList.copyOf(filteredEncoders);
    }

    @Nullable
    private static String findFallbackMimeType(EncoderSelector encoderSelector, String requestedMimeType, List<String> allowedMimeTypes) {
        if (DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, requestedMimeType, allowedMimeTypes)) {
            return requestedMimeType;
        }
        if (DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, "video/hevc", allowedMimeTypes)) {
            return "video/hevc";
        }
        if (DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, "video/avc", allowedMimeTypes)) {
            return "video/avc";
        }
        for (int i = 0; i < allowedMimeTypes.size(); ++i) {
            String allowedMimeType = allowedMimeTypes.get(i);
            if (!DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, allowedMimeType, allowedMimeTypes)) continue;
            return allowedMimeType;
        }
        return null;
    }

    private static boolean mimeTypeIsSupported(EncoderSelector encoderSelector, String mimeType, List<String> allowedMimeTypes) {
        return !encoderSelector.selectEncoderInfos(mimeType).isEmpty() && allowedMimeTypes.contains(mimeType);
    }

    private static int getSuggestedBitrate(int width, int height, float frameRate) {
        return (int)((double)((float)(width * height) * frameRate) * 0.07 * 2.0);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static TransformationException createTransformationException(Format format) {
        return TransformationException.createForCodec((Throwable)new IllegalArgumentException("The requested encoding format is not supported."), MimeTypes.isVideo((String)format.sampleMimeType), false, format, null, 4003);
    }

    private static interface EncoderFallbackCost {
        public int getParameterSupportGap(MediaCodecInfo var1);
    }

    private static final class VideoEncoderQueryResult {
        public final MediaCodecInfo encoder;
        public final Format supportedFormat;
        public final VideoEncoderSettings supportedEncoderSettings;

        public VideoEncoderQueryResult(MediaCodecInfo encoder, Format supportedFormat, VideoEncoderSettings supportedEncoderSettings) {
            this.encoder = encoder;
            this.supportedFormat = supportedFormat;
            this.supportedEncoderSettings = supportedEncoderSettings;
        }
    }
}

