/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.graphics.Matrix;
import android.util.Size;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.transformer.MatrixTransformation;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class EncoderCompatibilityTransformation
implements MatrixTransformation {
    private int outputRotationDegrees = -1;
    private @MonotonicNonNull Matrix transformationMatrix;

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.transformationMatrix = new Matrix();
        if (inputHeight > inputWidth) {
            this.outputRotationDegrees = 90;
            this.transformationMatrix.postRotate((float)this.outputRotationDegrees);
            return new Size(inputHeight, inputWidth);
        }
        this.outputRotationDegrees = 0;
        return new Size(inputWidth, inputHeight);
    }

    @Override
    public Matrix getMatrix(long presentationTimeUs) {
        return (Matrix)Assertions.checkStateNotNull((Object)this.transformationMatrix, (Object)"configure must be called first");
    }

    public int getOutputRotationDegrees() {
        Assertions.checkState((this.outputRotationDegrees != -1 ? 1 : 0) != 0, (Object)"configure must be called before getOutputRotationDegrees");
        return this.outputRotationDegrees;
    }

    static {
        GlUtil.glAssertionsEnabled = true;
    }
}

