/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.content.Context;
import android.opengl.GLES20;
import android.util.Size;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.transformer.FrameProcessingException;
import androidx.media3.transformer.SingleFrameGlTextureProcessor;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class ExternalTextureProcessor
implements SingleFrameGlTextureProcessor {
    private static final String VERTEX_SHADER_TEX_TRANSFORM_PATH = "shaders/vertex_shader_tex_transform_es2.glsl";
    private static final String VERTEX_SHADER_TEX_TRANSFORM_ES3_PATH = "shaders/vertex_shader_tex_transform_es3.glsl";
    private static final String FRAGMENT_SHADER_COPY_EXTERNAL_PATH = "shaders/fragment_shader_copy_external_es2.glsl";
    private static final String FRAGMENT_SHADER_COPY_EXTERNAL_YUV_ES3_PATH = "shaders/fragment_shader_copy_external_yuv_es3.glsl";
    private static final float[] MATRIX_YUV_TO_BT2020_COLOR_TRANSFORM;
    private final boolean enableExperimentalHdrEditing;
    private @MonotonicNonNull Size size;
    private @MonotonicNonNull GlProgram glProgram;

    public ExternalTextureProcessor(boolean enableExperimentalHdrEditing) {
        this.enableExperimentalHdrEditing = enableExperimentalHdrEditing;
    }

    @Override
    public void initialize(Context context, int inputTexId, int inputWidth, int inputHeight) throws IOException {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.size = new Size(inputWidth, inputHeight);
        String vertexShaderFilePath = this.enableExperimentalHdrEditing ? VERTEX_SHADER_TEX_TRANSFORM_ES3_PATH : VERTEX_SHADER_TEX_TRANSFORM_PATH;
        String fragmentShaderFilePath = this.enableExperimentalHdrEditing ? FRAGMENT_SHADER_COPY_EXTERNAL_YUV_ES3_PATH : FRAGMENT_SHADER_COPY_EXTERNAL_PATH;
        this.glProgram = new GlProgram(context, vertexShaderFilePath, fragmentShaderFilePath);
        this.glProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
        this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
        if (this.enableExperimentalHdrEditing) {
            this.glProgram.setFloatsUniform("uColorTransform", MATRIX_YUV_TO_BT2020_COLOR_TRANSFORM);
        }
    }

    @Override
    public Size getOutputSize() {
        return (Size)Assertions.checkStateNotNull((Object)this.size);
    }

    public void setTextureTransformMatrix(float[] textureTransformMatrix) {
        Assertions.checkStateNotNull((Object)this.glProgram);
        this.glProgram.setFloatsUniform("uTexTransform", textureTransformMatrix);
    }

    @Override
    public void drawFrame(long presentationTimeUs) throws FrameProcessingException {
        Assertions.checkStateNotNull((Object)this.glProgram);
        try {
            this.glProgram.use();
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw new FrameProcessingException(e);
        }
    }

    @Override
    public void release() {
        if (this.glProgram != null) {
            this.glProgram.delete();
        }
    }

    static {
        GlUtil.glAssertionsEnabled = true;
        MATRIX_YUV_TO_BT2020_COLOR_TRANSFORM = new float[]{1.168f, 1.168f, 1.168f, 0.0f, -0.188f, 2.148f, 1.683f, -0.652f, 0.0f};
    }
}

