/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Size;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.transformer.FrameProcessingException;
import androidx.media3.transformer.GlMatrixTransformation;
import androidx.media3.transformer.MatrixTransformation;
import androidx.media3.transformer.MatrixUtils;
import androidx.media3.transformer.SingleFrameGlTextureProcessor;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
final class MatrixTransformationProcessor
implements SingleFrameGlTextureProcessor {
    private static final String VERTEX_SHADER_TRANSFORMATION_PATH = "shaders/vertex_shader_transformation_es2.glsl";
    private static final String FRAGMENT_SHADER_PATH = "shaders/fragment_shader_copy_es2.glsl";
    private static final ImmutableList<float[]> NDC_SQUARE;
    private final ImmutableList<GlMatrixTransformation> matrixTransformations;
    private final float[][] transformationMatrixCache;
    private final float[] compositeTransformationMatrix;
    private final float[] tempResultMatrix;
    private ImmutableList<float[]> visiblePolygon;
    private @MonotonicNonNull Size outputSize;
    private @MonotonicNonNull GlProgram glProgram;

    public MatrixTransformationProcessor(MatrixTransformation matrixTransformation) {
        this((ImmutableList<GlMatrixTransformation>)ImmutableList.of((Object)matrixTransformation));
    }

    public MatrixTransformationProcessor(GlMatrixTransformation matrixTransformation) {
        this((ImmutableList<GlMatrixTransformation>)ImmutableList.of((Object)matrixTransformation));
    }

    public MatrixTransformationProcessor(ImmutableList<GlMatrixTransformation> matrixTransformations) {
        this.matrixTransformations = matrixTransformations;
        this.transformationMatrixCache = new float[matrixTransformations.size()][16];
        this.compositeTransformationMatrix = new float[16];
        this.tempResultMatrix = new float[16];
        Matrix.setIdentityM((float[])this.compositeTransformationMatrix, (int)0);
        this.visiblePolygon = NDC_SQUARE;
    }

    @Override
    public void initialize(Context context, int inputTexId, int inputWidth, int inputHeight) throws IOException {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.outputSize = new Size(inputWidth, inputHeight);
        for (int i = 0; i < this.matrixTransformations.size(); ++i) {
            this.outputSize = ((GlMatrixTransformation)this.matrixTransformations.get(i)).configure(this.outputSize.getWidth(), this.outputSize.getHeight());
        }
        this.glProgram = new GlProgram(context, VERTEX_SHADER_TRANSFORMATION_PATH, FRAGMENT_SHADER_PATH);
        this.glProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
    }

    @Override
    public Size getOutputSize() {
        return (Size)Assertions.checkStateNotNull((Object)this.outputSize);
    }

    @Override
    public void drawFrame(long presentationTimeUs) throws FrameProcessingException {
        this.updateCompositeTransformationMatrixAndVisiblePolygon(presentationTimeUs);
        if (this.visiblePolygon.size() < 3) {
            return;
        }
        try {
            ((GlProgram)Assertions.checkStateNotNull((Object)this.glProgram)).use();
            this.glProgram.setFloatsUniform("uTransformationMatrix", this.compositeTransformationMatrix);
            this.glProgram.setBufferAttribute("aFramePosition", GlUtil.createVertexBuffer(this.visiblePolygon), 4);
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)6, (int)0, (int)this.visiblePolygon.size());
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw new FrameProcessingException(e, presentationTimeUs);
        }
    }

    @Override
    public void release() {
        if (this.glProgram != null) {
            this.glProgram.delete();
        }
    }

    private void updateCompositeTransformationMatrixAndVisiblePolygon(long presentationTimeUs) {
        if (!this.updateTransformationMatrixCache(presentationTimeUs)) {
            return;
        }
        Matrix.setIdentityM((float[])this.compositeTransformationMatrix, (int)0);
        this.visiblePolygon = NDC_SQUARE;
        for (float[] transformationMatrix : this.transformationMatrixCache) {
            Matrix.multiplyMM((float[])this.tempResultMatrix, (int)0, (float[])transformationMatrix, (int)0, (float[])this.compositeTransformationMatrix, (int)0);
            System.arraycopy(this.tempResultMatrix, 0, this.compositeTransformationMatrix, 0, this.tempResultMatrix.length);
            this.visiblePolygon = MatrixUtils.clipConvexPolygonToNdcRange(MatrixUtils.transformPoints(transformationMatrix, this.visiblePolygon));
            if (this.visiblePolygon.size() >= 3) continue;
            return;
        }
        Matrix.invertM((float[])this.tempResultMatrix, (int)0, (float[])this.compositeTransformationMatrix, (int)0);
        this.visiblePolygon = MatrixUtils.transformPoints(this.tempResultMatrix, this.visiblePolygon);
    }

    private boolean updateTransformationMatrixCache(long presentationTimeUs) {
        boolean matrixChanged = false;
        for (int i = 0; i < this.matrixTransformations.size(); ++i) {
            float[] cachedMatrix = this.transformationMatrixCache[i];
            float[] matrix = ((GlMatrixTransformation)this.matrixTransformations.get(i)).getGlMatrixArray(presentationTimeUs);
            if (Arrays.equals(cachedMatrix, matrix)) continue;
            Assertions.checkState((matrix.length == 16 ? 1 : 0) != 0, (Object)"A 4x4 transformation matrix must have 16 elements");
            System.arraycopy(matrix, 0, cachedMatrix, 0, matrix.length);
            matrixChanged = true;
        }
        return matrixChanged;
    }

    static {
        GlUtil.glAssertionsEnabled = true;
        NDC_SQUARE = ImmutableList.of((Object)new float[]{-1.0f, -1.0f, 0.0f, 1.0f}, (Object)new float[]{-1.0f, 1.0f, 0.0f, 1.0f}, (Object)new float[]{1.0f, 1.0f, 0.0f, 1.0f}, (Object)new float[]{1.0f, -1.0f, 0.0f, 1.0f});
    }
}

