/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.opengl.Matrix;
import androidx.media3.common.util.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;

final class MatrixUtils {
    private static final float[][] NDC_CUBE = new float[][]{{1.0f, 0.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, -1.0f, 1.0f}};

    public static float[] getGlMatrixArray(android.graphics.Matrix matrix) {
        float[] matrix3x3Array = new float[9];
        matrix.getValues(matrix3x3Array);
        float[] matrix4x4Array = MatrixUtils.getMatrix4x4Array(matrix3x3Array);
        float[] transposedMatrix4x4Array = new float[16];
        Matrix.transposeM((float[])transposedMatrix4x4Array, (int)0, (float[])matrix4x4Array, (int)0);
        return transposedMatrix4x4Array;
    }

    private static float[] getMatrix4x4Array(float[] matrix3x3Array) {
        float[] matrix4x4Array = new float[16];
        matrix4x4Array[10] = 1.0f;
        for (int inputRow = 0; inputRow < 3; ++inputRow) {
            for (int inputColumn = 0; inputColumn < 3; ++inputColumn) {
                int outputRow = inputRow == 2 ? 3 : inputRow;
                int outputColumn = inputColumn == 2 ? 3 : inputColumn;
                matrix4x4Array[outputRow * 4 + outputColumn] = matrix3x3Array[inputRow * 3 + inputColumn];
            }
        }
        return matrix4x4Array;
    }

    public static ImmutableList<float[]> clipConvexPolygonToNdcRange(ImmutableList<float[]> polygonVertices) {
        Assertions.checkArgument((polygonVertices.size() >= 3 ? 1 : 0) != 0, (Object)"A polygon must have at least 3 vertices.");
        ImmutableList.Builder outputVertices = new ImmutableList.Builder().addAll(polygonVertices);
        for (float[] clippingPlane : NDC_CUBE) {
            ImmutableList inputVertices = outputVertices.build();
            outputVertices = new ImmutableList.Builder();
            for (int i = 0; i < inputVertices.size(); ++i) {
                float[] intersection;
                float[] currentVertex = (float[])inputVertices.get(i);
                float[] previousVertex = (float[])inputVertices.get((inputVertices.size() + i - 1) % inputVertices.size());
                if (MatrixUtils.isInsideClippingHalfSpace(currentVertex, clippingPlane)) {
                    float[] intersectionPoint;
                    if (!MatrixUtils.isInsideClippingHalfSpace(previousVertex, clippingPlane) && !Arrays.equals(currentVertex, intersectionPoint = MatrixUtils.computeIntersectionPoint(clippingPlane, clippingPlane, previousVertex, currentVertex))) {
                        outputVertices.add((Object)intersectionPoint);
                    }
                    outputVertices.add((Object)currentVertex);
                    continue;
                }
                if (!MatrixUtils.isInsideClippingHalfSpace(previousVertex, clippingPlane) || Arrays.equals(previousVertex, intersection = MatrixUtils.computeIntersectionPoint(clippingPlane, clippingPlane, previousVertex, currentVertex))) continue;
                outputVertices.add((Object)intersection);
            }
        }
        return outputVertices.build();
    }

    private static boolean isInsideClippingHalfSpace(float[] point, float[] clippingPlane) {
        Assertions.checkArgument((clippingPlane.length == 4 ? 1 : 0) != 0, (Object)"Expecting 4 plane parameters");
        return clippingPlane[0] * point[0] + clippingPlane[1] * point[1] + clippingPlane[2] * point[2] <= clippingPlane[3];
    }

    private static float[] computeIntersectionPoint(float[] planePoint, float[] planeParameters, float[] linePoint1, float[] linePoint2) {
        Assertions.checkArgument((planeParameters.length == 4 ? 1 : 0) != 0, (Object)"Expecting 4 plane parameters");
        float lineEquationParameter = ((planePoint[0] - linePoint1[0]) * planeParameters[0] + (planePoint[1] - linePoint1[1]) * planeParameters[1] + (planePoint[2] - linePoint1[2]) * planeParameters[2]) / ((linePoint2[0] - linePoint1[0]) * planeParameters[0] + (linePoint2[1] - linePoint1[1]) * planeParameters[1] + (linePoint2[2] - linePoint1[2]) * planeParameters[2]);
        float x = linePoint1[0] + (linePoint2[0] - linePoint1[0]) * lineEquationParameter;
        float y = linePoint1[1] + (linePoint2[1] - linePoint1[1]) * lineEquationParameter;
        float z = linePoint1[2] + (linePoint2[2] - linePoint1[2]) * lineEquationParameter;
        return new float[]{x, y, z, 1.0f};
    }

    public static ImmutableList<float[]> transformPoints(float[] transformationMatrix, ImmutableList<float[]> points) {
        ImmutableList.Builder transformedPoints = new ImmutableList.Builder();
        for (int i = 0; i < points.size(); ++i) {
            float[] transformedPoint = new float[4];
            Matrix.multiplyMV((float[])transformedPoint, (int)0, (float[])transformationMatrix, (int)0, (float[])((float[])points.get(i)), (int)0);
            transformedPoint[0] = transformedPoint[0] / transformedPoint[3];
            transformedPoint[1] = transformedPoint[1] / transformedPoint[3];
            transformedPoint[2] = transformedPoint[2] / transformedPoint[3];
            transformedPoint[3] = 1.0f;
            transformedPoints.add((Object)transformedPoint);
        }
        return transformedPoints.build();
    }

    private MatrixUtils() {
    }
}

