/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.transformer.Muxer;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;

final class MuxerWrapper {
    private static final long MAX_TRACK_WRITE_AHEAD_US = Util.msToUs((long)500L);
    private final Muxer muxer;
    private final Muxer.Factory muxerFactory;
    private final SparseIntArray trackTypeToIndex;
    private final SparseIntArray trackTypeToSampleCount;
    private final SparseLongArray trackTypeToTimeUs;
    private final SparseLongArray trackTypeToBytesWritten;
    private final String containerMimeType;
    private int trackCount;
    private int trackFormatCount;
    private boolean isReady;
    private int previousTrackType;
    private long minTrackTimeUs;

    public MuxerWrapper(Muxer muxer, Muxer.Factory muxerFactory, String containerMimeType) {
        this.muxer = muxer;
        this.muxerFactory = muxerFactory;
        this.containerMimeType = containerMimeType;
        this.trackTypeToIndex = new SparseIntArray();
        this.trackTypeToSampleCount = new SparseIntArray();
        this.trackTypeToTimeUs = new SparseLongArray();
        this.trackTypeToBytesWritten = new SparseLongArray();
        this.previousTrackType = -2;
    }

    public void registerTrack() {
        Assertions.checkState((this.trackFormatCount == 0 ? 1 : 0) != 0, (Object)"Tracks cannot be registered after track formats have been added.");
        ++this.trackCount;
    }

    public boolean supportsSampleMimeType(@Nullable String mimeType) {
        return this.muxerFactory.supportsSampleMimeType(mimeType, this.containerMimeType);
    }

    public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
        return this.muxerFactory.getSupportedSampleMimeTypes(trackType, this.containerMimeType);
    }

    public void addTrackFormat(Format format) throws Muxer.MuxerException {
        Assertions.checkState((this.trackCount > 0 ? 1 : 0) != 0, (Object)"All tracks should be registered before the formats are added.");
        Assertions.checkState((this.trackFormatCount < this.trackCount ? 1 : 0) != 0, (Object)"All track formats have already been added.");
        String sampleMimeType = format.sampleMimeType;
        boolean isAudio = MimeTypes.isAudio((String)sampleMimeType);
        boolean isVideo = MimeTypes.isVideo((String)sampleMimeType);
        Assertions.checkState((isAudio || isVideo ? 1 : 0) != 0, (Object)("Unsupported track format: " + sampleMimeType));
        int trackType = MimeTypes.getTrackType((String)sampleMimeType);
        Assertions.checkState((this.trackTypeToIndex.get(trackType, -1) == -1 ? 1 : 0) != 0, (Object)("There is already a track of type " + trackType));
        int trackIndex = this.muxer.addTrack(format);
        this.trackTypeToIndex.put(trackType, trackIndex);
        this.trackTypeToSampleCount.put(trackType, 0);
        this.trackTypeToTimeUs.put(trackType, 0L);
        this.trackTypeToBytesWritten.put(trackType, 0L);
        ++this.trackFormatCount;
        if (this.trackFormatCount == this.trackCount) {
            this.isReady = true;
        }
    }

    public boolean writeSample(int trackType, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) throws Muxer.MuxerException {
        int trackIndex = this.trackTypeToIndex.get(trackType, -1);
        Assertions.checkState((trackIndex != -1 ? 1 : 0) != 0, (Object)("Could not write sample because there is no track of type " + trackType));
        if (!this.canWriteSampleOfType(trackType)) {
            return false;
        }
        this.trackTypeToSampleCount.put(trackType, this.trackTypeToSampleCount.get(trackType) + 1);
        this.trackTypeToBytesWritten.put(trackType, this.trackTypeToBytesWritten.get(trackType) + (long)data.remaining());
        if (this.trackTypeToTimeUs.get(trackType) < presentationTimeUs) {
            this.trackTypeToTimeUs.put(trackType, presentationTimeUs);
        }
        this.muxer.writeSampleData(trackIndex, data, isKeyFrame, presentationTimeUs);
        this.previousTrackType = trackType;
        return true;
    }

    public void endTrack(int trackType) {
        this.trackTypeToIndex.delete(trackType);
    }

    public void release(boolean forCancellation) throws Muxer.MuxerException {
        this.isReady = false;
        this.muxer.release(forCancellation);
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public int getTrackAverageBitrate(int trackType) {
        long trackDurationUs = this.trackTypeToTimeUs.get(trackType, -1L);
        long trackBytes = this.trackTypeToBytesWritten.get(trackType, -1L);
        if (trackDurationUs <= 0L || trackBytes <= 0L) {
            return -2147483647;
        }
        return (int)Util.scaleLargeTimestamp((long)trackBytes, (long)8000000L, (long)trackDurationUs);
    }

    public int getTrackSampleCount(int trackType) {
        return this.trackTypeToSampleCount.get(trackType, 0);
    }

    public long getDurationMs() {
        return Util.usToMs((long)Util.maxValue((SparseLongArray)this.trackTypeToTimeUs));
    }

    private boolean canWriteSampleOfType(int trackType) {
        long trackTimeUs = this.trackTypeToTimeUs.get(trackType, -9223372036854775807L);
        Assertions.checkState((trackTimeUs != -9223372036854775807L ? 1 : 0) != 0);
        if (!this.isReady) {
            return false;
        }
        if (this.trackTypeToIndex.size() == 1) {
            return true;
        }
        if (trackType != this.previousTrackType) {
            this.minTrackTimeUs = Util.minValue((SparseLongArray)this.trackTypeToTimeUs);
        }
        return trackTimeUs - this.minTrackTimeUs <= MAX_TRACK_WRITE_AHEAD_US;
    }
}

