/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.transformer.FallbackListener;
import androidx.media3.transformer.SamplePipeline;
import androidx.media3.transformer.TransformationRequest;

final class PassthroughSamplePipeline
implements SamplePipeline {
    private final DecoderInputBuffer buffer;
    private final Format format;
    private boolean hasPendingBuffer;

    public PassthroughSamplePipeline(Format format, TransformationRequest transformationRequest, FallbackListener fallbackListener) {
        this.format = format;
        this.buffer = new DecoderInputBuffer(2);
        this.hasPendingBuffer = false;
        fallbackListener.onTransformationRequestFinalized(transformationRequest);
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() {
        return this.hasPendingBuffer ? null : this.buffer;
    }

    @Override
    public void queueInputBuffer() {
        this.hasPendingBuffer = true;
    }

    @Override
    public boolean processData() {
        return false;
    }

    @Override
    public Format getOutputFormat() {
        return this.format;
    }

    @Override
    @Nullable
    public DecoderInputBuffer getOutputBuffer() {
        return this.hasPendingBuffer ? this.buffer : null;
    }

    @Override
    public void releaseOutputBuffer() {
        this.buffer.clear();
        this.hasPendingBuffer = false;
    }

    @Override
    public boolean isEnded() {
        return this.buffer.isEndOfStream();
    }

    @Override
    public void release() {
    }
}

