/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.graphics.Matrix;
import android.util.Size;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.transformer.MatrixTransformation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class Presentation
implements MatrixTransformation {
    public static final int LAYOUT_SCALE_TO_FIT = 0;
    public static final int LAYOUT_SCALE_TO_FIT_WITH_CROP = 1;
    public static final int LAYOUT_STRETCH_TO_FIT = 2;
    private final int requestedHeightPixels;
    private final float cropLeft;
    private final float cropRight;
    private final float cropBottom;
    private final float cropTop;
    private final float requestedAspectRatio;
    private final int layout;
    private float outputWidth;
    private float outputHeight;
    private @MonotonicNonNull Matrix transformationMatrix;

    private Presentation(int requestedHeightPixels, float cropLeft, float cropRight, float cropBottom, float cropTop, float requestedAspectRatio, int layout) {
        this.requestedHeightPixels = requestedHeightPixels;
        this.cropLeft = cropLeft;
        this.cropRight = cropRight;
        this.cropBottom = cropBottom;
        this.cropTop = cropTop;
        this.requestedAspectRatio = requestedAspectRatio;
        this.layout = layout;
        this.outputWidth = -1.0f;
        this.outputHeight = -1.0f;
        this.transformationMatrix = new Matrix();
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.transformationMatrix = new Matrix();
        this.outputWidth = inputWidth;
        this.outputHeight = inputHeight;
        if (this.cropLeft != -1.0f || this.cropRight != 1.0f || this.cropBottom != -1.0f || this.cropTop != 1.0f) {
            Assertions.checkState((this.requestedAspectRatio == -1.0f ? 1 : 0) != 0, (Object)"aspect ratio and crop cannot both be set in the same instance");
            this.applyCrop();
        } else if (this.requestedAspectRatio != -1.0f) {
            this.applyAspectRatio();
        }
        if (this.requestedHeightPixels != -1 && (float)this.requestedHeightPixels != this.outputHeight) {
            this.outputWidth = (float)this.requestedHeightPixels * this.outputWidth / this.outputHeight;
            this.outputHeight = this.requestedHeightPixels;
        }
        return new Size(Math.round(this.outputWidth), Math.round(this.outputHeight));
    }

    @Override
    public Matrix getMatrix(long presentationTimeUs) {
        return (Matrix)Assertions.checkStateNotNull((Object)this.transformationMatrix, (Object)"configure must be called first");
    }

    @RequiresNonNull(value={"transformationMatrix"})
    private void applyCrop() {
        float scaleX = (this.cropRight - this.cropLeft) / 2.0f;
        float scaleY = (this.cropTop - this.cropBottom) / 2.0f;
        float centerX = (this.cropLeft + this.cropRight) / 2.0f;
        float centerY = (this.cropBottom + this.cropTop) / 2.0f;
        this.transformationMatrix.postTranslate(-centerX, -centerY);
        this.transformationMatrix.postScale(1.0f / scaleX, 1.0f / scaleY);
        this.outputWidth *= scaleX;
        this.outputHeight *= scaleY;
    }

    @RequiresNonNull(value={"transformationMatrix"})
    private void applyAspectRatio() {
        float inputAspectRatio = this.outputWidth / this.outputHeight;
        if (this.layout == 0) {
            if (this.requestedAspectRatio > inputAspectRatio) {
                this.transformationMatrix.setScale(inputAspectRatio / this.requestedAspectRatio, 1.0f);
                this.outputWidth = this.outputHeight * this.requestedAspectRatio;
            } else {
                this.transformationMatrix.setScale(1.0f, this.requestedAspectRatio / inputAspectRatio);
                this.outputHeight = this.outputWidth / this.requestedAspectRatio;
            }
        } else if (this.layout == 1) {
            if (this.requestedAspectRatio > inputAspectRatio) {
                this.transformationMatrix.setScale(1.0f, this.requestedAspectRatio / inputAspectRatio);
                this.outputHeight = this.outputWidth / this.requestedAspectRatio;
            } else {
                this.transformationMatrix.setScale(inputAspectRatio / this.requestedAspectRatio, 1.0f);
                this.outputWidth = this.outputHeight * this.requestedAspectRatio;
            }
        } else if (this.layout == 2) {
            if (this.requestedAspectRatio > inputAspectRatio) {
                this.outputWidth = this.outputHeight * this.requestedAspectRatio;
            } else {
                this.outputHeight = this.outputWidth / this.requestedAspectRatio;
            }
        }
    }

    static {
        GlUtil.glAssertionsEnabled = true;
    }

    public static final class Builder {
        private int heightPixels = -1;
        private float cropLeft = -1.0f;
        private float cropRight = 1.0f;
        private float cropBottom = -1.0f;
        private float cropTop = 1.0f;
        private float aspectRatio = -1.0f;
        private int layout;

        public Builder setResolution(int height) {
            this.heightPixels = height;
            return this;
        }

        public Builder setCrop(float left, float right, float bottom, float top) {
            Assertions.checkArgument((right > left ? 1 : 0) != 0, (Object)("right value " + right + " should be greater than left value " + left));
            Assertions.checkArgument((top > bottom ? 1 : 0) != 0, (Object)("top value " + top + " should be greater than bottom value " + bottom));
            Assertions.checkState((this.aspectRatio == -1.0f ? 1 : 0) != 0, (Object)"setAspectRatio and setCrop cannot be called in the same instance");
            this.cropLeft = left;
            this.cropRight = right;
            this.cropBottom = bottom;
            this.cropTop = top;
            return this;
        }

        public Builder setAspectRatio(float aspectRatio, int layout) {
            Assertions.checkArgument((aspectRatio > 0.0f ? 1 : 0) != 0, (Object)("aspect ratio " + aspectRatio + " must be positive"));
            Assertions.checkArgument((layout == 0 || layout == 1 || layout == 2 ? 1 : 0) != 0, (Object)("invalid layout " + layout));
            Assertions.checkState((this.cropLeft == -1.0f && this.cropRight == 1.0f && this.cropBottom == -1.0f && this.cropTop == 1.0f ? 1 : 0) != 0, (Object)"setAspectRatio and setCrop cannot be called in the same instance");
            this.aspectRatio = aspectRatio;
            this.layout = layout;
            return this;
        }

        public Presentation build() {
            return new Presentation(this.heightPixels, this.cropLeft, this.cropRight, this.cropBottom, this.cropTop, this.aspectRatio, this.layout);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Layout {
    }
}

