/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import androidx.media3.common.Format;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.metadata.mp4.SlowMotionData;
import androidx.media3.extractor.metadata.mp4.SmtaMetadataEntry;
import androidx.media3.transformer.SpeedProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

class SegmentSpeedProvider
implements SpeedProvider {
    private static final int INPUT_FRAME_RATE = 30;
    private final ImmutableSortedMap<Long, Float> speedsByStartTimeUs;
    private final float baseSpeedMultiplier;

    public SegmentSpeedProvider(Format format) {
        float captureFrameRate = SegmentSpeedProvider.getCaptureFrameRate(format);
        this.baseSpeedMultiplier = captureFrameRate == -3.4028235E38f ? 1.0f : captureFrameRate / 30.0f;
        this.speedsByStartTimeUs = SegmentSpeedProvider.buildSpeedByStartTimeUsMap(format, this.baseSpeedMultiplier);
    }

    @Override
    public float getSpeed(long timeUs) {
        Assertions.checkArgument((timeUs >= 0L ? 1 : 0) != 0);
        Map.Entry entry = this.speedsByStartTimeUs.floorEntry((Object)timeUs);
        return entry != null ? ((Float)entry.getValue()).floatValue() : this.baseSpeedMultiplier;
    }

    @Override
    public long getNextSpeedChangeTimeUs(long timeUs) {
        Assertions.checkArgument((timeUs >= 0L ? 1 : 0) != 0);
        Long nextTimeUs = (Long)this.speedsByStartTimeUs.higherKey((Object)timeUs);
        return nextTimeUs != null ? nextTimeUs : -9223372036854775807L;
    }

    private static ImmutableSortedMap<Long, Float> buildSpeedByStartTimeUsMap(Format format, float baseSpeed) {
        SlowMotionData.Segment currentSegment;
        int i;
        ImmutableList<SlowMotionData.Segment> segments = SegmentSpeedProvider.extractSlowMotionSegments(format);
        if (segments.isEmpty()) {
            return ImmutableSortedMap.of();
        }
        TreeMap<Long, Float> speedsByStartTimeUs = new TreeMap<Long, Float>();
        for (i = 0; i < segments.size(); ++i) {
            currentSegment = (SlowMotionData.Segment)segments.get(i);
            speedsByStartTimeUs.put(Util.msToUs((long)currentSegment.startTimeMs), Float.valueOf(baseSpeed / (float)currentSegment.speedDivisor));
        }
        for (i = 0; i < segments.size(); ++i) {
            currentSegment = (SlowMotionData.Segment)segments.get(i);
            if (speedsByStartTimeUs.containsKey(Util.msToUs((long)currentSegment.endTimeMs))) continue;
            speedsByStartTimeUs.put(Util.msToUs((long)currentSegment.endTimeMs), Float.valueOf(baseSpeed));
        }
        return ImmutableSortedMap.copyOf(speedsByStartTimeUs);
    }

    private static float getCaptureFrameRate(Format format) {
        Metadata metadata = format.metadata;
        if (metadata == null) {
            return -3.4028235E38f;
        }
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (!(entry instanceof SmtaMetadataEntry)) continue;
            return ((SmtaMetadataEntry)entry).captureFrameRate;
        }
        return -3.4028235E38f;
    }

    private static ImmutableList<SlowMotionData.Segment> extractSlowMotionSegments(Format format) {
        ArrayList segments = new ArrayList();
        Metadata metadata = format.metadata;
        if (metadata != null) {
            for (int i = 0; i < metadata.length(); ++i) {
                Metadata.Entry entry = metadata.get(i);
                if (!(entry instanceof SlowMotionData)) continue;
                segments.addAll(((SlowMotionData)entry).segments);
            }
        }
        return ImmutableList.sortedCopyOf((Comparator)SlowMotionData.Segment.BY_START_THEN_END_THEN_DIVISOR, segments);
    }
}

