/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import androidx.media3.common.Format;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.Assertions;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.extractor.metadata.mp4.SlowMotionData;
import androidx.media3.transformer.AudioTranscodingSamplePipeline;
import androidx.media3.transformer.Codec;
import androidx.media3.transformer.FallbackListener;
import androidx.media3.transformer.MuxerWrapper;
import androidx.media3.transformer.PassthroughSamplePipeline;
import androidx.media3.transformer.TransformationException;
import androidx.media3.transformer.TransformationRequest;
import androidx.media3.transformer.TransformerBaseRenderer;
import androidx.media3.transformer.TransformerMediaClock;
import java.util.List;

final class TransformerAudioRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TAudioRenderer";
    private final Codec.EncoderFactory encoderFactory;
    private final Codec.DecoderFactory decoderFactory;
    private final DecoderInputBuffer decoderInputBuffer;

    public TransformerAudioRenderer(MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, TransformationRequest transformationRequest, Codec.EncoderFactory encoderFactory, Codec.DecoderFactory decoderFactory, FallbackListener fallbackListener) {
        super(1, muxerWrapper, mediaClock, transformationRequest, fallbackListener);
        this.encoderFactory = encoderFactory;
        this.decoderFactory = decoderFactory;
        this.decoderInputBuffer = new DecoderInputBuffer(0);
    }

    public String getName() {
        return TAG;
    }

    @Override
    protected boolean ensureConfigured() throws TransformationException {
        if (this.samplePipeline != null) {
            return true;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.decoderInputBuffer, 2);
        if (result != -5) {
            return false;
        }
        Format inputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        this.samplePipeline = this.shouldPassthrough(inputFormat) ? new PassthroughSamplePipeline(inputFormat, this.transformationRequest, this.fallbackListener) : new AudioTranscodingSamplePipeline(inputFormat, this.streamOffsetUs, this.transformationRequest, this.decoderFactory, this.encoderFactory, (List<String>)this.muxerWrapper.getSupportedSampleMimeTypes(this.getTrackType()), this.fallbackListener);
        return true;
    }

    private boolean shouldPassthrough(Format inputFormat) {
        if (this.encoderFactory.audioNeedsEncoding()) {
            return false;
        }
        if (this.transformationRequest.audioMimeType != null && !this.transformationRequest.audioMimeType.equals(inputFormat.sampleMimeType)) {
            return false;
        }
        if (this.transformationRequest.audioMimeType == null && !this.muxerWrapper.supportsSampleMimeType(inputFormat.sampleMimeType)) {
            return false;
        }
        return !this.transformationRequest.flattenForSlowMotion || !TransformerAudioRenderer.isSlowMotion(inputFormat);
    }

    private static boolean isSlowMotion(Format format) {
        Metadata metadata = format.metadata;
        if (metadata == null) {
            return false;
        }
        for (int i = 0; i < metadata.length(); ++i) {
            if (!(metadata.get(i) instanceof SlowMotionData)) continue;
            return true;
        }
        return false;
    }
}

