/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.BaseRenderer;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.MediaClock;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.transformer.FallbackListener;
import androidx.media3.transformer.Muxer;
import androidx.media3.transformer.MuxerWrapper;
import androidx.media3.transformer.SamplePipeline;
import androidx.media3.transformer.TransformationException;
import androidx.media3.transformer.TransformationRequest;
import androidx.media3.transformer.TransformerMediaClock;
import com.google.errorprone.annotations.ForOverride;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

abstract class TransformerBaseRenderer
extends BaseRenderer {
    protected final MuxerWrapper muxerWrapper;
    protected final TransformerMediaClock mediaClock;
    protected final TransformationRequest transformationRequest;
    protected final FallbackListener fallbackListener;
    protected boolean isRendererStarted;
    protected boolean muxerWrapperTrackAdded;
    protected boolean muxerWrapperTrackEnded;
    protected long streamOffsetUs;
    protected long streamStartPositionUs;
    protected @MonotonicNonNull SamplePipeline samplePipeline;

    public TransformerBaseRenderer(int trackType, MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, TransformationRequest transformationRequest, FallbackListener fallbackListener) {
        super(trackType);
        this.muxerWrapper = muxerWrapper;
        this.mediaClock = mediaClock;
        this.transformationRequest = transformationRequest;
        this.fallbackListener = fallbackListener;
    }

    public final int supportsFormat(Format format) {
        return RendererCapabilities.create((int)(MimeTypes.getTrackType((String)format.sampleMimeType) == this.getTrackType() ? 4 : 0));
    }

    public final MediaClock getMediaClock() {
        return this.mediaClock;
    }

    public final boolean isReady() {
        return this.isSourceReady();
    }

    public final boolean isEnded() {
        return this.muxerWrapperTrackEnded;
    }

    public final void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        try {
            if (!this.isRendererStarted || this.isEnded() || !this.ensureConfigured()) {
                return;
            }
            while (this.feedMuxerFromPipeline() || this.samplePipeline.processData() || this.feedPipelineFromInput()) {
            }
        }
        catch (TransformationException e) {
            throw this.wrapTransformationException(e);
        }
        catch (Muxer.MuxerException e) {
            throw this.wrapTransformationException(TransformationException.createForMuxer(e, 6001));
        }
    }

    protected final void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.streamOffsetUs = offsetUs;
        this.streamStartPositionUs = startPositionUs;
    }

    protected final void onEnabled(boolean joining, boolean mayRenderStartOfStream) {
        this.muxerWrapper.registerTrack();
        this.fallbackListener.registerTrack();
        this.mediaClock.updateTimeForTrackType(this.getTrackType(), 0L);
    }

    protected final void onStarted() {
        this.isRendererStarted = true;
    }

    protected final void onStopped() {
        this.isRendererStarted = false;
    }

    protected final void onReset() {
        if (this.samplePipeline != null) {
            this.samplePipeline.release();
        }
        this.muxerWrapperTrackAdded = false;
        this.muxerWrapperTrackEnded = false;
    }

    @EnsuresNonNullIf(expression={"samplePipeline"}, result=true)
    @ForOverride
    protected abstract boolean ensureConfigured() throws TransformationException;

    @RequiresNonNull(value={"samplePipeline", "#1.data"})
    protected void maybeQueueSampleToPipeline(DecoderInputBuffer inputBuffer) throws TransformationException {
        this.samplePipeline.queueInputBuffer();
    }

    @RequiresNonNull(value={"samplePipeline"})
    private boolean feedMuxerFromPipeline() throws Muxer.MuxerException, TransformationException {
        if (!this.muxerWrapperTrackAdded) {
            Format samplePipelineOutputFormat = this.samplePipeline.getOutputFormat();
            if (samplePipelineOutputFormat == null) {
                return false;
            }
            this.muxerWrapperTrackAdded = true;
            this.muxerWrapper.addTrackFormat(samplePipelineOutputFormat);
        }
        if (this.samplePipeline.isEnded()) {
            this.muxerWrapper.endTrack(this.getTrackType());
            this.muxerWrapperTrackEnded = true;
            return false;
        }
        DecoderInputBuffer samplePipelineOutputBuffer = this.samplePipeline.getOutputBuffer();
        if (samplePipelineOutputBuffer == null) {
            return false;
        }
        long samplePresentationTimeUs = samplePipelineOutputBuffer.timeUs - this.streamStartPositionUs;
        if (!this.muxerWrapper.writeSample(this.getTrackType(), (ByteBuffer)Assertions.checkStateNotNull((Object)samplePipelineOutputBuffer.data), samplePipelineOutputBuffer.isKeyFrame(), samplePresentationTimeUs)) {
            return false;
        }
        this.samplePipeline.releaseOutputBuffer();
        return true;
    }

    @RequiresNonNull(value={"samplePipeline"})
    private boolean feedPipelineFromInput() throws TransformationException {
        DecoderInputBuffer samplePipelineInputBuffer = this.samplePipeline.dequeueInputBuffer();
        if (samplePipelineInputBuffer == null) {
            return false;
        }
        int result = this.readSource(this.getFormatHolder(), samplePipelineInputBuffer, 0);
        switch (result) {
            case -4: {
                samplePipelineInputBuffer.flip();
                if (samplePipelineInputBuffer.isEndOfStream()) {
                    this.samplePipeline.queueInputBuffer();
                    return false;
                }
                this.mediaClock.updateTimeForTrackType(this.getTrackType(), samplePipelineInputBuffer.timeUs);
                Assertions.checkStateNotNull((Object)samplePipelineInputBuffer.data);
                this.maybeQueueSampleToPipeline(samplePipelineInputBuffer);
                return true;
            }
            case -5: {
                throw new IllegalStateException("Format changes are not supported.");
            }
        }
        return false;
    }

    private ExoPlaybackException wrapTransformationException(TransformationException transformationException) {
        return ExoPlaybackException.createForRenderer((Throwable)transformationException, (String)"Transformer", (int)this.getIndex(), null, (int)4, (boolean)false, (int)1000);
    }
}

