/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.transformer;

import android.util.SparseLongArray;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.MediaClock;

final class TransformerMediaClock
implements MediaClock {
    private final SparseLongArray trackTypeToTimeUs = new SparseLongArray();
    private long minTrackTimeUs;

    public void updateTimeForTrackType(int trackType, long timeUs) {
        long previousTimeUs = this.trackTypeToTimeUs.get(trackType, -9223372036854775807L);
        if (previousTimeUs != -9223372036854775807L && timeUs <= previousTimeUs) {
            return;
        }
        this.trackTypeToTimeUs.put(trackType, timeUs);
        if (previousTimeUs == -9223372036854775807L || previousTimeUs == this.minTrackTimeUs) {
            this.minTrackTimeUs = Util.minValue((SparseLongArray)this.trackTypeToTimeUs);
        }
    }

    public long getPositionUs() {
        return this.minTrackTimeUs;
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
    }

    public PlaybackParameters getPlaybackParameters() {
        return PlaybackParameters.DEFAULT;
    }
}

