/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.FrameMetrics;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.PerformanceMetricsState;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b*\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/metrics/performance/DelegatingFrameMetricsListener;", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "delegates", "", "(Ljava/util/List;)V", "getDelegates", "()Ljava/util/List;", "onFrameMetricsAvailable", "", "window", "Landroid/view/Window;", "frameMetrics", "Landroid/view/FrameMetrics;", "dropCount", "", "withDelegates", "delegateAction", "Lkotlin/Function0;", "metrics-performance_release"})
@RequiresApi(value=24)
final class DelegatingFrameMetricsListener
implements Window.OnFrameMetricsAvailableListener {
    @NotNull
    private final List<Window.OnFrameMetricsAvailableListener> delegates;

    public DelegatingFrameMetricsListener(@NotNull List<Window.OnFrameMetricsAvailableListener> delegates) {
        Intrinsics.checkNotNullParameter(delegates, (String)"delegates");
        this.delegates = delegates;
    }

    @NotNull
    public final List<Window.OnFrameMetricsAvailableListener> getDelegates() {
        return this.delegates;
    }

    public void onFrameMetricsAvailable(@Nullable Window window, @Nullable FrameMetrics frameMetrics, int dropCount) {
        block1: {
            if (window == null) break block1;
            this.withDelegates(window, (Function0<Unit>)((Function0)new Function0<Unit>(this, window, frameMetrics, dropCount){
                final /* synthetic */ DelegatingFrameMetricsListener this$0;
                final /* synthetic */ Window $window;
                final /* synthetic */ FrameMetrics $frameMetrics;
                final /* synthetic */ int $dropCount;
                {
                    this.this$0 = $receiver;
                    this.$window = $window;
                    this.$frameMetrics = $frameMetrics;
                    this.$dropCount = $dropCount;
                    super(0);
                }

                public final void invoke() {
                    for (Window.OnFrameMetricsAvailableListener delegate : this.this$0.getDelegates()) {
                        delegate.onFrameMetricsAvailable(this.$window, this.$frameMetrics, this.$dropCount);
                    }
                }
            }));
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            PerformanceMetricsState.Holder holder = PerformanceMetricsState.Companion.getForHierarchy(view);
            PerformanceMetricsState performanceMetricsState = holder.getState();
            if (performanceMetricsState != null) {
                performanceMetricsState.cleanupSingleFrameStates$metrics_performance_release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withDelegates(@NotNull Window $this$withDelegates, @NotNull Function0<Unit> delegateAction) {
        Intrinsics.checkNotNullParameter((Object)$this$withDelegates, (String)"<this>");
        Intrinsics.checkNotNullParameter(delegateAction, (String)"delegateAction");
        Window window = $this$withDelegates;
        synchronized (window) {
            boolean bl = false;
            delegateAction.invoke();
            Unit unit = Unit.INSTANCE;
        }
    }
}

