/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.Choreographer;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.JankStatsApi16Impl;
import androidx.metrics.performance.JankStatsBaseImpl;
import androidx.metrics.performance.OnFrameListenerDelegate;
import androidx.metrics.performance.PerformanceMetricsState;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0011\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Landroidx/metrics/performance/DelegatingOnPreDrawListener;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "decorView", "Landroid/view/View;", "choreographer", "Landroid/view/Choreographer;", "delegates", "", "Landroidx/metrics/performance/OnFrameListenerDelegate;", "(Landroid/view/View;Landroid/view/Choreographer;Ljava/util/List;)V", "getChoreographer", "()Landroid/view/Choreographer;", "decorViewRef", "Ljava/lang/ref/WeakReference;", "getDecorViewRef", "()Ljava/lang/ref/WeakReference;", "getDelegates", "()Ljava/util/List;", "metricsStateHolder", "Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "getMetricsStateHolder", "()Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "getFrameStartTime", "", "onPreDraw", "", "setMessageAsynchronicity", "", "message", "Landroid/os/Message;", "setMessageAsynchronicity$metrics_performance_release", "Companion", "metrics-performance_release"})
@RequiresApi(value=16)
public class DelegatingOnPreDrawListener
implements ViewTreeObserver.OnPreDrawListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Choreographer choreographer;
    @NotNull
    private final List<OnFrameListenerDelegate> delegates;
    @NotNull
    private final WeakReference<View> decorViewRef;
    @NotNull
    private final PerformanceMetricsState.Holder metricsStateHolder;
    @NotNull
    private static final Field choreographerLastFrameTimeField;

    public DelegatingOnPreDrawListener(@NotNull View decorView, @NotNull Choreographer choreographer, @NotNull List<OnFrameListenerDelegate> delegates) {
        Intrinsics.checkNotNullParameter((Object)decorView, (String)"decorView");
        Intrinsics.checkNotNullParameter((Object)choreographer, (String)"choreographer");
        Intrinsics.checkNotNullParameter(delegates, (String)"delegates");
        this.choreographer = choreographer;
        this.delegates = delegates;
        this.decorViewRef = new WeakReference<View>(decorView);
        this.metricsStateHolder = PerformanceMetricsState.Companion.getForHierarchy(decorView);
    }

    @NotNull
    public final Choreographer getChoreographer() {
        return this.choreographer;
    }

    @NotNull
    public final List<OnFrameListenerDelegate> getDelegates() {
        return this.delegates;
    }

    @NotNull
    public final WeakReference<View> getDecorViewRef() {
        return this.decorViewRef;
    }

    @NotNull
    public final PerformanceMetricsState.Holder getMetricsStateHolder() {
        return this.metricsStateHolder;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onPreDraw() {
        block0: {
            void $this$onPreDraw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1;
            Message message;
            View decorView;
            View view = decorView = (View)this.decorViewRef.get();
            if (view == null) break block0;
            View it = view;
            boolean bl = false;
            long frameStart = this.getFrameStartTime();
            View $this$onPreDraw_u24lambda_u2d3_u24lambda_u2d2 = decorView;
            boolean bl2 = false;
            Message message2 = message = Message.obtain((Handler)$this$onPreDraw_u24lambda_u2d3_u24lambda_u2d2.getHandler(), () -> DelegatingOnPreDrawListener.onPreDraw$lambda-3$lambda-2$lambda-0(decorView, this, frameStart));
            Handler handler = $this$onPreDraw_u24lambda_u2d3_u24lambda_u2d2.getHandler();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$onPreDraw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1, (String)"this");
            this.setMessageAsynchronicity$metrics_performance_release((Message)$this$onPreDraw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1);
            handler.sendMessage(message);
        }
        return true;
    }

    private final long getFrameStartTime() {
        Object object = choreographerLastFrameTimeField.get(this.choreographer);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    public void setMessageAsynchronicity$metrics_performance_release(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    private static final void onPreDraw$lambda-3$lambda-2$lambda-0(View $decorView, DelegatingOnPreDrawListener this$0, long $frameStart) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            long now = System.nanoTime();
            long expectedDuration = Companion.getExpectedFrameDuration($decorView);
            JankStatsApi16Impl.Companion.withDelegates($decorView, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, $frameStart, now, expectedDuration){
                final /* synthetic */ DelegatingOnPreDrawListener this$0;
                final /* synthetic */ long $frameStart;
                final /* synthetic */ long $now;
                final /* synthetic */ long $expectedDuration;
                {
                    this.this$0 = $receiver;
                    this.$frameStart = $frameStart;
                    this.$now = $now;
                    this.$expectedDuration = $expectedDuration;
                    super(0);
                }

                public final void invoke() {
                    for (OnFrameListenerDelegate delegate : this.this$0.getDelegates()) {
                        delegate.onFrame(this.$frameStart, this.$now - this.$frameStart, this.$expectedDuration);
                    }
                }
            }));
            PerformanceMetricsState performanceMetricsState = this$0.metricsStateHolder.getState();
            if (performanceMetricsState == null) break block0;
            performanceMetricsState.cleanupSingleFrameStates$metrics_performance_release();
        }
    }

    static {
        Field field = Choreographer.class.getDeclaredField("mLastFrameTimeNanos");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"Choreographer::class.jav\u2026ld(\"mLastFrameTimeNanos\")");
        choreographerLastFrameTimeField = field;
        choreographerLastFrameTimeField.setAccessible(true);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/metrics/performance/DelegatingOnPreDrawListener$Companion;", "", "()V", "choreographerLastFrameTimeField", "Ljava/lang/reflect/Field;", "getChoreographerLastFrameTimeField", "()Ljava/lang/reflect/Field;", "getExpectedFrameDuration", "", "view", "Landroid/view/View;", "metrics-performance_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Field getChoreographerLastFrameTimeField() {
            return choreographerLastFrameTimeField;
        }

        public final long getExpectedFrameDuration(@Nullable View view) {
            if (JankStatsBaseImpl.Companion.getFrameDuration() < 0L) {
                Window window;
                Window window2;
                float refreshRate = 60.0f;
                View view2 = view;
                if ((view2 != null ? view2.getContext() : null) instanceof Activity) {
                    Context context = view.getContext();
                    Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
                    window2 = ((Activity)context).getWindow();
                } else {
                    window2 = window = null;
                }
                if (window != null) {
                    Display display = window.getWindowManager().getDefaultDisplay();
                    refreshRate = display.getRefreshRate();
                }
                if (refreshRate < 30.0f || refreshRate > 200.0f) {
                    refreshRate = 60.0f;
                }
                JankStatsBaseImpl.Companion.setFrameDuration((long)((float)1000 / refreshRate * (float)1000000));
            }
            return JankStatsBaseImpl.Companion.getFrameDuration();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

