/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.annotation.UiThread;
import androidx.metrics.performance.FrameData;
import androidx.metrics.performance.JankStatsApi16Impl;
import androidx.metrics.performance.JankStatsApi22Impl;
import androidx.metrics.performance.JankStatsApi24Impl;
import androidx.metrics.performance.JankStatsApi26Impl;
import androidx.metrics.performance.JankStatsApi31Impl;
import androidx.metrics.performance.JankStatsBaseImpl;
import androidx.metrics.performance.PerformanceMetricsState;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Landroidx/metrics/performance/JankStats;", "", "window", "Landroid/view/Window;", "executor", "Ljava/util/concurrent/Executor;", "frameListener", "Landroidx/metrics/performance/JankStats$OnFrameListener;", "(Landroid/view/Window;Ljava/util/concurrent/Executor;Landroidx/metrics/performance/JankStats$OnFrameListener;)V", "holder", "Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "implementation", "Landroidx/metrics/performance/JankStatsBaseImpl;", "value", "", "isTrackingEnabled", "()Z", "setTrackingEnabled", "(Z)V", "", "jankHeuristicMultiplier", "getJankHeuristicMultiplier", "()F", "setJankHeuristicMultiplier", "(F)V", "logFrameData", "", "frameData", "Landroidx/metrics/performance/FrameData;", "logFrameData$metrics_performance_release", "Companion", "OnFrameListener", "metrics-performance_release"})
public final class JankStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor executor;
    @NotNull
    private final OnFrameListener frameListener;
    @NotNull
    private final PerformanceMetricsState.Holder holder;
    @NotNull
    private final JankStatsBaseImpl implementation;
    private boolean isTrackingEnabled;
    private float jankHeuristicMultiplier;

    private JankStats(Window window, Executor executor, OnFrameListener frameListener) {
        this.executor = executor;
        this.frameListener = frameListener;
        View decorView = window.peekDecorView();
        if (decorView == null) {
            throw new IllegalStateException("window.peekDecorView() is null: JankStats can only be created with a Window that has a non-null DecorView");
        }
        this.holder = PerformanceMetricsState.Companion.create$metrics_performance_release(decorView);
        this.implementation = Build.VERSION.SDK_INT >= 31 ? (JankStatsBaseImpl)new JankStatsApi31Impl(this, decorView, window) : (Build.VERSION.SDK_INT >= 26 ? (JankStatsBaseImpl)new JankStatsApi26Impl(this, decorView, window) : (Build.VERSION.SDK_INT >= 24 ? (JankStatsBaseImpl)new JankStatsApi24Impl(this, decorView, window) : (Build.VERSION.SDK_INT >= 22 ? (JankStatsBaseImpl)new JankStatsApi22Impl(this, decorView) : (Build.VERSION.SDK_INT >= 16 ? (JankStatsBaseImpl)new JankStatsApi16Impl(this, decorView) : new JankStatsBaseImpl(this)))));
        this.implementation.setupFrameTimer(true);
        this.isTrackingEnabled = true;
        this.jankHeuristicMultiplier = 2.0f;
    }

    public final boolean isTrackingEnabled() {
        return this.isTrackingEnabled;
    }

    @UiThread
    public final void setTrackingEnabled(boolean value) {
        this.implementation.setupFrameTimer(value);
        this.isTrackingEnabled = value;
    }

    public final float getJankHeuristicMultiplier() {
        return this.jankHeuristicMultiplier;
    }

    public final void setJankHeuristicMultiplier(float value) {
        JankStatsBaseImpl.Companion.setFrameDuration(-1L);
        this.jankHeuristicMultiplier = value;
    }

    public final void logFrameData$metrics_performance_release(@NotNull FrameData frameData) {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        this.executor.execute(() -> JankStats.logFrameData$lambda-0(this, frameData));
    }

    private static final void logFrameData$lambda-0(JankStats this$0, FrameData $frameData) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$frameData, (String)"$frameData");
        this$0.frameListener.onFrame($frameData);
    }

    @JvmStatic
    @UiThread
    @NotNull
    public static final JankStats createAndTrack(@NotNull Window window, @NotNull Executor executor, @NotNull OnFrameListener frameListener) {
        return Companion.createAndTrack(window, executor, frameListener);
    }

    public /* synthetic */ JankStats(Window window, Executor executor, OnFrameListener frameListener, DefaultConstructorMarker $constructor_marker) {
        this(window, executor, frameListener);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/metrics/performance/JankStats$Companion;", "", "()V", "createAndTrack", "Landroidx/metrics/performance/JankStats;", "window", "Landroid/view/Window;", "executor", "Ljava/util/concurrent/Executor;", "frameListener", "Landroidx/metrics/performance/JankStats$OnFrameListener;", "metrics-performance_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @UiThread
        @NotNull
        public final JankStats createAndTrack(@NotNull Window window, @NotNull Executor executor, @NotNull OnFrameListener frameListener) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)frameListener, (String)"frameListener");
            return new JankStats(window, executor, frameListener, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Landroidx/metrics/performance/JankStats$OnFrameListener;", "", "onFrame", "", "frameData", "Landroidx/metrics/performance/FrameData;", "metrics-performance_release"})
    public static interface OnFrameListener {
        public void onFrame(@NotNull FrameData var1);
    }
}

