/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.Choreographer;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.DelegatingOnPreDrawListener;
import androidx.metrics.performance.FrameData;
import androidx.metrics.performance.JankStats;
import androidx.metrics.performance.JankStatsApi16Impl;
import androidx.metrics.performance.JankStatsBaseImpl;
import androidx.metrics.performance.OnFrameListenerDelegate;
import androidx.metrics.performance.PerformanceMetricsState;
import androidx.metrics.performance.R;
import androidx.metrics.performance.StateInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005*\u0001\u0014\b\u0011\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J+\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0010\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u0005H\u0002J\u0014\u0010+\u001a\u00020'*\u00020\u00052\u0006\u0010,\u001a\u00020\u001aH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006."}, d2={"Landroidx/metrics/performance/JankStatsApi16Impl;", "Landroidx/metrics/performance/JankStatsBaseImpl;", "jankStats", "Landroidx/metrics/performance/JankStats;", "view", "Landroid/view/View;", "(Landroidx/metrics/performance/JankStats;Landroid/view/View;)V", "choreographer", "Landroid/view/Choreographer;", "getChoreographer", "()Landroid/view/Choreographer;", "decorViewRef", "Ljava/lang/ref/WeakReference;", "getDecorViewRef$metrics_performance_release", "()Ljava/lang/ref/WeakReference;", "metricsStateHolder", "Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "getMetricsStateHolder", "()Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "onFrameListenerDelegate", "androidx/metrics/performance/JankStatsApi16Impl$onFrameListenerDelegate$1", "Landroidx/metrics/performance/JankStatsApi16Impl$onFrameListenerDelegate$1;", "createDelegatingOnDrawListener", "Landroidx/metrics/performance/DelegatingOnPreDrawListener;", "delegates", "", "Landroidx/metrics/performance/OnFrameListenerDelegate;", "createDelegatingOnDrawListener$metrics_performance_release", "getExpectedFrameDuration", "", "getFrameData", "Landroidx/metrics/performance/FrameData;", "startTime", "uiDuration", "expectedDuration", "getFrameData$metrics_performance_release", "getFrameStartTime", "getFrameStartTime$metrics_performance_release", "setupFrameTimer", "", "enable", "", "getOrCreateOnPreDrawListenerDelegates", "removeOnPreDrawListenerDelegate", "delegate", "Companion", "metrics-performance_release"})
@RequiresApi(value=16)
public class JankStatsApi16Impl
extends JankStatsBaseImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<View> decorViewRef;
    @NotNull
    private final Choreographer choreographer;
    @NotNull
    private final PerformanceMetricsState.Holder metricsStateHolder;
    @NotNull
    private final onFrameListenerDelegate.1 onFrameListenerDelegate;

    public JankStatsApi16Impl(@NotNull JankStats jankStats, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)jankStats, (String)"jankStats");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(jankStats);
        this.decorViewRef = new WeakReference<View>(view);
        Choreographer choreographer = Choreographer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)choreographer, (String)"getInstance()");
        this.choreographer = choreographer;
        this.metricsStateHolder = PerformanceMetricsState.Companion.getForHierarchy(view);
        this.onFrameListenerDelegate = new OnFrameListenerDelegate(jankStats, this){
            final /* synthetic */ JankStats $jankStats;
            final /* synthetic */ JankStatsApi16Impl this$0;
            {
                this.$jankStats = $jankStats;
                this.this$0 = $receiver;
            }

            public void onFrame(long startTime, long uiDuration, long expectedDuration) {
                this.$jankStats.logFrameData$metrics_performance_release(this.this$0.getFrameData$metrics_performance_release(startTime, uiDuration, (long)((float)expectedDuration * this.$jankStats.getJankHeuristicMultiplier())));
            }
        };
    }

    @NotNull
    public final WeakReference<View> getDecorViewRef$metrics_performance_release() {
        return this.decorViewRef;
    }

    @NotNull
    public final Choreographer getChoreographer() {
        return this.choreographer;
    }

    @NotNull
    public final PerformanceMetricsState.Holder getMetricsStateHolder() {
        return this.metricsStateHolder;
    }

    @Override
    public void setupFrameTimer(boolean enable) {
        block0: {
            View decorView;
            View view = decorView = (View)this.decorViewRef.get();
            if (view == null) break block0;
            View it = view;
            boolean bl = false;
            Companion.withDelegates(decorView, (Function0<Unit>)((Function0)new Function0<Unit>(enable, this, decorView){
                final /* synthetic */ boolean $enable;
                final /* synthetic */ JankStatsApi16Impl this$0;
                final /* synthetic */ View $decorView;
                {
                    this.$enable = $enable;
                    this.this$0 = $receiver;
                    this.$decorView = $decorView;
                    super(0);
                }

                public final void invoke() {
                    if (this.$enable) {
                        List delegates = JankStatsApi16Impl.access$getOrCreateOnPreDrawListenerDelegates(this.this$0, this.$decorView);
                        delegates.add(JankStatsApi16Impl.access$getOnFrameListenerDelegate$p(this.this$0));
                    } else {
                        JankStatsApi16Impl.access$removeOnPreDrawListenerDelegate(this.this$0, this.$decorView, JankStatsApi16Impl.access$getOnFrameListenerDelegate$p(this.this$0));
                    }
                }
            }));
        }
    }

    @NotNull
    public FrameData getFrameData$metrics_performance_release(long startTime, long uiDuration, long expectedDuration) {
        Object object = this.metricsStateHolder.getState();
        if (object == null || (object = ((PerformanceMetricsState)object).getIntervalStates$metrics_performance_release(startTime, startTime + uiDuration)) == null) {
            object = CollectionsKt.emptyList();
        }
        List<StateInfo> frameStates = object;
        boolean isJank = uiDuration > expectedDuration;
        return new FrameData(startTime, uiDuration, isJank, frameStates);
    }

    private final void removeOnPreDrawListenerDelegate(View $this$removeOnPreDrawListenerDelegate, OnFrameListenerDelegate delegate) {
        DelegatingOnPreDrawListener delegator;
        DelegatingOnPreDrawListener delegatingOnPreDrawListener = delegator = (DelegatingOnPreDrawListener)$this$removeOnPreDrawListenerDelegate.getTag(R.id.metricsDelegator);
        List<OnFrameListenerDelegate> $this$removeOnPreDrawListenerDelegate_u24lambda_u2d1 = delegatingOnPreDrawListener != null ? delegatingOnPreDrawListener.getDelegates() : null;
        boolean bl = false;
        List<OnFrameListenerDelegate> list = $this$removeOnPreDrawListenerDelegate_u24lambda_u2d1;
        if (list != null) {
            list.remove(delegate);
        }
        List<OnFrameListenerDelegate> list2 = $this$removeOnPreDrawListenerDelegate_u24lambda_u2d1;
        boolean bl2 = list2 != null ? list2.size() == 0 : false;
        if (bl2) {
            $this$removeOnPreDrawListenerDelegate.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)delegator);
            $this$removeOnPreDrawListenerDelegate.setTag(R.id.metricsDelegator, null);
        }
    }

    private final List<OnFrameListenerDelegate> getOrCreateOnPreDrawListenerDelegates(View $this$getOrCreateOnPreDrawListenerDelegates) {
        DelegatingOnPreDrawListener delegator = (DelegatingOnPreDrawListener)$this$getOrCreateOnPreDrawListenerDelegates.getTag(R.id.metricsDelegator);
        if (delegator == null) {
            List delegates = new ArrayList();
            delegator = this.createDelegatingOnDrawListener$metrics_performance_release($this$getOrCreateOnPreDrawListenerDelegates, this.choreographer, delegates);
            $this$getOrCreateOnPreDrawListenerDelegates.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)delegator);
            $this$getOrCreateOnPreDrawListenerDelegates.setTag(R.id.metricsDelegator, (Object)delegator);
        }
        return delegator.getDelegates();
    }

    @NotNull
    public DelegatingOnPreDrawListener createDelegatingOnDrawListener$metrics_performance_release(@NotNull View view, @NotNull Choreographer choreographer, @NotNull List<OnFrameListenerDelegate> delegates) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)choreographer, (String)"choreographer");
        Intrinsics.checkNotNullParameter(delegates, (String)"delegates");
        return new DelegatingOnPreDrawListener(view, choreographer, delegates);
    }

    public final long getFrameStartTime$metrics_performance_release() {
        Object object = DelegatingOnPreDrawListener.Companion.getChoreographerLastFrameTimeField().get(this.choreographer);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    public final long getExpectedFrameDuration(@Nullable View view) {
        return DelegatingOnPreDrawListener.Companion.getExpectedFrameDuration(view);
    }

    public static final /* synthetic */ List access$getOrCreateOnPreDrawListenerDelegates(JankStatsApi16Impl $this, View $receiver) {
        return $this.getOrCreateOnPreDrawListenerDelegates($receiver);
    }

    public static final /* synthetic */ onFrameListenerDelegate.1 access$getOnFrameListenerDelegate$p(JankStatsApi16Impl $this) {
        return $this.onFrameListenerDelegate;
    }

    public static final /* synthetic */ void access$removeOnPreDrawListenerDelegate(JankStatsApi16Impl $this, View $receiver, OnFrameListenerDelegate delegate) {
        $this.removeOnPreDrawListenerDelegate($receiver, delegate);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a8\u0006\t"}, d2={"Landroidx/metrics/performance/JankStatsApi16Impl$Companion;", "", "()V", "withDelegates", "", "decorView", "Landroid/view/View;", "delegateAction", "Lkotlin/Function0;", "metrics-performance_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void withDelegates(@NotNull View decorView, @NotNull Function0<Unit> delegateAction) {
            Intrinsics.checkNotNullParameter((Object)decorView, (String)"decorView");
            Intrinsics.checkNotNullParameter(delegateAction, (String)"delegateAction");
            View view = decorView;
            synchronized (view) {
                boolean bl = false;
                delegateAction.invoke();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

