/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.View;
import android.view.ViewParent;
import androidx.annotation.UiThread;
import androidx.metrics.performance.R;
import androidx.metrics.performance.StateInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\n\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\r\u0010\u0017\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/metrics/performance/PerformanceMetricsState;", "", "()V", "singleFrameStates", "", "Landroidx/metrics/performance/PerformanceMetricsState$StateData;", "states", "statesHolder", "statesToBeCleared", "", "addFrameState", "", "frameStartTime", "", "frameEndTime", "frameStates", "Landroidx/metrics/performance/StateInfo;", "activeStates", "addSingleFrameState", "stateName", "", "state", "addState", "cleanupSingleFrameStates", "cleanupSingleFrameStates$metrics_performance_release", "getIntervalStates", "", "startTime", "endTime", "getIntervalStates$metrics_performance_release", "markStateForRemoval", "removalTime", "removeState", "Companion", "Holder", "StateData", "metrics-performance_release"})
public final class PerformanceMetricsState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<StateData> states = new ArrayList();
    @NotNull
    private List<StateData> singleFrameStates = new ArrayList();
    @NotNull
    private final List<StateData> statesHolder = new ArrayList();
    @NotNull
    private final List<Integer> statesToBeCleared = new ArrayList();

    private PerformanceMetricsState() {
    }

    private final void addFrameState(long frameStartTime, long frameEndTime, List<StateInfo> frameStates, List<StateData> activeStates) {
        StateData item;
        int n = activeStates.size() + -1;
        if (0 <= n) {
            do {
                int i;
                if ((item = activeStates.get(i = n--)).getTimeRemoved() > 0L && item.getTimeRemoved() < frameStartTime) {
                    activeStates.remove(i);
                    continue;
                }
                if (item.getTimeAdded() >= frameEndTime) continue;
                this.statesHolder.add(item);
                if (!Intrinsics.areEqual(activeStates, this.singleFrameStates) || item.getTimeRemoved() != -1L) continue;
                item.setTimeRemoved(System.nanoTime());
            } while (0 <= n);
        }
        if (this.statesHolder.size() > 0) {
            int i;
            int n2 = this.statesHolder.size();
            for (i = 0; i < n2; ++i) {
                if (this.statesToBeCleared.contains(i)) continue;
                item = this.statesHolder.get(i);
                int n3 = this.statesHolder.size();
                for (int j = i + 1; j < n3; ++j) {
                    StateData otherItem = this.statesHolder.get(j);
                    if (!Intrinsics.areEqual((Object)item.getState().getStateName(), (Object)otherItem.getState().getStateName())) continue;
                    if (item.getTimeAdded() < otherItem.getTimeAdded()) {
                        this.statesToBeCleared.add(i);
                        continue;
                    }
                    this.statesToBeCleared.add(j);
                }
            }
            for (i = this.statesToBeCleared.size() - 1; -1 < i; --i) {
                this.statesHolder.remove(((Number)this.statesToBeCleared.get(i)).intValue());
            }
            n2 = this.statesHolder.size();
            for (i = 0; i < n2; ++i) {
                frameStates.add(this.statesHolder.get(i).getState());
            }
            this.statesHolder.clear();
            this.statesToBeCleared.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void markStateForRemoval(String stateName, List<StateData> states, long removalTime) {
        List<StateData> list = this.singleFrameStates;
        synchronized (list) {
            boolean bl = false;
            for (StateData item : states) {
                if (!Intrinsics.areEqual((Object)item.getState().getStateName(), (Object)stateName) || item.getTimeRemoved() >= 0L) continue;
                item.setTimeRemoved(removalTime);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addState(@NotNull String stateName, @NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List<StateData> list = this.singleFrameStates;
        synchronized (list) {
            boolean bl = false;
            long nowTime = System.nanoTime();
            this.markStateForRemoval(stateName, this.states, nowTime);
            boolean bl2 = this.states.add(new StateData(nowTime, -1L, new StateInfo(stateName, state)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSingleFrameState(@NotNull String stateName, @NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List<StateData> list = this.singleFrameStates;
        synchronized (list) {
            boolean bl = false;
            long nowTime = System.nanoTime();
            this.markStateForRemoval(stateName, this.singleFrameStates, nowTime);
            boolean bl2 = this.singleFrameStates.add(new StateData(nowTime, -1L, new StateInfo(stateName, state)));
        }
    }

    private final void markStateForRemoval(String stateName) {
        this.markStateForRemoval(stateName, this.states, System.nanoTime());
    }

    public final void removeState(@NotNull String stateName) {
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        this.markStateForRemoval(stateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<StateInfo> getIntervalStates$metrics_performance_release(long startTime, long endTime) {
        ArrayList frameStates = null;
        List<StateData> list = this.singleFrameStates;
        synchronized (list) {
            boolean bl = false;
            frameStates = new ArrayList(this.states.size() + this.singleFrameStates.size());
            this.addFrameState(startTime, endTime, frameStates, this.states);
            this.addFrameState(startTime, endTime, frameStates, this.singleFrameStates);
            Unit unit = Unit.INSTANCE;
        }
        return frameStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanupSingleFrameStates$metrics_performance_release() {
        List<StateData> list = this.singleFrameStates;
        synchronized (list) {
            boolean bl = false;
            for (int i = this.singleFrameStates.size() - 1; -1 < i; --i) {
                if (this.singleFrameStates.get(i).getTimeRemoved() == -1L) continue;
                this.singleFrameStates.remove(i);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    @UiThread
    @NotNull
    public static final Holder getForHierarchy(@NotNull View view) {
        return Companion.getForHierarchy(view);
    }

    @JvmStatic
    @UiThread
    @NotNull
    public static final Holder create$metrics_performance_release(@NotNull View view) {
        return Companion.create$metrics_performance_release(view);
    }

    public /* synthetic */ PerformanceMetricsState(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroidx/metrics/performance/PerformanceMetricsState$StateData;", "", "timeAdded", "", "timeRemoved", "state", "Landroidx/metrics/performance/StateInfo;", "(JJLandroidx/metrics/performance/StateInfo;)V", "getState", "()Landroidx/metrics/performance/StateInfo;", "setState", "(Landroidx/metrics/performance/StateInfo;)V", "getTimeAdded", "()J", "setTimeAdded", "(J)V", "getTimeRemoved", "setTimeRemoved", "metrics-performance_release"})
    public static final class StateData {
        private long timeAdded;
        private long timeRemoved;
        @NotNull
        private StateInfo state;

        public StateData(long timeAdded, long timeRemoved, @NotNull StateInfo state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.timeAdded = timeAdded;
            this.timeRemoved = timeRemoved;
            this.state = state;
        }

        public final long getTimeAdded() {
            return this.timeAdded;
        }

        public final void setTimeAdded(long l) {
            this.timeAdded = l;
        }

        public final long getTimeRemoved() {
            return this.timeRemoved;
        }

        public final void setTimeRemoved(long l) {
            this.timeRemoved = l;
        }

        @NotNull
        public final StateInfo getState() {
            return this.state;
        }

        public final void setState(@NotNull StateInfo stateInfo) {
            Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"<set-?>");
            this.state = stateInfo;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Landroidx/metrics/performance/PerformanceMetricsState$Companion;", "", "()V", "create", "Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "view", "Landroid/view/View;", "create$metrics_performance_release", "getForHierarchy", "getRootView", "getRootView$metrics_performance_release", "metrics-performance_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @UiThread
        @NotNull
        public final Holder getForHierarchy(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            View rootView = this.getRootView$metrics_performance_release(view);
            Object metricsStateHolder = rootView.getTag(R.id.metricsStateHolder);
            if (metricsStateHolder == null) {
                metricsStateHolder = new Holder();
                rootView.setTag(R.id.metricsStateHolder, metricsStateHolder);
            }
            return (Holder)metricsStateHolder;
        }

        @JvmStatic
        @UiThread
        @NotNull
        public final Holder create$metrics_performance_release(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Holder holder = this.getForHierarchy(view);
            if (holder.getState() == null) {
                holder.setState$metrics_performance_release(new PerformanceMetricsState(null));
            }
            return holder;
        }

        @NotNull
        public final View getRootView$metrics_performance_release(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            View rootView = view;
            ViewParent parent = rootView.getParent();
            while (parent instanceof View) {
                rootView = (View)parent;
                parent = rootView.getParent();
            }
            return rootView;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "", "()V", "<set-?>", "Landroidx/metrics/performance/PerformanceMetricsState;", "state", "getState", "()Landroidx/metrics/performance/PerformanceMetricsState;", "setState$metrics_performance_release", "(Landroidx/metrics/performance/PerformanceMetricsState;)V", "metrics-performance_release"})
    public static final class Holder {
        @Nullable
        private PerformanceMetricsState state;

        @Nullable
        public final PerformanceMetricsState getState() {
            return this.state;
        }

        public final void setState$metrics_performance_release(@Nullable PerformanceMetricsState performanceMetricsState) {
            this.state = performanceMetricsState;
        }
    }
}

