/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.Choreographer;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.JankStatsBaseImpl;
import androidx.metrics.performance.OnFrameListenerDelegate;
import androidx.metrics.performance.PerformanceMetricsState;
import androidx.metrics.performance.R;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0011\u0018\u0000 -2\u00020\u0001:\u0001-B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bJ\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0013H\u0016J\u0016\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010'\u001a\u00020(J\u0015\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0010\u00a2\u0006\u0002\b,R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006."}, d2={"Landroidx/metrics/performance/DelegatingOnPreDrawListener;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "decorView", "Landroid/view/View;", "choreographer", "Landroid/view/Choreographer;", "delegates", "", "Landroidx/metrics/performance/OnFrameListenerDelegate;", "(Landroid/view/View;Landroid/view/Choreographer;Ljava/util/List;)V", "getChoreographer", "()Landroid/view/Choreographer;", "decorViewRef", "Ljava/lang/ref/WeakReference;", "getDecorViewRef", "()Ljava/lang/ref/WeakReference;", "getDelegates", "()Ljava/util/List;", "iterating", "", "getIterating", "()Z", "setIterating", "(Z)V", "metricsStateHolder", "Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "getMetricsStateHolder", "()Landroidx/metrics/performance/PerformanceMetricsState$Holder;", "toBeAdded", "getToBeAdded", "toBeRemoved", "getToBeRemoved", "add", "", "delegate", "getFrameStartTime", "", "onPreDraw", "remove", "viewTreeObserver", "Landroid/view/ViewTreeObserver;", "setMessageAsynchronicity", "message", "Landroid/os/Message;", "setMessageAsynchronicity$metrics_performance_release", "Companion", "metrics-performance_release"})
@RequiresApi(value=16)
public class DelegatingOnPreDrawListener
implements ViewTreeObserver.OnPreDrawListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Choreographer choreographer;
    @NotNull
    private final List<OnFrameListenerDelegate> delegates;
    private boolean iterating;
    @NotNull
    private final List<OnFrameListenerDelegate> toBeAdded;
    @NotNull
    private final List<OnFrameListenerDelegate> toBeRemoved;
    @NotNull
    private final WeakReference<View> decorViewRef;
    @NotNull
    private final PerformanceMetricsState.Holder metricsStateHolder;
    @NotNull
    private static final Field choreographerLastFrameTimeField;

    public DelegatingOnPreDrawListener(@NotNull View decorView, @NotNull Choreographer choreographer, @NotNull List<OnFrameListenerDelegate> delegates) {
        Intrinsics.checkNotNullParameter((Object)decorView, (String)"decorView");
        Intrinsics.checkNotNullParameter((Object)choreographer, (String)"choreographer");
        Intrinsics.checkNotNullParameter(delegates, (String)"delegates");
        this.choreographer = choreographer;
        this.delegates = delegates;
        this.toBeAdded = new ArrayList();
        this.toBeRemoved = new ArrayList();
        this.decorViewRef = new WeakReference<View>(decorView);
        this.metricsStateHolder = PerformanceMetricsState.Companion.getHolderForHierarchy(decorView);
    }

    @NotNull
    public final Choreographer getChoreographer() {
        return this.choreographer;
    }

    @NotNull
    public final List<OnFrameListenerDelegate> getDelegates() {
        return this.delegates;
    }

    public final boolean getIterating() {
        return this.iterating;
    }

    public final void setIterating(boolean bl) {
        this.iterating = bl;
    }

    @NotNull
    public final List<OnFrameListenerDelegate> getToBeAdded() {
        return this.toBeAdded;
    }

    @NotNull
    public final List<OnFrameListenerDelegate> getToBeRemoved() {
        return this.toBeRemoved;
    }

    @NotNull
    public final WeakReference<View> getDecorViewRef() {
        return this.decorViewRef;
    }

    @NotNull
    public final PerformanceMetricsState.Holder getMetricsStateHolder() {
        return this.metricsStateHolder;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onPreDraw() {
        block0: {
            void $this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2;
            Message message;
            View decorView;
            View view = decorView = (View)this.decorViewRef.get();
            if (view == null) break block0;
            View it = view;
            boolean bl = false;
            long frameStart = this.getFrameStartTime();
            View $this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3 = decorView;
            boolean bl2 = false;
            Message message2 = message = Message.obtain((Handler)$this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3.getHandler(), () -> DelegatingOnPreDrawListener.onPreDraw$lambda-4$lambda-3$lambda-1(decorView, this, frameStart, $this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3));
            Handler handler = $this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3.getHandler();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2, (String)"this");
            this.setMessageAsynchronicity$metrics_performance_release((Message)$this$onPreDraw_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2);
            handler.sendMessageAtFrontOfQueue(message);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull OnFrameListenerDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        DelegatingOnPreDrawListener delegatingOnPreDrawListener = this;
        synchronized (delegatingOnPreDrawListener) {
            boolean bl = false;
            boolean bl2 = this.iterating ? this.toBeAdded.add(delegate) : this.delegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull OnFrameListenerDelegate delegate, @NotNull ViewTreeObserver viewTreeObserver) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)viewTreeObserver, (String)"viewTreeObserver");
        DelegatingOnPreDrawListener delegatingOnPreDrawListener = this;
        synchronized (delegatingOnPreDrawListener) {
            Boolean bl;
            boolean bl2 = false;
            if (this.iterating) {
                bl = this.toBeRemoved.add(delegate);
            } else {
                boolean delegatesNonEmpty = !((Collection)this.delegates).isEmpty();
                this.delegates.remove(delegate);
                if (delegatesNonEmpty && this.delegates.isEmpty()) {
                    View decorView;
                    viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    View view = decorView = (View)this.decorViewRef.get();
                    if (view != null) {
                        view.setTag(R.id.metricsDelegator, null);
                        bl = Unit.INSTANCE;
                    } else {
                        bl = null;
                    }
                } else {
                    bl = Unit.INSTANCE;
                }
            }
            Boolean bl3 = bl;
        }
    }

    private final long getFrameStartTime() {
        Object object = choreographerLastFrameTimeField.get(this.choreographer);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    public void setMessageAsynchronicity$metrics_performance_release(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onPreDraw$lambda-4$lambda-3$lambda-1(View $decorView, DelegatingOnPreDrawListener this$0, long $frameStart, View $this_with) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
            long now = System.nanoTime();
            long expectedDuration = Companion.getExpectedFrameDuration($decorView);
            DelegatingOnPreDrawListener delegatingOnPreDrawListener = this$0;
            synchronized (delegatingOnPreDrawListener) {
                boolean bl = false;
                this$0.iterating = true;
                for (OnFrameListenerDelegate delegate : this$0.delegates) {
                    delegate.onFrame($frameStart, now - $frameStart, expectedDuration);
                }
                if (!((Collection)this$0.toBeAdded).isEmpty()) {
                    for (OnFrameListenerDelegate delegate : this$0.toBeAdded) {
                        this$0.delegates.add(delegate);
                    }
                    this$0.toBeAdded.clear();
                }
                if (!((Collection)this$0.toBeRemoved).isEmpty()) {
                    boolean delegatesNonEmpty = !((Collection)this$0.delegates).isEmpty();
                    for (OnFrameListenerDelegate delegate : this$0.toBeRemoved) {
                        this$0.delegates.remove(delegate);
                    }
                    this$0.toBeRemoved.clear();
                    if (delegatesNonEmpty && this$0.delegates.isEmpty()) {
                        $this_with.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this$0);
                        $this_with.setTag(R.id.metricsDelegator, null);
                    }
                }
                this$0.iterating = false;
                Unit unit = Unit.INSTANCE;
            }
            PerformanceMetricsState performanceMetricsState = this$0.metricsStateHolder.getState();
            if (performanceMetricsState == null) break block9;
            performanceMetricsState.cleanupSingleFrameStates$metrics_performance_release();
        }
    }

    static {
        Field field = Choreographer.class.getDeclaredField("mLastFrameTimeNanos");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"Choreographer::class.jav\u2026ld(\"mLastFrameTimeNanos\")");
        choreographerLastFrameTimeField = field;
        choreographerLastFrameTimeField.setAccessible(true);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/metrics/performance/DelegatingOnPreDrawListener$Companion;", "", "()V", "choreographerLastFrameTimeField", "Ljava/lang/reflect/Field;", "getChoreographerLastFrameTimeField", "()Ljava/lang/reflect/Field;", "getExpectedFrameDuration", "", "view", "Landroid/view/View;", "metrics-performance_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Field getChoreographerLastFrameTimeField() {
            return choreographerLastFrameTimeField;
        }

        public final long getExpectedFrameDuration(@Nullable View view) {
            if (JankStatsBaseImpl.Companion.getFrameDuration() < 0L) {
                Window window;
                Window window2;
                float refreshRate = 60.0f;
                View view2 = view;
                if ((view2 != null ? view2.getContext() : null) instanceof Activity) {
                    Context context = view.getContext();
                    Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
                    window2 = ((Activity)context).getWindow();
                } else {
                    window2 = window = null;
                }
                if (window != null) {
                    Display display = window.getWindowManager().getDefaultDisplay();
                    refreshRate = display.getRefreshRate();
                }
                if (refreshRate < 30.0f || refreshRate > 200.0f) {
                    refreshRate = 60.0f;
                }
                JankStatsBaseImpl.Companion.setFrameDuration((long)((float)1000 / refreshRate * (float)1000000));
            }
            return JankStatsBaseImpl.Companion.getFrameDuration();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

