/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import androidx.metrics.performance.StateInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u0013\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001bR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Landroidx/metrics/performance/FrameData;", "", "frameStartNanos", "", "frameDurationUiNanos", "isJank", "", "states", "", "Landroidx/metrics/performance/StateInfo;", "(JJZLjava/util/List;)V", "<set-?>", "getFrameDurationUiNanos", "()J", "getFrameStartNanos", "()Z", "getStates", "()Ljava/util/List;", "copy", "equals", "other", "hashCode", "", "toString", "", "update", "", "update$metrics_performance_release", "metrics-performance_release"})
public class FrameData {
    @NotNull
    private final List<StateInfo> states;
    private long frameStartNanos;
    private long frameDurationUiNanos;
    private boolean isJank;

    public FrameData(long frameStartNanos, long frameDurationUiNanos, boolean isJank, @NotNull List<StateInfo> states) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        this.states = states;
        this.frameStartNanos = frameStartNanos;
        this.frameDurationUiNanos = frameDurationUiNanos;
        this.isJank = isJank;
    }

    @NotNull
    public final List<StateInfo> getStates() {
        return this.states;
    }

    public final long getFrameStartNanos() {
        return this.frameStartNanos;
    }

    public final long getFrameDurationUiNanos() {
        return this.frameDurationUiNanos;
    }

    public final boolean isJank() {
        return this.isJank;
    }

    @NotNull
    public FrameData copy() {
        return new FrameData(this.frameStartNanos, this.frameDurationUiNanos, this.isJank, new ArrayList(this.states));
    }

    public final void update$metrics_performance_release(long frameStartNanos, long frameDurationUiNanos, boolean isJank) {
        this.frameStartNanos = frameStartNanos;
        this.frameDurationUiNanos = frameDurationUiNanos;
        this.isJank = isJank;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.metrics.performance.FrameData");
        FrameData cfr_ignored_0 = (FrameData)other;
        if (this.frameStartNanos != ((FrameData)other).frameStartNanos) {
            return false;
        }
        if (this.frameDurationUiNanos != ((FrameData)other).frameDurationUiNanos) {
            return false;
        }
        if (this.isJank != ((FrameData)other).isJank) {
            return false;
        }
        return Intrinsics.areEqual(this.states, ((FrameData)other).states);
    }

    public int hashCode() {
        int result = Long.hashCode(this.frameStartNanos);
        result = 31 * result + Long.hashCode(this.frameDurationUiNanos);
        result = 31 * result + Boolean.hashCode(this.isJank);
        result = 31 * result + ((Object)this.states).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "FrameData(frameStartNanos=" + this.frameStartNanos + ", frameDurationUiNanos=" + this.frameDurationUiNanos + ", isJank=" + this.isJank + ", states=" + this.states + ')';
    }
}

