/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.os.Handler;
import android.os.HandlerThread;
import android.view.FrameMetrics;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.DelegatingFrameMetricsListener;
import androidx.metrics.performance.FrameDataApi24;
import androidx.metrics.performance.JankStats;
import androidx.metrics.performance.JankStatsApi22Impl;
import androidx.metrics.performance.PerformanceMetricsState;
import androidx.metrics.performance.R;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0011\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J%\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\f\u0010'\u001a\u00020(*\u00020\u0007H\u0003J\u0014\u0010)\u001a\u00020$*\u00020\u00072\u0006\u0010*\u001a\u00020\fH\u0003R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/metrics/performance/JankStatsApi24Impl;", "Landroidx/metrics/performance/JankStatsApi22Impl;", "jankStats", "Landroidx/metrics/performance/JankStats;", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "(Landroidx/metrics/performance/JankStats;Landroid/view/View;Landroid/view/Window;)V", "frameData", "Landroidx/metrics/performance/FrameDataApi24;", "frameMetricsAvailableListenerDelegate", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "listenerAddedTime", "", "getListenerAddedTime", "()J", "setListenerAddedTime", "(J)V", "prevEnd", "getPrevEnd", "setPrevEnd", "prevStart", "getPrevStart", "setPrevStart", "getExpectedFrameDuration", "metrics", "Landroid/view/FrameMetrics;", "getFrameData", "startTime", "expectedDuration", "frameMetrics", "getFrameData$metrics_performance_release", "getFrameStartTime", "getFrameStartTime$metrics_performance_release", "setupFrameTimer", "", "enable", "", "getOrCreateFrameMetricsListenerDelegator", "Landroidx/metrics/performance/DelegatingFrameMetricsListener;", "removeFrameMetricsListenerDelegate", "delegate", "Companion", "metrics-performance_release"})
@RequiresApi(value=24)
public class JankStatsApi24Impl
extends JankStatsApi22Impl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Window window;
    private long prevStart;
    private long listenerAddedTime;
    private long prevEnd;
    @NotNull
    private final FrameDataApi24 frameData;
    @NotNull
    private final Window.OnFrameMetricsAvailableListener frameMetricsAvailableListenerDelegate;
    @Nullable
    private static Handler frameMetricsHandler;

    public JankStatsApi24Impl(@NotNull JankStats jankStats, @NotNull View view, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)jankStats, (String)"jankStats");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super(jankStats, view);
        this.window = window;
        this.frameData = new FrameDataApi24(0L, 0L, 0L, false, this.getStateInfo());
        this.frameMetricsAvailableListenerDelegate = (arg_0, arg_1, arg_2) -> JankStatsApi24Impl.frameMetricsAvailableListenerDelegate$lambda-0(this, jankStats, arg_0, arg_1, arg_2);
    }

    public final long getPrevStart() {
        return this.prevStart;
    }

    public final void setPrevStart(long l) {
        this.prevStart = l;
    }

    public final long getListenerAddedTime() {
        return this.listenerAddedTime;
    }

    public final void setListenerAddedTime(long l) {
        this.listenerAddedTime = l;
    }

    public final long getPrevEnd() {
        return this.prevEnd;
    }

    public final void setPrevEnd(long l) {
        this.prevEnd = l;
    }

    @NotNull
    public FrameDataApi24 getFrameData$metrics_performance_release(long startTime, long expectedDuration, @NotNull FrameMetrics frameMetrics) {
        Intrinsics.checkNotNullParameter((Object)frameMetrics, (String)"frameMetrics");
        long uiDuration = frameMetrics.getMetric(0) + frameMetrics.getMetric(1) + frameMetrics.getMetric(2) + frameMetrics.getMetric(3) + frameMetrics.getMetric(4) + frameMetrics.getMetric(5);
        this.prevEnd = startTime + uiDuration;
        PerformanceMetricsState performanceMetricsState = this.getMetricsStateHolder().getState();
        if (performanceMetricsState != null) {
            performanceMetricsState.getIntervalStates$metrics_performance_release(startTime, this.prevEnd, this.getStateInfo());
        }
        boolean isJank = uiDuration > expectedDuration;
        long cpuDuration = uiDuration + frameMetrics.getMetric(6) + frameMetrics.getMetric(7);
        this.frameData.update$metrics_performance_release(startTime, uiDuration, cpuDuration, isJank);
        return this.frameData;
    }

    public long getFrameStartTime$metrics_performance_release(@NotNull FrameMetrics frameMetrics) {
        Intrinsics.checkNotNullParameter((Object)frameMetrics, (String)"frameMetrics");
        return this.getFrameStartTime$metrics_performance_release();
    }

    public long getExpectedFrameDuration(@NotNull FrameMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return this.getExpectedFrameDuration((View)this.getDecorViewRef$metrics_performance_release().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupFrameTimer(boolean enable) {
        Window window = this.window;
        synchronized (window) {
            boolean bl = false;
            if (enable) {
                if (this.listenerAddedTime == 0L) {
                    DelegatingFrameMetricsListener delegates = this.getOrCreateFrameMetricsListenerDelegator(this.window);
                    delegates.add(this.frameMetricsAvailableListenerDelegate);
                    this.listenerAddedTime = System.nanoTime();
                }
            } else {
                this.removeFrameMetricsListenerDelegate(this.window, this.frameMetricsAvailableListenerDelegate);
                this.listenerAddedTime = 0L;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @RequiresApi(value=24)
    private final void removeFrameMetricsListenerDelegate(Window $this$removeFrameMetricsListenerDelegate, Window.OnFrameMetricsAvailableListener delegate) {
        block0: {
            DelegatingFrameMetricsListener delegator;
            DelegatingFrameMetricsListener $this$removeFrameMetricsListenerDelegate_u24lambda_u2d2 = delegator = (DelegatingFrameMetricsListener)$this$removeFrameMetricsListenerDelegate.getDecorView().getTag(R.id.metricsDelegator);
            boolean bl = false;
            DelegatingFrameMetricsListener delegatingFrameMetricsListener = $this$removeFrameMetricsListenerDelegate_u24lambda_u2d2;
            if (delegatingFrameMetricsListener == null) break block0;
            delegatingFrameMetricsListener.remove(delegate, $this$removeFrameMetricsListenerDelegate);
        }
    }

    @RequiresApi(value=24)
    private final DelegatingFrameMetricsListener getOrCreateFrameMetricsListenerDelegator(Window $this$getOrCreateFrameMetricsListenerDelegator) {
        DelegatingFrameMetricsListener delegator = (DelegatingFrameMetricsListener)$this$getOrCreateFrameMetricsListenerDelegator.getDecorView().getTag(R.id.metricsDelegator);
        if (delegator == null) {
            List delegates = new ArrayList();
            delegator = new DelegatingFrameMetricsListener(delegates);
            if (frameMetricsHandler == null) {
                HandlerThread thread = new HandlerThread("FrameMetricsAggregator");
                thread.start();
                frameMetricsHandler = new Handler(thread.getLooper());
            }
            $this$getOrCreateFrameMetricsListenerDelegator.addOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)delegator, frameMetricsHandler);
            $this$getOrCreateFrameMetricsListenerDelegator.getDecorView().setTag(R.id.metricsDelegator, (Object)delegator);
        }
        return delegator;
    }

    private static final void frameMetricsAvailableListenerDelegate$lambda-0(JankStatsApi24Impl this$0, JankStats $jankStats, Window window, FrameMetrics frameMetrics, int n) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jankStats, (String)"$jankStats");
        Intrinsics.checkNotNullExpressionValue((Object)frameMetrics, (String)"frameMetrics");
        long startTime = Math.max(this$0.getFrameStartTime$metrics_performance_release(frameMetrics), this$0.prevEnd);
        if (startTime >= this$0.listenerAddedTime && startTime != this$0.prevStart) {
            float expectedDuration = (float)this$0.getExpectedFrameDuration(frameMetrics) * $jankStats.getJankHeuristicMultiplier();
            $jankStats.logFrameData$metrics_performance_release(this$0.getFrameData$metrics_performance_release(startTime, (long)expectedDuration, frameMetrics));
            this$0.prevStart = startTime;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/metrics/performance/JankStatsApi24Impl$Companion;", "", "()V", "frameMetricsHandler", "Landroid/os/Handler;", "getFrameMetricsHandler$metrics_performance_release", "()Landroid/os/Handler;", "setFrameMetricsHandler$metrics_performance_release", "(Landroid/os/Handler;)V", "metrics-performance_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Handler getFrameMetricsHandler$metrics_performance_release() {
            return frameMetricsHandler;
        }

        public final void setFrameMetricsHandler$metrics_performance_release(@Nullable Handler handler) {
            frameMetricsHandler = handler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

