/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.FrameMetrics;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.FrameDataApi31;
import androidx.metrics.performance.JankStats;
import androidx.metrics.performance.JankStatsApi26Impl;
import androidx.metrics.performance.PerformanceMetricsState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Landroidx/metrics/performance/JankStatsApi31Impl;", "Landroidx/metrics/performance/JankStatsApi26Impl;", "jankStats", "Landroidx/metrics/performance/JankStats;", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "(Landroidx/metrics/performance/JankStats;Landroid/view/View;Landroid/view/Window;)V", "frameData", "Landroidx/metrics/performance/FrameDataApi31;", "getFrameData", "()Landroidx/metrics/performance/FrameDataApi31;", "getExpectedFrameDuration", "", "metrics", "Landroid/view/FrameMetrics;", "startTime", "expectedDuration", "frameMetrics", "getFrameData$metrics_performance_release", "metrics-performance_release"})
@RequiresApi(value=31)
public final class JankStatsApi31Impl
extends JankStatsApi26Impl {
    @NotNull
    private final FrameDataApi31 frameData;

    public JankStatsApi31Impl(@NotNull JankStats jankStats, @NotNull View view, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)jankStats, (String)"jankStats");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super(jankStats, view, window);
        this.frameData = new FrameDataApi31(0L, 0L, 0L, 0L, false, this.getStateInfo());
    }

    @NotNull
    public final FrameDataApi31 getFrameData() {
        return this.frameData;
    }

    @Override
    @NotNull
    public FrameDataApi31 getFrameData$metrics_performance_release(long startTime, long expectedDuration, @NotNull FrameMetrics frameMetrics) {
        Intrinsics.checkNotNullParameter((Object)frameMetrics, (String)"frameMetrics");
        long uiDuration = frameMetrics.getMetric(0) + frameMetrics.getMetric(1) + frameMetrics.getMetric(2) + frameMetrics.getMetric(3) + frameMetrics.getMetric(4) + frameMetrics.getMetric(5);
        this.setPrevEnd(startTime + uiDuration);
        PerformanceMetricsState performanceMetricsState = this.getMetricsStateHolder().getState();
        if (performanceMetricsState != null) {
            performanceMetricsState.getIntervalStates$metrics_performance_release(startTime, this.getPrevEnd(), this.getStateInfo());
        }
        boolean isJank = uiDuration > expectedDuration;
        long cpuDuration = uiDuration + frameMetrics.getMetric(6) + frameMetrics.getMetric(7);
        long overrun = frameMetrics.getMetric(8) - frameMetrics.getMetric(13);
        this.frameData.update$metrics_performance_release(startTime, uiDuration, cpuDuration, overrun, isJank);
        return this.frameData;
    }

    @Override
    public long getExpectedFrameDuration(@NotNull FrameMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return metrics.getMetric(13);
    }
}

