/*
 * Decompiled with CFR 0.152.
 */
package androidx.metrics.performance;

import android.view.FrameMetrics;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.metrics.performance.FrameData;
import androidx.metrics.performance.JankStats;
import androidx.metrics.performance.JankStatsApi16Impl;
import androidx.metrics.performance.JankStatsApi24Impl;
import androidx.metrics.performance.JankStatsBaseImpl;
import androidx.metrics.performance.PerformanceMetricsState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Landroidx/metrics/performance/JankStatsInternalsForTesting;", "", "jankStats", "Landroidx/metrics/performance/JankStats;", "(Landroidx/metrics/performance/JankStats;)V", "impl", "Landroidx/metrics/performance/JankStatsBaseImpl;", "getJankStats", "()Landroidx/metrics/performance/JankStats;", "getFrameData", "Landroidx/metrics/performance/FrameData;", "frameMetrics", "Landroid/view/FrameMetrics;", "logFrameData", "", "frameData", "removeStateNow", "performanceMetricsState", "Landroidx/metrics/performance/PerformanceMetricsState;", "stateName", "", "metrics-performance_release"})
@VisibleForTesting
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class JankStatsInternalsForTesting {
    @NotNull
    private final JankStats jankStats;
    @NotNull
    private final JankStatsBaseImpl impl;

    public JankStatsInternalsForTesting(@NotNull JankStats jankStats) {
        Intrinsics.checkNotNullParameter((Object)jankStats, (String)"jankStats");
        this.jankStats = jankStats;
        this.impl = this.jankStats.getImplementation$metrics_performance_release();
    }

    @NotNull
    public final JankStats getJankStats() {
        return this.jankStats;
    }

    public final void removeStateNow(@NotNull PerformanceMetricsState performanceMetricsState, @NotNull String stateName) {
        Intrinsics.checkNotNullParameter((Object)performanceMetricsState, (String)"performanceMetricsState");
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        performanceMetricsState.removeStateNow$metrics_performance_release(stateName);
    }

    @RequiresApi(value=16)
    @Nullable
    public final FrameData getFrameData() {
        if (this.impl instanceof JankStatsApi16Impl) {
            return ((JankStatsApi16Impl)this.impl).getFrameData$metrics_performance_release(0L, 0L, 0L);
        }
        return null;
    }

    @RequiresApi(value=24)
    @Nullable
    public final FrameData getFrameData(@NotNull FrameMetrics frameMetrics) {
        Intrinsics.checkNotNullParameter((Object)frameMetrics, (String)"frameMetrics");
        if (this.impl instanceof JankStatsApi24Impl) {
            return ((JankStatsApi24Impl)this.impl).getFrameData$metrics_performance_release(0L, 0L, frameMetrics);
        }
        return null;
    }

    @RequiresApi(value=16)
    public final void logFrameData(@NotNull FrameData frameData) {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        this.jankStats.logFrameData$metrics_performance_release(frameData);
    }
}

