/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures.fragment.ui;

import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.navigation.Navigator;
import androidx.navigation.dynamicfeatures.DynamicExtras;
import androidx.navigation.dynamicfeatures.DynamicInstallMonitor;
import androidx.navigation.dynamicfeatures.fragment.ui.InstallViewModel;
import androidx.navigation.fragment.FragmentKt;
import com.google.android.play.core.splitinstall.SplitInstallManager;
import com.google.android.play.core.splitinstall.SplitInstallSessionState;
import com.google.android.play.core.splitinstall.model.SplitInstallErrorCode;
import com.google.android.play.core.splitinstall.model.SplitInstallSessionStatus;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 .2\u00020\u0001:\u0002./B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001cH$J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010!\u001a\u00020\u001c2\b\b\u0001\u0010\"\u001a\u00020\u0004H$J\b\u0010#\u001a\u00020\u001cH\u0014J\"\u0010$\u001a\u00020\u001c2\b\b\u0001\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H$J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0007H\u0016J\u001a\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0016R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Landroidx/navigation/dynamicfeatures/fragment/ui/AbstractProgressFragment;", "Landroidx/fragment/app/Fragment;", "()V", "contentLayoutId", "", "(I)V", "destinationArgs", "Landroid/os/Bundle;", "getDestinationArgs", "()Landroid/os/Bundle;", "destinationArgs$delegate", "Lkotlin/Lazy;", "destinationId", "getDestinationId", "()I", "destinationId$delegate", "installViewModel", "Landroidx/navigation/dynamicfeatures/fragment/ui/InstallViewModel;", "getInstallViewModel", "()Landroidx/navigation/dynamicfeatures/fragment/ui/InstallViewModel;", "installViewModel$delegate", "intentSenderLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroidx/activity/result/IntentSenderRequest;", "kotlin.jvm.PlatformType", "navigated", "", "navigate", "", "navigate$navigation_dynamic_features_fragment_release", "onCancelled", "onCreate", "savedInstanceState", "onFailed", "errorCode", "onInstalled", "onProgress", "status", "bytesDownloaded", "", "bytesTotal", "onSaveInstanceState", "outState", "onViewCreated", "view", "Landroid/view/View;", "Companion", "StateObserver", "navigation-dynamic-features-fragment_release"})
public abstract class AbstractProgressFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy installViewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<InstallViewModel>(this){
        final /* synthetic */ AbstractProgressFragment this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final InstallViewModel invoke() {
            ViewModelStore viewModelStore = this.this$0.getViewModelStore();
            Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
            ViewModelProvider.Factory factory = InstallViewModel.Companion.getFACTORY();
            CreationExtras creationExtras = this.this$0.getDefaultViewModelCreationExtras();
            Intrinsics.checkNotNullExpressionValue((Object)creationExtras, (String)"defaultViewModelCreationExtras");
            return (InstallViewModel)new ViewModelProvider(viewModelStore, factory, creationExtras).get(InstallViewModel.class);
        }
    }));
    @NotNull
    private final Lazy destinationId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
        final /* synthetic */ AbstractProgressFragment this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Integer invoke() {
            return this.this$0.requireArguments().getInt("dfn:destinationId");
        }
    }));
    @NotNull
    private final Lazy destinationArgs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bundle>(this){
        final /* synthetic */ AbstractProgressFragment this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final Bundle invoke() {
            return this.this$0.requireArguments().getBundle("dfn:destinationArgs");
        }
    }));
    private boolean navigated;
    @NotNull
    private final ActivityResultLauncher<IntentSenderRequest> intentSenderLauncher;
    private static final int INSTALL_REQUEST_CODE = 1;
    @NotNull
    private static final String TAG = "AbstractProgress";

    private final InstallViewModel getInstallViewModel() {
        Lazy lazy = this.installViewModel$delegate;
        return (InstallViewModel)((Object)lazy.getValue());
    }

    private final int getDestinationId() {
        Lazy lazy = this.destinationId$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final Bundle getDestinationArgs() {
        Lazy lazy = this.destinationArgs$delegate;
        return (Bundle)lazy.getValue();
    }

    public AbstractProgressFragment() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartIntentSenderForResult(), arg_0 -> AbstractProgressFragment.intentSenderLauncher$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.intentSenderLauncher = activityResultLauncher;
    }

    public AbstractProgressFragment(int contentLayoutId) {
        super(contentLayoutId);
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartIntentSenderForResult(), arg_0 -> AbstractProgressFragment.intentSenderLauncher$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.intentSenderLauncher = activityResultLauncher;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.navigated = savedInstanceState.getBoolean("dfn:navigated", false);
        }
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.navigated) {
            FragmentKt.findNavController((Fragment)this).popBackStack();
            return;
        }
        DynamicInstallMonitor monitor = this.getInstallViewModel().getInstallMonitor();
        if (monitor == null) {
            Log.i((String)TAG, (String)"onViewCreated: monitor is null, navigating");
            this.navigate$navigation_dynamic_features_fragment_release();
            monitor = this.getInstallViewModel().getInstallMonitor();
        }
        if (monitor != null) {
            Log.i((String)TAG, (String)"onViewCreated: monitor is now not null, observing");
            monitor.getStatus().observe(this.getViewLifecycleOwner(), (Observer)new StateObserver(monitor));
        }
    }

    public final void navigate$navigation_dynamic_features_fragment_release() {
        Log.i((String)TAG, (String)"navigate: ");
        DynamicInstallMonitor installMonitor = new DynamicInstallMonitor();
        DynamicExtras extras = new DynamicExtras(installMonitor, null, 2, null);
        FragmentKt.findNavController((Fragment)this).navigate(this.getDestinationId(), this.getDestinationArgs(), null, (Navigator.Extras)extras);
        if (!installMonitor.isInstallRequired()) {
            Log.i((String)TAG, (String)"navigate: install not required");
            this.navigated = true;
        } else {
            Log.i((String)TAG, (String)"navigate: setting install monitor");
            this.getInstallViewModel().setInstallMonitor(installMonitor);
        }
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putBoolean("dfn:navigated", this.navigated);
    }

    protected abstract void onProgress(@SplitInstallSessionStatus int var1, long var2, long var4);

    protected abstract void onCancelled();

    protected abstract void onFailed(@SplitInstallErrorCode int var1);

    protected void onInstalled() {
    }

    private static final void intentSenderLauncher$lambda$0(AbstractProgressFragment this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (result.getResultCode() == 0) {
            this$0.onCancelled();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/dynamicfeatures/fragment/ui/AbstractProgressFragment$Companion;", "", "()V", "INSTALL_REQUEST_CODE", "", "TAG", "", "navigation-dynamic-features-fragment_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/navigation/dynamicfeatures/fragment/ui/AbstractProgressFragment$StateObserver;", "Landroidx/lifecycle/Observer;", "Lcom/google/android/play/core/splitinstall/SplitInstallSessionState;", "monitor", "Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;", "(Landroidx/navigation/dynamicfeatures/fragment/ui/AbstractProgressFragment;Landroidx/navigation/dynamicfeatures/DynamicInstallMonitor;)V", "onChanged", "", "sessionState", "navigation-dynamic-features-fragment_release"})
    private final class StateObserver
    implements Observer<SplitInstallSessionState> {
        @NotNull
        private final DynamicInstallMonitor monitor;

        public StateObserver(DynamicInstallMonitor monitor) {
            Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
            this.monitor = monitor;
        }

        public void onChanged(@NotNull SplitInstallSessionState sessionState) {
            Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
            if (sessionState.hasTerminalStatus()) {
                this.monitor.getStatus().removeObserver((Observer)this);
            }
            switch (sessionState.status()) {
                case 5: {
                    AbstractProgressFragment.this.onInstalled();
                    AbstractProgressFragment.this.navigate$navigation_dynamic_features_fragment_release();
                    break;
                }
                case 8: {
                    try {
                        SplitInstallManager splitInstallManager = this.monitor.getSplitInstallManager();
                        if (splitInstallManager == null) {
                            AbstractProgressFragment.this.onFailed(-100);
                            return;
                        }
                        splitInstallManager.startConfirmationDialogForResult(sessionState, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> StateObserver.onChanged$lambda$0(AbstractProgressFragment.this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), 1);
                    }
                    catch (IntentSender.SendIntentException e) {
                        AbstractProgressFragment.this.onFailed(-100);
                    }
                    break;
                }
                case 7: {
                    AbstractProgressFragment.this.onCancelled();
                    break;
                }
                case 6: {
                    AbstractProgressFragment.this.onFailed(sessionState.errorCode());
                    break;
                }
                case 0: {
                    AbstractProgressFragment.this.onFailed(-100);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 9: {
                    AbstractProgressFragment.this.onProgress(sessionState.status(), sessionState.bytesDownloaded(), sessionState.totalBytesToDownload());
                }
            }
        }

        private static final void onChanged$lambda$0(AbstractProgressFragment this$0, IntentSender intent, int n, Intent fillInIntent, int flagsMask, int flagsValues, int n2, Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            this$0.intentSenderLauncher.launch((Object)new IntentSenderRequest.Builder(intent).setFillInIntent(fillInIntent).setFlags(flagsValues, flagsMask).build());
        }
    }
}

