/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IdRes;
import androidx.annotation.NavigationRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.TaskStackBuilder;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.ArrayDeque;

public final class NavDeepLinkBuilder {
    private final Context mContext;
    private final Intent mIntent;
    private NavGraph mGraph;
    private int mDestId;
    private Bundle mArgs;

    public NavDeepLinkBuilder(@NonNull Context context) {
        Intent launchIntent;
        this.mContext = context;
        this.mIntent = this.mContext instanceof Activity ? new Intent(this.mContext, this.mContext.getClass()) : ((launchIntent = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName())) != null ? launchIntent : new Intent());
        this.mIntent.addFlags(0x10008000);
    }

    NavDeepLinkBuilder(@NonNull NavController navController) {
        this(navController.getContext());
        this.mGraph = navController.getGraph();
    }

    @NonNull
    public NavDeepLinkBuilder setComponentName(@NonNull Class<? extends Activity> activityClass) {
        return this.setComponentName(new ComponentName(this.mContext, activityClass));
    }

    @NonNull
    public NavDeepLinkBuilder setComponentName(@NonNull ComponentName componentName) {
        this.mIntent.setComponent(componentName);
        return this;
    }

    @NonNull
    public NavDeepLinkBuilder setGraph(@NavigationRes int navGraphId) {
        return this.setGraph(new NavInflater(this.mContext, new PermissiveNavigatorProvider()).inflate(navGraphId));
    }

    @NonNull
    public NavDeepLinkBuilder setGraph(@NonNull NavGraph navGraph) {
        this.mGraph = navGraph;
        if (this.mDestId != 0) {
            this.fillInIntent();
        }
        return this;
    }

    @NonNull
    public NavDeepLinkBuilder setDestination(@IdRes int destId) {
        this.mDestId = destId;
        if (this.mGraph != null) {
            this.fillInIntent();
        }
        return this;
    }

    private void fillInIntent() {
        NavDestination node = null;
        ArrayDeque<Object> possibleDestinations = new ArrayDeque<Object>();
        possibleDestinations.add(this.mGraph);
        while (!possibleDestinations.isEmpty() && node == null) {
            NavDestination destination = (NavDestination)possibleDestinations.poll();
            if (destination.getId() == this.mDestId) {
                node = destination;
                continue;
            }
            if (!(destination instanceof NavGraph)) continue;
            for (NavDestination child : (NavGraph)destination) {
                possibleDestinations.add(child);
            }
        }
        if (node == null) {
            String dest = NavDestination.getDisplayName((Context)this.mContext, (int)this.mDestId);
            throw new IllegalArgumentException("navigation destination " + dest + " is unknown to this NavController");
        }
        this.mIntent.putExtra("android-support-nav:controller:deepLinkIds", node.buildDeepLinkIds());
    }

    @NonNull
    public NavDeepLinkBuilder setArguments(@Nullable Bundle args) {
        this.mArgs = args;
        this.mIntent.putExtra("android-support-nav:controller:deepLinkExtras", args);
        return this;
    }

    @NonNull
    public TaskStackBuilder createTaskStackBuilder() {
        if (this.mIntent.getIntArrayExtra("android-support-nav:controller:deepLinkIds") == null) {
            if (this.mGraph == null) {
                throw new IllegalStateException("You must call setGraph() before constructing the deep link");
            }
            throw new IllegalStateException("You must call setDestination() before constructing the deep link");
        }
        TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this.mContext).addNextIntentWithParentStack(new Intent(this.mIntent));
        for (int index = 0; index < taskStackBuilder.getIntentCount(); ++index) {
            taskStackBuilder.editIntentAt(index).putExtra("android-support-nav:controller:deepLinkIntent", (Parcelable)this.mIntent);
        }
        return taskStackBuilder;
    }

    @NonNull
    public PendingIntent createPendingIntent() {
        int requestCode = 0;
        if (this.mArgs != null) {
            for (String key : this.mArgs.keySet()) {
                Object value = this.mArgs.get(key);
                requestCode = 31 * requestCode + (value != null ? value.hashCode() : 0);
            }
        }
        requestCode = 31 * requestCode + this.mDestId;
        return this.createTaskStackBuilder().getPendingIntent(requestCode, 0x8000000);
    }

    private static class PermissiveNavigatorProvider
    extends NavigatorProvider {
        private final Navigator<NavDestination> mDestNavigator = new Navigator<NavDestination>(){

            @NonNull
            public NavDestination createDestination() {
                return new NavDestination("permissive");
            }

            @Nullable
            public NavDestination navigate(@NonNull NavDestination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
                throw new IllegalStateException("navigate is not supported");
            }

            public boolean popBackStack() {
                throw new IllegalStateException("popBackStack is not supported");
            }
        };

        PermissiveNavigatorProvider() {
            this.addNavigator((Navigator)new NavGraphNavigator((NavigatorProvider)this));
        }

        @NonNull
        public Navigator<? extends NavDestination> getNavigator(@NonNull String name) {
            try {
                return super.getNavigator(name);
            }
            catch (IllegalStateException e) {
                return this.mDestNavigator;
            }
        }
    }
}

