/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.NavLogger;
import androidx.navigation.safe.args.generator.XmlPosition;
import androidx.navigation.safe.args.generator.XmlPositionParserKt;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u0014\u0010\u0019\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0018J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/navigation/safe/args/generator/XmlPositionParser;", "", "name", "", "reader", "Ljava/io/Reader;", "logger", "Landroidx/navigation/safe/args/generator/NavLogger;", "(Ljava/lang/String;Ljava/io/Reader;Landroidx/navigation/safe/args/generator/NavLogger;)V", "getLogger", "()Landroidx/navigation/safe/args/generator/NavLogger;", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "startColumn", "", "startLine", "attrValue", "namespace", "attrValueOrError", "attrName", "nextToken", "", "traverseInnerStartTags", "onStartTag", "Lkotlin/Function0;", "traverseStartTags", "", "xmlPosition", "Landroidx/navigation/safe/args/generator/XmlPosition;", "navigation-safe-args-generator"})
@SourceDebugExtension(value={"SMAP\nXmlPositionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlPositionParser.kt\nandroidx/navigation/safe/args/generator/XmlPositionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class XmlPositionParser {
    @NotNull
    private final String name;
    @NotNull
    private final NavLogger logger;
    private int startLine;
    private int startColumn;
    @NotNull
    private final XmlPullParser parser;

    /*
     * WARNING - void declaration
     */
    public XmlPositionParser(@NotNull String name, @NotNull Reader reader, @NotNull NavLogger logger) {
        void $this$parser_u24lambda_u240;
        XmlPullParser xmlPullParser;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.name = name;
        this.logger = logger;
        XmlPullParser xmlPullParser2 = xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
        XmlPositionParser xmlPositionParser = this;
        boolean bl = false;
        $this$parser_u24lambda_u240.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        $this$parser_u24lambda_u240.setInput(reader);
        XmlPullParser xmlPullParser3 = xmlPullParser;
        Intrinsics.checkNotNullExpressionValue((Object)xmlPullParser3, (String)"newInstance().newPullPar\u2026   setInput(reader)\n    }");
        xmlPositionParser.parser = xmlPullParser3;
    }

    @NotNull
    public final NavLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String name() {
        String string = this.parser.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.name");
        return string;
    }

    public final void traverseStartTags(@NotNull Function0<Boolean> onStartTag) {
        Intrinsics.checkNotNullParameter(onStartTag, (String)"onStartTag");
        while (this.parser.getEventType() != 1) {
            int processedLine = this.parser.getLineNumber();
            int processedColumn = this.parser.getColumnNumber();
            if (this.parser.getEventType() == 2 && ((Boolean)onStartTag.invoke()).booleanValue()) {
                return;
            }
            if (processedLine != this.parser.getLineNumber() || processedColumn != this.parser.getColumnNumber()) continue;
            this.nextToken();
        }
    }

    private final void nextToken() {
        this.startLine = this.parser.getLineNumber();
        this.startColumn = this.parser.getColumnNumber();
        this.parser.nextToken();
    }

    @NotNull
    public final XmlPosition xmlPosition() {
        return new XmlPosition(this.name, this.startLine, this.startColumn - 1);
    }

    public final void traverseInnerStartTags(@NotNull Function0<Unit> onStartTag) {
        Intrinsics.checkNotNullParameter(onStartTag, (String)"onStartTag");
        int innerDepth = this.parser.getDepth() + 1;
        this.nextToken();
        this.traverseStartTags((Function0<Boolean>)((Function0)new Function0<Boolean>(innerDepth, this, onStartTag){
            final /* synthetic */ int $innerDepth;
            final /* synthetic */ XmlPositionParser this$0;
            final /* synthetic */ Function0<Unit> $onStartTag;
            {
                this.$innerDepth = $innerDepth;
                this.this$0 = $receiver;
                this.$onStartTag = $onStartTag;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                if (this.$innerDepth == XmlPositionParser.access$getParser$p(this.this$0).getDepth()) {
                    this.$onStartTag.invoke();
                }
                return XmlPositionParser.access$getParser$p(this.this$0).getDepth() < this.$innerDepth;
            }
        }));
    }

    @Nullable
    public final String attrValue(@NotNull String namespace, @NotNull String name) {
        String string;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.parser.getAttributeCount());
            for (Object t : iterable) {
                int it = ((Number)t).intValue();
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)this.parser.getAttributeNamespace(it), (Object)namespace) && Intrinsics.areEqual((Object)name, (Object)this.parser.getAttributeName(it)))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Integer n = v0;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string = this.parser.getAttributeValue(it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String attrValueOrError(@NotNull String namespace, @NotNull String attrName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        String value = this.attrValue(namespace, attrName);
        if (value == null) {
            this.logger.error(XmlPositionParserKt.mandatoryAttrMissingError(this.name(), attrName), this.xmlPosition());
        }
        return value;
    }

    public static final /* synthetic */ XmlPullParser access$getParser$p(XmlPositionParser $this) {
        return $this.parser;
    }
}

