/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.paging.ContiguousDataSource;
import androidx.paging.DataSource;
import androidx.paging.PageResult;
import androidx.paging.WrapperPageKeyedDataSource;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class PageKeyedDataSource<Key, Value>
extends ContiguousDataSource<Key, Value> {
    private final Object mKeyLock = new Object();
    @Nullable
    @GuardedBy(value="mKeyLock")
    private Key mNextKey = null;
    @Nullable
    @GuardedBy(value="mKeyLock")
    private Key mPreviousKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeys(@Nullable Key previousKey, @Nullable Key nextKey) {
        Object object = this.mKeyLock;
        synchronized (object) {
            this.mPreviousKey = previousKey;
            this.mNextKey = nextKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPreviousKey(@Nullable Key previousKey) {
        Object object = this.mKeyLock;
        synchronized (object) {
            this.mPreviousKey = previousKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNextKey(@Nullable Key nextKey) {
        Object object = this.mKeyLock;
        synchronized (object) {
            this.mNextKey = nextKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Key getPreviousKey() {
        Object object = this.mKeyLock;
        synchronized (object) {
            return this.mPreviousKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Key getNextKey() {
        Object object = this.mKeyLock;
        synchronized (object) {
            return this.mNextKey;
        }
    }

    @Override
    @Nullable
    final Key getKey(int position, Value item) {
        return null;
    }

    @Override
    final void dispatchLoadInitial(@Nullable Key key, int initialLoadSize, int pageSize, boolean enablePlaceholders, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
        LoadInitialCallbackImpl callback = new LoadInitialCallbackImpl(this, enablePlaceholders, receiver);
        this.loadInitial(new LoadInitialParams(initialLoadSize, enablePlaceholders), callback);
        callback.mCallbackHelper.setPostExecutor(mainThreadExecutor);
    }

    @Override
    final void dispatchLoadAfter(int currentEndIndex, @NonNull Value currentEndItem, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
        Key key = this.getNextKey();
        if (key != null) {
            this.loadAfter(new LoadParams<Key>(key, pageSize), new LoadCallbackImpl(this, 1, mainThreadExecutor, receiver));
        }
    }

    @Override
    final void dispatchLoadBefore(int currentBeginIndex, @NonNull Value currentBeginItem, int pageSize, @NonNull Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
        Key key = this.getPreviousKey();
        if (key != null) {
            this.loadBefore(new LoadParams<Key>(key, pageSize), new LoadCallbackImpl(this, 2, mainThreadExecutor, receiver));
        }
    }

    public abstract void loadInitial(@NonNull LoadInitialParams<Key> var1, @NonNull LoadInitialCallback<Key, Value> var2);

    public abstract void loadBefore(@NonNull LoadParams<Key> var1, @NonNull LoadCallback<Key, Value> var2);

    public abstract void loadAfter(@NonNull LoadParams<Key> var1, @NonNull LoadCallback<Key, Value> var2);

    @Override
    @NonNull
    public final <ToValue> PageKeyedDataSource<Key, ToValue> mapByPage(@NonNull Function<List<Value>, List<ToValue>> function) {
        return new WrapperPageKeyedDataSource(this, function);
    }

    @Override
    @NonNull
    public final <ToValue> PageKeyedDataSource<Key, ToValue> map(@NonNull Function<Value, ToValue> function) {
        return this.mapByPage((Function)PageKeyedDataSource.createListFunction(function));
    }

    static class LoadCallbackImpl<Key, Value>
    extends LoadCallback<Key, Value> {
        final DataSource.LoadCallbackHelper<Value> mCallbackHelper;
        private final PageKeyedDataSource<Key, Value> mDataSource;

        LoadCallbackImpl(@NonNull PageKeyedDataSource<Key, Value> dataSource, int type, @Nullable Executor mainThreadExecutor, @NonNull PageResult.Receiver<Value> receiver) {
            this.mCallbackHelper = new DataSource.LoadCallbackHelper<Value>(dataSource, type, mainThreadExecutor, receiver);
            this.mDataSource = dataSource;
        }

        @Override
        public void onResult(@NonNull List<Value> data, @Nullable Key adjacentPageKey) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                if (this.mCallbackHelper.mResultType == 1) {
                    ((PageKeyedDataSource)this.mDataSource).setNextKey(adjacentPageKey);
                } else {
                    ((PageKeyedDataSource)this.mDataSource).setPreviousKey(adjacentPageKey);
                }
                this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, 0, 0, 0));
            }
        }
    }

    static class LoadInitialCallbackImpl<Key, Value>
    extends LoadInitialCallback<Key, Value> {
        final DataSource.LoadCallbackHelper<Value> mCallbackHelper;
        private final PageKeyedDataSource<Key, Value> mDataSource;
        private final boolean mCountingEnabled;

        LoadInitialCallbackImpl(@NonNull PageKeyedDataSource<Key, Value> dataSource, boolean countingEnabled, @NonNull PageResult.Receiver<Value> receiver) {
            this.mCallbackHelper = new DataSource.LoadCallbackHelper<Value>(dataSource, 0, null, receiver);
            this.mDataSource = dataSource;
            this.mCountingEnabled = countingEnabled;
        }

        @Override
        public void onResult(@NonNull List<Value> data, int position, int totalCount, @Nullable Key previousPageKey, @Nullable Key nextPageKey) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                DataSource.LoadCallbackHelper.validateInitialLoadParams(data, position, totalCount);
                ((PageKeyedDataSource)this.mDataSource).initKeys(previousPageKey, nextPageKey);
                int trailingUnloadedCount = totalCount - position - data.size();
                if (this.mCountingEnabled) {
                    this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, position, trailingUnloadedCount, 0));
                } else {
                    this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, position));
                }
            }
        }

        @Override
        public void onResult(@NonNull List<Value> data, @Nullable Key previousPageKey, @Nullable Key nextPageKey) {
            if (!this.mCallbackHelper.dispatchInvalidResultIfInvalid()) {
                ((PageKeyedDataSource)this.mDataSource).initKeys(previousPageKey, nextPageKey);
                this.mCallbackHelper.dispatchResultToReceiver(new PageResult<Value>(data, 0, 0, 0));
            }
        }
    }

    public static abstract class LoadCallback<Key, Value> {
        public abstract void onResult(@NonNull List<Value> var1, @Nullable Key var2);
    }

    public static abstract class LoadInitialCallback<Key, Value> {
        public abstract void onResult(@NonNull List<Value> var1, int var2, int var3, @Nullable Key var4, @Nullable Key var5);

        public abstract void onResult(@NonNull List<Value> var1, @Nullable Key var2, @Nullable Key var3);
    }

    public static class LoadParams<Key> {
        public final Key key;
        public final int requestedLoadSize;

        public LoadParams(Key key, int requestedLoadSize) {
            this.key = key;
            this.requestedLoadSize = requestedLoadSize;
        }
    }

    public static class LoadInitialParams<Key> {
        public final int requestedLoadSize;
        public final boolean placeholdersEnabled;

        public LoadInitialParams(int requestedLoadSize, boolean placeholdersEnabled) {
            this.requestedLoadSize = requestedLoadSize;
            this.placeholdersEnabled = placeholdersEnabled;
        }
    }
}

