/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.CombinedLoadStates;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.TransformablePage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0003\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J2\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0000\"\b\b\u0001\u0010\t*\u00020\u00022\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u000b0\u0006H\u0016J,\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0000\"\b\b\u0001\u0010\t*\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\t0\u0006H\u0016\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Landroidx/paging/PageEvent;", "T", "", "()V", "filter", "predicate", "Lkotlin/Function1;", "", "flatMap", "R", "transform", "", "map", "Drop", "Insert", "LoadStateUpdate", "Landroidx/paging/PageEvent$Insert;", "Landroidx/paging/PageEvent$Drop;", "Landroidx/paging/PageEvent$LoadStateUpdate;", "paging-common"})
public abstract class PageEvent<T> {
    @NotNull
    public <R> PageEvent<R> map(@NotNull Function1<? super T, ? extends R> transform2) {
        Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
        PageEvent pageEvent = this;
        if (pageEvent == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.paging.PageEvent<R>");
        }
        return pageEvent;
    }

    @NotNull
    public <R> PageEvent<R> flatMap(@NotNull Function1<? super T, ? extends Iterable<? extends R>> transform2) {
        Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
        PageEvent pageEvent = this;
        if (pageEvent == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.paging.PageEvent<R>");
        }
        return pageEvent;
    }

    @NotNull
    public PageEvent<T> filter(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        return this;
    }

    private PageEvent() {
    }

    public /* synthetic */ PageEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 /*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001/B;\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00c6\u0003JM\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\"\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001f0#H\u0016J2\u0010$\u001a\b\u0012\u0004\u0012\u0002H%0\u0003\"\b\b\u0002\u0010%*\u00020\u00022\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0'0#H\u0016J\t\u0010(\u001a\u00020\nH\u00d6\u0001J,\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u0003\"\b\b\u0002\u0010%*\u00020\u00022\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H%0#H\u0016J9\u0010*\u001a\b\u0012\u0004\u0012\u0002H%0\u0000\"\b\b\u0002\u0010%*\u00020\u00022\u001e\u0010&\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0\b0#H\u0082\bJ\t\u0010+\u001a\u00020,H\u00d6\u0001JJ\u0010-\u001a\b\u0012\u0004\u0012\u0002H%0\u0000\"\b\b\u0002\u0010%*\u00020\u00022*\u0010&\u001a&\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0\b0\u00070#H\u0080\b\u00a2\u0006\u0002\b.R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u00060"}, d2={"Landroidx/paging/PageEvent$Insert;", "T", "", "Landroidx/paging/PageEvent;", "loadType", "Landroidx/paging/LoadType;", "pages", "", "Landroidx/paging/TransformablePage;", "placeholdersBefore", "", "placeholdersAfter", "combinedLoadStates", "Landroidx/paging/CombinedLoadStates;", "(Landroidx/paging/LoadType;Ljava/util/List;IILandroidx/paging/CombinedLoadStates;)V", "getCombinedLoadStates", "()Landroidx/paging/CombinedLoadStates;", "getLoadType", "()Landroidx/paging/LoadType;", "getPages", "()Ljava/util/List;", "getPlaceholdersAfter", "()I", "getPlaceholdersBefore", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "filter", "predicate", "Lkotlin/Function1;", "flatMap", "R", "transform", "", "hashCode", "map", "mapPages", "toString", "", "transformPages", "transformPages$paging_common", "Companion", "paging-common"})
    public static final class Insert<T>
    extends PageEvent<T> {
        @NotNull
        private final LoadType loadType;
        @NotNull
        private final List<TransformablePage<T>> pages;
        private final int placeholdersBefore;
        private final int placeholdersAfter;
        @NotNull
        private final CombinedLoadStates combinedLoadStates;
        @NotNull
        private static final Insert<Object> EMPTY_REFRESH_LOCAL;
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        private final <R> Insert<R> mapPages(Function1<? super TransformablePage<T>, TransformablePage<R>> transform2) {
            void $this$mapTo$iv$iv;
            void it;
            int $i$f$mapPages = 0;
            Insert this_$iv = this;
            boolean $i$f$transformPages$paging_common = false;
            List<TransformablePage<T>> list = this_$iv.getPages();
            LoadType loadType = this_$iv.getLoadType();
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(transform2.invoke(item$iv$iv));
            }
            List list2 = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            CombinedLoadStates combinedLoadStates = this_$iv.getCombinedLoadStates();
            int n = this_$iv.getPlaceholdersAfter();
            int n2 = this_$iv.getPlaceholdersBefore();
            List list3 = list2;
            LoadType loadType2 = loadType;
            return new Insert<T>(loadType2, list3, n2, n, combinedLoadStates, defaultConstructorMarker);
        }

        @NotNull
        public final <R> Insert<R> transformPages$paging_common(@NotNull Function1<? super List<TransformablePage<T>>, ? extends List<TransformablePage<R>>> transform2) {
            int $i$f$transformPages$paging_common = 0;
            Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
            return new Insert<T>(this.getLoadType(), (List)transform2.invoke(this.getPages()), this.getPlaceholdersBefore(), this.getPlaceholdersAfter(), this.getCombinedLoadStates(), null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public <R> PageEvent<R> map(@NotNull Function1<? super T, ? extends R> transform2) {
            Object object;
            void $this$mapTo$iv$iv$iv;
            void it$iv;
            Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
            Insert this_$iv = this;
            boolean $i$f$mapPages = false;
            Insert this_$iv$iv = this_$iv;
            boolean $i$f$transformPages$paging_common = false;
            List<TransformablePage<T>> list = this_$iv$iv.getPages();
            LoadType loadType = this_$iv$iv.getLoadType();
            boolean bl = false;
            Iterable $this$map$iv$iv = (Iterable)it$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void it;
                object = (TransformablePage)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = it.getData();
                Function1<? super T, ? extends R> function1 = transform2;
                int n = it.getOriginalPageOffset();
                boolean $i$f$map2 = false;
                void var26_22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void transform$iv;
                    destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
                }
                List list2 = (List)destination$iv$iv;
                List<Integer> list3 = it.getOriginalIndices();
                int n2 = it.getOriginalPageSize();
                List list4 = list2;
                int n3 = n;
                TransformablePage transformablePage = new TransformablePage(n3, list4, n2, list3);
                collection.add(transformablePage);
            }
            object = (List)destination$iv$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            CombinedLoadStates combinedLoadStates = this_$iv$iv.getCombinedLoadStates();
            int n = this_$iv$iv.getPlaceholdersAfter();
            int n4 = this_$iv$iv.getPlaceholdersBefore();
            List list5 = object;
            LoadType loadType2 = loadType;
            return new Insert<T>(loadType2, list5, n4, n, combinedLoadStates, defaultConstructorMarker);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public <R> PageEvent<R> flatMap(@NotNull Function1<? super T, ? extends Iterable<? extends R>> transform2) {
            Object object;
            void $this$mapTo$iv$iv$iv;
            void it$iv;
            Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
            Insert this_$iv = this;
            boolean $i$f$mapPages = false;
            Insert this_$iv$iv = this_$iv;
            boolean $i$f$transformPages$paging_common = false;
            List<TransformablePage<T>> list = this_$iv$iv.getPages();
            LoadType loadType = this_$iv$iv.getLoadType();
            boolean bl = false;
            Iterable $this$map$iv$iv = (Iterable)it$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it;
                object = (TransformablePage)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                boolean bl3 = false;
                List data = new ArrayList();
                boolean bl4 = false;
                List originalIndices = new ArrayList();
                Iterable $this$forEachIndexed$iv = it.getData();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int indexToStore;
                    void t;
                    int n = index$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    Object t2 = item$iv;
                    int index = n2;
                    boolean bl6 = false;
                    Collection collection2 = data;
                    Iterable iterable2 = (Iterable)transform2.invoke((Object)t);
                    boolean bl7 = false;
                    CollectionsKt.addAll((Collection)collection2, (Iterable)iterable2);
                    List<Integer> list2 = it.getOriginalIndices();
                    int n3 = list2 != null && (list2 = list2.get(index)) != null ? (Integer)((Object)list2) : (indexToStore = index);
                    while (originalIndices.size() < data.size()) {
                        originalIndices.add(indexToStore);
                    }
                }
                TransformablePage transformablePage = new TransformablePage(it.getOriginalPageOffset(), data, it.getOriginalPageSize(), originalIndices);
                collection.add(transformablePage);
            }
            object = (List)destination$iv$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            CombinedLoadStates combinedLoadStates = this_$iv$iv.getCombinedLoadStates();
            int n = this_$iv$iv.getPlaceholdersAfter();
            int n4 = this_$iv$iv.getPlaceholdersBefore();
            List list3 = object;
            LoadType loadType2 = loadType;
            return new Insert<T>(loadType2, list3, n4, n, combinedLoadStates, defaultConstructorMarker);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PageEvent<T> filter(@NotNull Function1<? super T, Boolean> predicate) {
            Object object;
            void $this$mapTo$iv$iv$iv;
            void it$iv;
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Insert this_$iv = this;
            boolean $i$f$mapPages = false;
            Insert this_$iv$iv = this_$iv;
            boolean $i$f$transformPages$paging_common = false;
            List<TransformablePage<T>> list = this_$iv$iv.getPages();
            LoadType loadType = this_$iv$iv.getLoadType();
            boolean bl = false;
            Iterable $this$map$iv$iv = (Iterable)it$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it;
                object = (TransformablePage)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                boolean bl3 = false;
                List data = new ArrayList();
                boolean bl4 = false;
                List originalIndices = new ArrayList();
                Iterable $this$forEachIndexed$iv = it.getData();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void t;
                    int n = index$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    Object t2 = item$iv;
                    int index = n2;
                    boolean bl6 = false;
                    if (!((Boolean)predicate.invoke((Object)t)).booleanValue()) continue;
                    data.add(t);
                    List<Integer> list2 = it.getOriginalIndices();
                    originalIndices.add(list2 != null && (list2 = list2.get(index)) != null ? (Integer)((Object)list2) : index);
                }
                TransformablePage transformablePage = new TransformablePage(it.getOriginalPageOffset(), data, it.getOriginalPageSize(), originalIndices);
                collection.add(transformablePage);
            }
            object = (List)destination$iv$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            CombinedLoadStates combinedLoadStates = this_$iv$iv.getCombinedLoadStates();
            int n = this_$iv$iv.getPlaceholdersAfter();
            int n3 = this_$iv$iv.getPlaceholdersBefore();
            List list3 = object;
            LoadType loadType2 = loadType;
            return new Insert<T>(loadType2, list3, n3, n, combinedLoadStates, defaultConstructorMarker);
        }

        @NotNull
        public final LoadType getLoadType() {
            return this.loadType;
        }

        @NotNull
        public final List<TransformablePage<T>> getPages() {
            return this.pages;
        }

        public final int getPlaceholdersBefore() {
            return this.placeholdersBefore;
        }

        public final int getPlaceholdersAfter() {
            return this.placeholdersAfter;
        }

        @NotNull
        public final CombinedLoadStates getCombinedLoadStates() {
            return this.combinedLoadStates;
        }

        private Insert(LoadType loadType, List<TransformablePage<T>> pages, int placeholdersBefore, int placeholdersAfter, CombinedLoadStates combinedLoadStates) {
            super(null);
            this.loadType = loadType;
            this.pages = pages;
            this.placeholdersBefore = placeholdersBefore;
            this.placeholdersAfter = placeholdersAfter;
            this.combinedLoadStates = combinedLoadStates;
            boolean bl = this.loadType == LoadType.APPEND || this.placeholdersBefore >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Append state defining placeholdersBefore must be > 0, but was" + ' ' + this.placeholdersBefore;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = this.loadType == LoadType.PREPEND || this.placeholdersAfter >= 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Prepend state defining placeholdersAfter must be > 0, but was" + ' ' + this.placeholdersAfter;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        static {
            Companion companion = Companion = new Companion(null);
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            EMPTY_REFRESH_LOCAL = companion.Refresh(list, 0, 0, new CombinedLoadStates(new LoadStates(LoadState.NotLoading.Companion.getIncomplete$paging_common(), LoadState.NotLoading.Companion.getComplete$paging_common(), LoadState.NotLoading.Companion.getComplete$paging_common()), null, 2, null));
        }

        public /* synthetic */ Insert(LoadType loadType, List pages, int placeholdersBefore, int placeholdersAfter, CombinedLoadStates combinedLoadStates, DefaultConstructorMarker $constructor_marker) {
            this(loadType, pages, placeholdersBefore, placeholdersAfter, combinedLoadStates);
        }

        @NotNull
        public final LoadType component1() {
            return this.loadType;
        }

        @NotNull
        public final List<TransformablePage<T>> component2() {
            return this.pages;
        }

        public final int component3() {
            return this.placeholdersBefore;
        }

        public final int component4() {
            return this.placeholdersAfter;
        }

        @NotNull
        public final CombinedLoadStates component5() {
            return this.combinedLoadStates;
        }

        @NotNull
        public final Insert<T> copy(@NotNull LoadType loadType, @NotNull List<TransformablePage<T>> pages, int placeholdersBefore, int placeholdersAfter, @NotNull CombinedLoadStates combinedLoadStates) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
            Intrinsics.checkParameterIsNotNull((Object)combinedLoadStates, (String)"combinedLoadStates");
            return new Insert<T>(loadType, pages, placeholdersBefore, placeholdersAfter, combinedLoadStates);
        }

        public static /* synthetic */ Insert copy$default(Insert insert, LoadType loadType, List list, int n, int n2, CombinedLoadStates combinedLoadStates, int n3, Object object) {
            if ((n3 & 1) != 0) {
                loadType = insert.loadType;
            }
            if ((n3 & 2) != 0) {
                list = insert.pages;
            }
            if ((n3 & 4) != 0) {
                n = insert.placeholdersBefore;
            }
            if ((n3 & 8) != 0) {
                n2 = insert.placeholdersAfter;
            }
            if ((n3 & 0x10) != 0) {
                combinedLoadStates = insert.combinedLoadStates;
            }
            return insert.copy(loadType, list, n, n2, combinedLoadStates);
        }

        @NotNull
        public String toString() {
            return "Insert(loadType=" + (Object)((Object)this.loadType) + ", pages=" + this.pages + ", placeholdersBefore=" + this.placeholdersBefore + ", placeholdersAfter=" + this.placeholdersAfter + ", combinedLoadStates=" + this.combinedLoadStates + ")";
        }

        public int hashCode() {
            LoadType loadType = this.loadType;
            List<TransformablePage<T>> list = this.pages;
            CombinedLoadStates combinedLoadStates = this.combinedLoadStates;
            return ((((loadType != null ? ((Object)((Object)loadType)).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.placeholdersBefore)) * 31 + Integer.hashCode(this.placeholdersAfter)) * 31 + (combinedLoadStates != null ? ((Object)combinedLoadStates).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Insert)) break block3;
                    Insert insert = (Insert)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.loadType), (Object)((Object)insert.loadType)) || !Intrinsics.areEqual(this.pages, insert.pages) || this.placeholdersBefore != insert.placeholdersBefore || this.placeholdersAfter != insert.placeholdersAfter || !Intrinsics.areEqual((Object)this.combinedLoadStates, (Object)insert.combinedLoadStates)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0004\"\b\b\u0002\u0010\b*\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ:\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\b0\u0004\"\b\b\u0002\u0010\b*\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJB\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u0004\"\b\b\u0002\u0010\b*\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Landroidx/paging/PageEvent$Insert$Companion;", "", "()V", "EMPTY_REFRESH_LOCAL", "Landroidx/paging/PageEvent$Insert;", "getEMPTY_REFRESH_LOCAL", "()Landroidx/paging/PageEvent$Insert;", "Append", "T", "pages", "", "Landroidx/paging/TransformablePage;", "placeholdersAfter", "", "combinedLoadStates", "Landroidx/paging/CombinedLoadStates;", "Prepend", "placeholdersBefore", "Refresh", "paging-common"})
        public static final class Companion {
            @NotNull
            public final <T> Insert<T> Refresh(@NotNull List<TransformablePage<T>> pages, int placeholdersBefore, int placeholdersAfter, @NotNull CombinedLoadStates combinedLoadStates) {
                Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
                Intrinsics.checkParameterIsNotNull((Object)combinedLoadStates, (String)"combinedLoadStates");
                return new Insert(LoadType.REFRESH, pages, placeholdersBefore, placeholdersAfter, combinedLoadStates, null);
            }

            @NotNull
            public final <T> Insert<T> Prepend(@NotNull List<TransformablePage<T>> pages, int placeholdersBefore, @NotNull CombinedLoadStates combinedLoadStates) {
                Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
                Intrinsics.checkParameterIsNotNull((Object)combinedLoadStates, (String)"combinedLoadStates");
                return new Insert(LoadType.PREPEND, pages, placeholdersBefore, -1, combinedLoadStates, null);
            }

            @NotNull
            public final <T> Insert<T> Append(@NotNull List<TransformablePage<T>> pages, int placeholdersAfter, @NotNull CombinedLoadStates combinedLoadStates) {
                Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
                Intrinsics.checkParameterIsNotNull((Object)combinedLoadStates, (String)"combinedLoadStates");
                return new Insert(LoadType.APPEND, pages, -1, placeholdersAfter, combinedLoadStates, null);
            }

            @NotNull
            public final Insert<Object> getEMPTY_REFRESH_LOCAL() {
                return EMPTY_REFRESH_LOCAL;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0019"}, d2={"Landroidx/paging/PageEvent$Drop;", "T", "", "Landroidx/paging/PageEvent;", "loadType", "Landroidx/paging/LoadType;", "count", "", "placeholdersRemaining", "(Landroidx/paging/LoadType;II)V", "getCount", "()I", "getLoadType", "()Landroidx/paging/LoadType;", "getPlaceholdersRemaining", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "paging-common"})
    public static final class Drop<T>
    extends PageEvent<T> {
        @NotNull
        private final LoadType loadType;
        private final int count;
        private final int placeholdersRemaining;

        @NotNull
        public final LoadType getLoadType() {
            return this.loadType;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getPlaceholdersRemaining() {
            return this.placeholdersRemaining;
        }

        public Drop(@NotNull LoadType loadType, int count, int placeholdersRemaining) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loadType), (String)"loadType");
            super(null);
            this.loadType = loadType;
            this.count = count;
            this.placeholdersRemaining = placeholdersRemaining;
            boolean bl = this.loadType != LoadType.REFRESH;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Drop load type must be PREPEND or APPEND";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = this.count >= 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Drop count must be > 0, but was " + this.count;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = this.placeholdersRemaining >= 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Invalid placeholdersRemaining " + this.placeholdersRemaining;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final LoadType component1() {
            return this.loadType;
        }

        public final int component2() {
            return this.count;
        }

        public final int component3() {
            return this.placeholdersRemaining;
        }

        @NotNull
        public final Drop<T> copy(@NotNull LoadType loadType, int count, int placeholdersRemaining) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loadType), (String)"loadType");
            return new Drop<T>(loadType, count, placeholdersRemaining);
        }

        public static /* synthetic */ Drop copy$default(Drop drop, LoadType loadType, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                loadType = drop.loadType;
            }
            if ((n3 & 2) != 0) {
                n = drop.count;
            }
            if ((n3 & 4) != 0) {
                n2 = drop.placeholdersRemaining;
            }
            return drop.copy(loadType, n, n2);
        }

        @NotNull
        public String toString() {
            return "Drop(loadType=" + (Object)((Object)this.loadType) + ", count=" + this.count + ", placeholdersRemaining=" + this.placeholdersRemaining + ")";
        }

        public int hashCode() {
            LoadType loadType = this.loadType;
            return ((loadType != null ? ((Object)((Object)loadType)).hashCode() : 0) * 31 + Integer.hashCode(this.count)) * 31 + Integer.hashCode(this.placeholdersRemaining);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Drop)) break block3;
                    Drop drop = (Drop)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.loadType), (Object)((Object)drop.loadType)) || this.count != drop.count || this.placeholdersRemaining != drop.placeholdersRemaining) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Landroidx/paging/PageEvent$LoadStateUpdate;", "T", "", "Landroidx/paging/PageEvent;", "loadType", "Landroidx/paging/LoadType;", "fromMediator", "", "loadState", "Landroidx/paging/LoadState;", "(Landroidx/paging/LoadType;ZLandroidx/paging/LoadState;)V", "getFromMediator", "()Z", "getLoadState", "()Landroidx/paging/LoadState;", "getLoadType", "()Landroidx/paging/LoadType;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "paging-common"})
    public static final class LoadStateUpdate<T>
    extends PageEvent<T> {
        @NotNull
        private final LoadType loadType;
        private final boolean fromMediator;
        @NotNull
        private final LoadState loadState;

        @NotNull
        public final LoadType getLoadType() {
            return this.loadType;
        }

        public final boolean getFromMediator() {
            return this.fromMediator;
        }

        @NotNull
        public final LoadState getLoadState() {
            return this.loadState;
        }

        public LoadStateUpdate(@NotNull LoadType loadType, boolean fromMediator, @NotNull LoadState loadState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkParameterIsNotNull((Object)loadState, (String)"loadState");
            super(null);
            this.loadType = loadType;
            this.fromMediator = fromMediator;
            this.loadState = loadState;
            boolean bl = this.loadState instanceof LoadState.Loading || this.loadState instanceof LoadState.Error;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "LoadStateUpdates can only be used for Loading or Error. To update loadState to Idle or Done, use Insert / Drop events.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final LoadType component1() {
            return this.loadType;
        }

        public final boolean component2() {
            return this.fromMediator;
        }

        @NotNull
        public final LoadState component3() {
            return this.loadState;
        }

        @NotNull
        public final LoadStateUpdate<T> copy(@NotNull LoadType loadType, boolean fromMediator, @NotNull LoadState loadState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkParameterIsNotNull((Object)loadState, (String)"loadState");
            return new LoadStateUpdate<T>(loadType, fromMediator, loadState);
        }

        public static /* synthetic */ LoadStateUpdate copy$default(LoadStateUpdate loadStateUpdate, LoadType loadType, boolean bl, LoadState loadState, int n, Object object) {
            if ((n & 1) != 0) {
                loadType = loadStateUpdate.loadType;
            }
            if ((n & 2) != 0) {
                bl = loadStateUpdate.fromMediator;
            }
            if ((n & 4) != 0) {
                loadState = loadStateUpdate.loadState;
            }
            return loadStateUpdate.copy(loadType, bl, loadState);
        }

        @NotNull
        public String toString() {
            return "LoadStateUpdate(loadType=" + (Object)((Object)this.loadType) + ", fromMediator=" + this.fromMediator + ", loadState=" + this.loadState + ")";
        }

        public int hashCode() {
            LoadType loadType = this.loadType;
            int n = (loadType != null ? ((Object)((Object)loadType)).hashCode() : 0) * 31;
            int n2 = this.fromMediator ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            LoadState loadState = this.loadState;
            return (n + n2) * 31 + (loadState != null ? loadState.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LoadStateUpdate)) break block3;
                    LoadStateUpdate loadStateUpdate = (LoadStateUpdate)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.loadType), (Object)((Object)loadStateUpdate.loadType)) || this.fromMediator != loadStateUpdate.fromMediator || !Intrinsics.areEqual((Object)this.loadState, (Object)loadStateUpdate.loadState)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

