/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.CombinedLoadStates;
import androidx.paging.DataPage;
import androidx.paging.LoadState;
import androidx.paging.LoadType;
import androidx.paging.PageEvent;
import androidx.paging.SeparatorsKt;
import androidx.paging.TransformablePage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u00020\u0002B%\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u001bJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d*\b\u0012\u0004\u0012\u00028\u00010\u001dJ\n\u0010\u001f\u001a\u00020\b*\u00020 J!\u0010\u001f\u001a\u00020\b\"\b\b\u0002\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u001dH\u0000\u00a2\u0006\u0002\b!J\n\u0010\"\u001a\u00020\b*\u00020 J!\u0010\"\u001a\u00020\b\"\b\b\u0002\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u001dH\u0000\u00a2\u0006\u0002\b#R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR)\u0010\u0004\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\f\u00a8\u0006$"}, d2={"Landroidx/paging/SeparatorState;", "R", "", "T", "generator", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function2;)V", "endTerminalSeparatorDeferred", "", "getEndTerminalSeparatorDeferred", "()Z", "setEndTerminalSeparatorDeferred", "(Z)V", "getGenerator", "()Lkotlin/jvm/functions/Function2;", "pageStash", "", "Landroidx/paging/DataPage;", "getPageStash", "()Ljava/util/List;", "startTerminalSeparatorDeferred", "getStartTerminalSeparatorDeferred", "setStartTerminalSeparatorDeferred", "onDrop", "Landroidx/paging/PageEvent$Drop;", "event", "onEvent", "Landroidx/paging/PageEvent;", "onInsert", "Landroidx/paging/PageEvent$Insert;", "asRType", "terminatesEnd", "Landroidx/paging/CombinedLoadStates;", "terminatesEnd$paging_common", "terminatesStart", "terminatesStart$paging_common", "paging-common"})
final class SeparatorState<R, T extends R> {
    @NotNull
    private final List<DataPage<T>> pageStash;
    private boolean endTerminalSeparatorDeferred;
    private boolean startTerminalSeparatorDeferred;
    @NotNull
    private final Function2<T, T, R> generator;

    @NotNull
    public final List<DataPage<T>> getPageStash() {
        return this.pageStash;
    }

    public final boolean getEndTerminalSeparatorDeferred() {
        return this.endTerminalSeparatorDeferred;
    }

    public final void setEndTerminalSeparatorDeferred(boolean bl) {
        this.endTerminalSeparatorDeferred = bl;
    }

    public final boolean getStartTerminalSeparatorDeferred() {
        return this.startTerminalSeparatorDeferred;
    }

    public final void setStartTerminalSeparatorDeferred(boolean bl) {
        this.startTerminalSeparatorDeferred = bl;
    }

    @NotNull
    public final PageEvent<R> onEvent(@NotNull PageEvent<T> event) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        PageEvent pageEvent;
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        PageEvent pageEvent2 = event;
        if (pageEvent2 instanceof PageEvent.Insert) {
            pageEvent = this.onInsert((PageEvent.Insert)event);
        } else if (pageEvent2 instanceof PageEvent.Drop) {
            PageEvent.Drop<T> drop = this.onDrop((PageEvent.Drop)event);
            if (drop == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.paging.PageEvent.Drop<R>");
            }
            pageEvent = drop;
        } else if (pageEvent2 instanceof PageEvent.LoadStateUpdate) {
            pageEvent = event;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        pageEvent2 = pageEvent;
        boolean bl4 = false;
        boolean bl5 = false;
        PageEvent it = pageEvent2;
        boolean bl6 = false;
        if (this.endTerminalSeparatorDeferred) {
            bl3 = this.pageStash.isEmpty();
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl7 = false;
                String string = "deferred endTerm, page stash should be empty";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        if (this.startTerminalSeparatorDeferred) {
            bl3 = this.pageStash.isEmpty();
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl8 = false;
                String string = "deferred startTerm, page stash should be empty";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return pageEvent2;
    }

    @NotNull
    public final PageEvent.Insert<R> asRType(@NotNull PageEvent.Insert<T> $this$asRType) {
        Intrinsics.checkParameterIsNotNull($this$asRType, (String)"$this$asRType");
        return $this$asRType;
    }

    public final boolean terminatesStart(@NotNull CombinedLoadStates $this$terminatesStart) {
        Intrinsics.checkParameterIsNotNull((Object)$this$terminatesStart, (String)"$this$terminatesStart");
        LoadState endState = $this$terminatesStart.getPrepend();
        return endState instanceof LoadState.NotLoading && endState.getEndOfPaginationReached();
    }

    public final boolean terminatesEnd(@NotNull CombinedLoadStates $this$terminatesEnd) {
        Intrinsics.checkParameterIsNotNull((Object)$this$terminatesEnd, (String)"$this$terminatesEnd");
        LoadState endState = $this$terminatesEnd.getAppend();
        return endState instanceof LoadState.NotLoading && endState.getEndOfPaginationReached();
    }

    public final <T> boolean terminatesStart$paging_common(@NotNull PageEvent.Insert<T> $this$terminatesStart) {
        Intrinsics.checkParameterIsNotNull($this$terminatesStart, (String)"$this$terminatesStart");
        return $this$terminatesStart.getLoadType() == LoadType.APPEND ? this.startTerminalSeparatorDeferred : this.terminatesStart($this$terminatesStart.getCombinedLoadStates());
    }

    public final <T> boolean terminatesEnd$paging_common(@NotNull PageEvent.Insert<T> $this$terminatesEnd) {
        Intrinsics.checkParameterIsNotNull($this$terminatesEnd, (String)"$this$terminatesEnd");
        return $this$terminatesEnd.getLoadType() == LoadType.PREPEND ? this.endTerminalSeparatorDeferred : this.terminatesEnd($this$terminatesEnd.getCombinedLoadStates());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PageEvent.Insert<R> onInsert(@NotNull PageEvent.Insert<T> event) {
        Object separator;
        ArrayList outStateList;
        ArrayList<TransformablePage<Object>> outList;
        boolean eventEmpty;
        boolean eventTerminatesEnd;
        block30: {
            Object object;
            Intrinsics.checkParameterIsNotNull(event, (String)"event");
            boolean eventTerminatesStart = this.terminatesStart$paging_common(event);
            eventTerminatesEnd = this.terminatesEnd$paging_common(event);
            eventEmpty = event.getPages().isEmpty();
            Collection collection = this.pageStash;
            boolean bl = false;
            if (!collection.isEmpty()) {
                boolean bl2 = CollectionsKt.first(this.pageStash) != null || event.getLoadType() != LoadType.PREPEND;
                bl = false;
                boolean bl3 = false;
                if (!bl2) {
                    boolean bl4 = false;
                    String string = "Additional prepend event after prepend state is done";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                bl2 = CollectionsKt.last(this.pageStash) != null || event.getLoadType() != LoadType.APPEND;
                bl = false;
                bl3 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string = "Additional append event after append state is done";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            if (eventEmpty) {
                if (eventTerminatesStart && eventTerminatesEnd) {
                    Object separator2 = this.generator.invoke(null, null);
                    this.endTerminalSeparatorDeferred = false;
                    this.startTerminalSeparatorDeferred = false;
                    this.pageStash.add(null);
                    PageEvent.Insert<T> this_$iv = event;
                    boolean $i$f$transformPages$paging_common = false;
                    List<TransformablePage<T>> bl5 = this_$iv.getPages();
                    LoadType loadType = this_$iv.getLoadType();
                    boolean bl6 = false;
                    List list = CollectionsKt.listOf(SeparatorsKt.separatorPage(separator2, 0, 0, 0));
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    CombinedLoadStates combinedLoadStates = this_$iv.getCombinedLoadStates();
                    int n = this_$iv.getPlaceholdersAfter();
                    int n2 = this_$iv.getPlaceholdersBefore();
                    List list2 = list;
                    LoadType loadType2 = loadType;
                    return new PageEvent.Insert(loadType2, list2, n2, n, combinedLoadStates, defaultConstructorMarker);
                }
                if (!eventTerminatesStart && !eventTerminatesEnd) {
                    return this.asRType(event);
                }
                if (this.pageStash.isEmpty()) {
                    if (eventTerminatesEnd) {
                        this.endTerminalSeparatorDeferred = true;
                    }
                    if (eventTerminatesStart) {
                        this.startTerminalSeparatorDeferred = true;
                    }
                    return this.asRType(event);
                }
            }
            outList = new ArrayList<TransformablePage<Object>>(event.getPages().size());
            outStateList = new ArrayList(event.getPages().size());
            if (eventTerminatesStart) {
                outStateList.add(null);
                if (eventEmpty) {
                    Object object2 = CollectionsKt.first(this.pageStash);
                    if (object2 == null) {
                        Intrinsics.throwNpe();
                    }
                    DataPage firstStash = (DataPage)object2;
                    separator = this.generator.invoke(null, firstStash.getFirst());
                    outList.add(SeparatorsKt.separatorPage(separator, firstStash, 0));
                } else {
                    TransformablePage firstPage = (TransformablePage)CollectionsKt.first(event.getPages());
                    separator = this.generator.invoke(null, CollectionsKt.first(firstPage.getData()));
                    outList.add(SeparatorsKt.separatorPage(separator, firstPage, 0));
                }
            }
            if (eventEmpty) break block30;
            if (event.getLoadType() == LoadType.APPEND) {
                DataPage dataPage = (DataPage)CollectionsKt.lastOrNull(this.pageStash);
                object = dataPage != null ? (Object)dataPage.getLast() : null;
            } else {
                object = null;
            }
            Object itemBefore = object;
            Iterable $this$forEachIndexed$iv = event.getPages();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void page;
                block32: {
                    block31: {
                        int n = index$iv++;
                        boolean bl7 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        int n3 = n;
                        TransformablePage transformablePage = (TransformablePage)item$iv;
                        int index = n3;
                        boolean bl8 = false;
                        if (index != 0) break block31;
                        if (event.getLoadType() != LoadType.APPEND) break block32;
                        Collection collection2 = this.pageStash;
                        boolean bl9 = false;
                        if (!(!collection2.isEmpty())) break block32;
                    }
                    Object object3 = itemBefore;
                    if (object3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Object separator3 = this.generator.invoke(object3, CollectionsKt.first(page.getData()));
                    outStateList.add(null);
                    outList.add(SeparatorsKt.separatorPage(separator3, page, 0));
                }
                outStateList.add(new DataPage(page));
                outList.add(SeparatorsKt.insertInternalSeparators(page, this.generator));
                itemBefore = CollectionsKt.last(page.getData());
            }
            if (event.getLoadType() == LoadType.PREPEND) {
                $this$forEachIndexed$iv = this.pageStash;
                $i$f$forEachIndexed = false;
                if (!$this$forEachIndexed$iv.isEmpty()) {
                    TransformablePage lastPage = (TransformablePage)CollectionsKt.last(event.getPages());
                    Object object4 = CollectionsKt.last(lastPage.getData());
                    Object object5 = CollectionsKt.first(this.pageStash);
                    if (object5 == null) {
                        Intrinsics.throwNpe();
                    }
                    Object separator4 = this.generator.invoke(object4, ((DataPage)object5).getFirst());
                    outStateList.add(null);
                    outList.add(SeparatorsKt.separatorPage(separator4, lastPage, lastPage.getOriginalLastIndex()));
                }
            }
        }
        if (eventTerminatesEnd) {
            outStateList.add(null);
            if (eventEmpty) {
                Object object = CollectionsKt.last(this.pageStash);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                DataPage lastStash = (DataPage)object;
                separator = this.generator.invoke(lastStash.getLast(), null);
                outList.add(SeparatorsKt.separatorPage(separator, lastStash, lastStash.getOriginalLastIndex()));
            } else {
                TransformablePage lastPage = (TransformablePage)CollectionsKt.last(event.getPages());
                separator = this.generator.invoke(CollectionsKt.first(lastPage.getData()), null);
                outList.add(SeparatorsKt.separatorPage(separator, lastPage, lastPage.getOriginalLastIndex()));
            }
        }
        this.endTerminalSeparatorDeferred = false;
        this.startTerminalSeparatorDeferred = false;
        if (event.getLoadType() == LoadType.APPEND) {
            this.pageStash.addAll(outStateList);
        } else {
            this.pageStash.addAll(0, outStateList);
        }
        PageEvent.Insert<T> this_$iv = event;
        boolean $i$f$transformPages$paging_common = false;
        List<TransformablePage<T>> separator4 = this_$iv.getPages();
        LoadType loadType = this_$iv.getLoadType();
        boolean bl = false;
        ArrayList<TransformablePage<Object>> arrayList = outList;
        DefaultConstructorMarker defaultConstructorMarker = null;
        CombinedLoadStates combinedLoadStates = this_$iv.getCombinedLoadStates();
        int n = this_$iv.getPlaceholdersAfter();
        int n4 = this_$iv.getPlaceholdersBefore();
        List list = arrayList;
        LoadType loadType3 = loadType;
        return new PageEvent.Insert(loadType3, list, n4, n, combinedLoadStates, defaultConstructorMarker);
    }

    @NotNull
    public final PageEvent.Drop<T> onDrop(@NotNull PageEvent.Drop<T> event) {
        int n;
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        if (event.getLoadType() == LoadType.PREPEND) {
            if (this.pageStash.isEmpty()) {
                this.startTerminalSeparatorDeferred = false;
            }
            n = SeparatorsKt.dropPagesStart(this.pageStash, event.getCount());
        } else {
            if (this.pageStash.isEmpty()) {
                this.endTerminalSeparatorDeferred = false;
            }
            n = SeparatorsKt.dropPagesEnd(this.pageStash, event.getCount());
        }
        int newCount = n;
        return newCount == event.getCount() ? event : PageEvent.Drop.copy$default(event, null, newCount, 0, 5, null);
    }

    @NotNull
    public final Function2<T, T, R> getGenerator() {
        return this.generator;
    }

    public SeparatorState(@NotNull Function2<? super T, ? super T, ? extends R> generator) {
        List list;
        Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
        this.generator = generator;
        SeparatorState separatorState = this;
        boolean bl = false;
        separatorState.pageStash = list = (List)new ArrayList();
    }
}

