/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.CombinedLoadStates;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.MutableLoadStateCollection$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\b\u001a\u00020\t2 \u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\t0\u000bH\u0080\b\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u0014J\u0014\u0010\u000f\u001a\u00020\r*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/paging/MutableLoadStateCollection;", "", "hasRemoteState", "", "(Z)V", "mediator", "Landroidx/paging/LoadStates;", "source", "forEach", "", "op", "Lkotlin/Function3;", "Landroidx/paging/LoadType;", "Landroidx/paging/LoadState;", "forEach$paging_common", "get", "type", "remote", "set", "combinedLoadStates", "Landroidx/paging/CombinedLoadStates;", "state", "snapshot", "modifyState", "paging-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MutableLoadStateCollection {
    private LoadStates source = LoadStates.Companion.getIDLE();
    private LoadStates mediator;

    @NotNull
    public final CombinedLoadStates snapshot() {
        return new CombinedLoadStates(this.source, this.mediator);
    }

    public final void set(@NotNull CombinedLoadStates combinedLoadStates) {
        Intrinsics.checkParameterIsNotNull((Object)combinedLoadStates, (String)"combinedLoadStates");
        this.source = combinedLoadStates.getSource();
        this.mediator = combinedLoadStates.getMediator();
    }

    public final boolean set(@NotNull LoadType type, boolean remote, @NotNull LoadState state) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (remote) {
            LoadStates lastMediator = this.mediator;
            LoadStates loadStates = this.mediator;
            if (loadStates == null) {
                loadStates = LoadStates.Companion.getIDLE();
            }
            this.mediator = this.modifyState(loadStates, type, state);
            bl = Intrinsics.areEqual((Object)this.mediator, (Object)lastMediator) ^ true;
        } else {
            LoadStates lastSource = this.source;
            this.source = this.modifyState(this.source, type, state);
            bl = Intrinsics.areEqual((Object)this.source, (Object)lastSource) ^ true;
        }
        return bl;
    }

    @Nullable
    public final LoadState get(@NotNull LoadType type, boolean remote) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        LoadStates loadStates = remote ? this.mediator : this.source;
        return loadStates != null ? this.get(loadStates, type) : null;
    }

    public final void forEach$paging_common(@NotNull Function3<? super LoadType, ? super Boolean, ? super LoadState, Unit> op) {
        block0: {
            LoadState state;
            int $i$f$forEach$paging_common = 0;
            Intrinsics.checkParameterIsNotNull(op, (String)"op");
            LoadStates this_$iv = this.source;
            boolean $i$f$forEach = false;
            LoadState loadState = this_$iv.getRefresh();
            LoadType type = LoadType.REFRESH;
            boolean bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            state = this_$iv.getPrepend();
            type = LoadType.PREPEND;
            bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            state = this_$iv.getAppend();
            type = LoadType.APPEND;
            bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            LoadStates loadStates = this.mediator;
            if (loadStates == null) break block0;
            this_$iv = loadStates;
            $i$f$forEach = false;
            state = this_$iv.getRefresh();
            type = LoadType.REFRESH;
            boolean bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
            state = this_$iv.getPrepend();
            type = LoadType.PREPEND;
            bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
            state = this_$iv.getAppend();
            type = LoadType.APPEND;
            bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
        }
    }

    private final LoadState get(@NotNull LoadStates $this$get, LoadType type) {
        LoadState loadState;
        switch (MutableLoadStateCollection$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                loadState = $this$get.getRefresh();
                break;
            }
            case 2: {
                loadState = $this$get.getPrepend();
                break;
            }
            case 3: {
                loadState = $this$get.getAppend();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadState;
    }

    private final LoadStates modifyState(@NotNull LoadStates $this$modifyState, LoadType type, LoadState state) {
        LoadStates loadStates;
        if (Intrinsics.areEqual((Object)this.get($this$modifyState, type), (Object)state)) {
            loadStates = $this$modifyState;
        } else {
            switch (MutableLoadStateCollection$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    loadStates = LoadStates.copy$default($this$modifyState, state, null, null, 6, null);
                    break;
                }
                case 2: {
                    loadStates = LoadStates.copy$default($this$modifyState, null, state, null, 5, null);
                    break;
                }
                case 3: {
                    loadStates = LoadStates.copy$default($this$modifyState, null, null, state, 3, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return loadStates;
    }

    public MutableLoadStateCollection(boolean hasRemoteState) {
        this.mediator = hasRemoteState ? LoadStates.Companion.getIDLE() : null;
    }

    public static final /* synthetic */ void access$setSource$p(MutableLoadStateCollection $this, LoadStates loadStates) {
        $this.source = loadStates;
    }

    public static final /* synthetic */ void access$setMediator$p(MutableLoadStateCollection $this, LoadStates loadStates) {
        $this.mediator = loadStates;
    }
}

