/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\u0011\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u00c6\u0003JE\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\b\u0002\u0010\b\u001a\u00020\u00042\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001e"}, d2={"Landroidx/paging/TransformablePage;", "T", "", "originalPageOffset", "", "data", "", "(ILjava/util/List;)V", "originalPageSize", "originalIndices", "(ILjava/util/List;ILjava/util/List;)V", "getData", "()Ljava/util/List;", "getOriginalIndices", "originalLastIndex", "getOriginalLastIndex", "()I", "getOriginalPageOffset", "getOriginalPageSize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "paging-common"})
public final class TransformablePage<T> {
    private final int originalPageOffset;
    @NotNull
    private final List<T> data;
    private final int originalPageSize;
    @Nullable
    private final List<Integer> originalIndices;

    public final int getOriginalLastIndex() {
        return this.originalPageSize - 1;
    }

    public final int getOriginalPageOffset() {
        return this.originalPageOffset;
    }

    @NotNull
    public final List<T> getData() {
        return this.data;
    }

    public final int getOriginalPageSize() {
        return this.originalPageSize;
    }

    @Nullable
    public final List<Integer> getOriginalIndices() {
        return this.originalIndices;
    }

    public TransformablePage(int originalPageOffset, @NotNull List<? extends T> data, int originalPageSize, @Nullable List<Integer> originalIndices) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.originalPageOffset = originalPageOffset;
        this.data = data;
        this.originalPageSize = originalPageSize;
        this.originalIndices = originalIndices;
        boolean bl = this.originalIndices == null || this.originalIndices.size() == this.data.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("If originalIndices (size = ");
            List<Integer> list = this.originalIndices;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            String string = stringBuilder.append(list.size()).append(") is provided,").append(" it must be same length as data (size = ").append(this.data.size()).append(')').toString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public TransformablePage(int originalPageOffset, @NotNull List<? extends T> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this(originalPageOffset, data, data.size(), null);
    }

    public final int component1() {
        return this.originalPageOffset;
    }

    @NotNull
    public final List<T> component2() {
        return this.data;
    }

    public final int component3() {
        return this.originalPageSize;
    }

    @Nullable
    public final List<Integer> component4() {
        return this.originalIndices;
    }

    @NotNull
    public final TransformablePage<T> copy(int originalPageOffset, @NotNull List<? extends T> data, int originalPageSize, @Nullable List<Integer> originalIndices) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return new TransformablePage<T>(originalPageOffset, data, originalPageSize, originalIndices);
    }

    public static /* synthetic */ TransformablePage copy$default(TransformablePage transformablePage, int n, List list, int n2, List list2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = transformablePage.originalPageOffset;
        }
        if ((n3 & 2) != 0) {
            list = transformablePage.data;
        }
        if ((n3 & 4) != 0) {
            n2 = transformablePage.originalPageSize;
        }
        if ((n3 & 8) != 0) {
            list2 = transformablePage.originalIndices;
        }
        return transformablePage.copy(n, list, n2, list2);
    }

    @NotNull
    public String toString() {
        return "TransformablePage(originalPageOffset=" + this.originalPageOffset + ", data=" + this.data + ", originalPageSize=" + this.originalPageSize + ", originalIndices=" + this.originalIndices + ")";
    }

    public int hashCode() {
        List<T> list = this.data;
        List<Integer> list2 = this.originalIndices;
        return ((Integer.hashCode(this.originalPageOffset) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.originalPageSize)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TransformablePage)) break block3;
                TransformablePage transformablePage = (TransformablePage)object;
                if (this.originalPageOffset != transformablePage.originalPageOffset || !Intrinsics.areEqual(this.data, transformablePage.data) || this.originalPageSize != transformablePage.originalPageSize || !Intrinsics.areEqual(this.originalIndices, transformablePage.originalIndices)) break block3;
            }
            return true;
        }
        return false;
    }
}

