/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.CombinedLoadStates;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\u00020\u00072\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\tH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"Landroidx/paging/MutableLoadStateCollection;", "", "()V", "mediator", "Landroidx/paging/LoadStates;", "source", "forEach", "", "op", "Lkotlin/Function3;", "Landroidx/paging/LoadType;", "", "Landroidx/paging/LoadState;", "forEach$paging_common", "get", "type", "remote", "set", "combinedLoadStates", "Landroidx/paging/CombinedLoadStates;", "state", "snapshot", "paging-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MutableLoadStateCollection {
    private LoadStates source = LoadStates.Companion.getIDLE();
    private LoadStates mediator;

    @NotNull
    public final CombinedLoadStates snapshot() {
        return new CombinedLoadStates(this.source, this.mediator);
    }

    public final void set(@NotNull CombinedLoadStates combinedLoadStates) {
        Intrinsics.checkNotNullParameter((Object)combinedLoadStates, (String)"combinedLoadStates");
        this.source = combinedLoadStates.getSource();
        this.mediator = combinedLoadStates.getMediator();
    }

    public final boolean set(@NotNull LoadType type, boolean remote, @NotNull LoadState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (remote) {
            LoadStates lastMediator = this.mediator;
            LoadStates loadStates = this.mediator;
            if (loadStates == null) {
                loadStates = LoadStates.Companion.getIDLE();
            }
            this.mediator = loadStates.modifyState$paging_common(type, state);
            bl = Intrinsics.areEqual((Object)this.mediator, (Object)lastMediator) ^ true;
        } else {
            LoadStates lastSource = this.source;
            this.source = this.source.modifyState$paging_common(type, state);
            bl = Intrinsics.areEqual((Object)this.source, (Object)lastSource) ^ true;
        }
        return bl;
    }

    @Nullable
    public final LoadState get(@NotNull LoadType type, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        LoadStates loadStates = remote ? this.mediator : this.source;
        return loadStates != null ? loadStates.get$paging_common(type) : null;
    }

    public final void forEach$paging_common(@NotNull Function3<? super LoadType, ? super Boolean, ? super LoadState, Unit> op) {
        block0: {
            LoadState state;
            int $i$f$forEach$paging_common = 0;
            Intrinsics.checkNotNullParameter(op, (String)"op");
            LoadStates this_$iv = this.source;
            boolean $i$f$forEach = false;
            LoadState loadState = this_$iv.getRefresh();
            LoadType type = LoadType.REFRESH;
            boolean bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            state = this_$iv.getPrepend();
            type = LoadType.PREPEND;
            bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            state = this_$iv.getAppend();
            type = LoadType.APPEND;
            bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            LoadStates loadStates = this.mediator;
            if (loadStates == null) break block0;
            this_$iv = loadStates;
            $i$f$forEach = false;
            state = this_$iv.getRefresh();
            type = LoadType.REFRESH;
            boolean bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
            state = this_$iv.getPrepend();
            type = LoadType.PREPEND;
            bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
            state = this_$iv.getAppend();
            type = LoadType.APPEND;
            bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
        }
    }

    public static final /* synthetic */ void access$setSource$p(MutableLoadStateCollection $this, LoadStates loadStates) {
        $this.source = loadStates;
    }

    public static final /* synthetic */ void access$setMediator$p(MutableLoadStateCollection $this, LoadStates loadStates) {
        $this.mediator = loadStates;
    }
}

