/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.ViewportHint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007B3\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u00c6\u0003JE\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\b\u0002\u0010\n\u001a\u00020\u00042\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Landroidx/paging/TransformablePage;", "T", "", "originalPageOffset", "", "data", "", "(ILjava/util/List;)V", "originalPageOffsets", "", "hintOriginalPageOffset", "hintOriginalIndices", "([ILjava/util/List;ILjava/util/List;)V", "getData", "()Ljava/util/List;", "getHintOriginalIndices", "getHintOriginalPageOffset", "()I", "getOriginalPageOffsets", "()[I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "viewportHintFor", "Landroidx/paging/ViewportHint;", "index", "presentedItemsBefore", "presentedItemsAfter", "originalPageOffsetFirst", "originalPageOffsetLast", "paging-common"})
public final class TransformablePage<T> {
    @NotNull
    private final int[] originalPageOffsets;
    @NotNull
    private final List<T> data;
    private final int hintOriginalPageOffset;
    @Nullable
    private final List<Integer> hintOriginalIndices;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ViewportHint viewportHintFor(int index, int presentedItemsBefore, int presentedItemsAfter, int originalPageOffsetFirst, int originalPageOffsetLast) {
        int n;
        IntRange intRange = this.hintOriginalIndices;
        if (intRange != null && (intRange = CollectionsKt.getIndices((Collection)((Collection)intRange))) != null) {
            if (intRange.contains(index)) {
                n = ((Number)this.hintOriginalIndices.get(index)).intValue();
                return new ViewportHint(this.hintOriginalPageOffset, n, presentedItemsBefore, presentedItemsAfter, originalPageOffsetFirst, originalPageOffsetLast);
            }
        }
        n = index;
        return new ViewportHint(this.hintOriginalPageOffset, n, presentedItemsBefore, presentedItemsAfter, originalPageOffsetFirst, originalPageOffsetLast);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.paging.TransformablePage<*>");
        }
        TransformablePage cfr_ignored_0 = (TransformablePage)object2;
        int[] nArray = this.originalPageOffsets;
        int[] nArray2 = ((TransformablePage)other).originalPageOffsets;
        boolean bl = false;
        if (!Arrays.equals(nArray, nArray2)) {
            return false;
        }
        if (Intrinsics.areEqual(this.data, ((TransformablePage)other).data) ^ true) {
            return false;
        }
        if (this.hintOriginalPageOffset != ((TransformablePage)other).hintOriginalPageOffset) {
            return false;
        }
        return !(Intrinsics.areEqual(this.hintOriginalIndices, ((TransformablePage)other).hintOriginalIndices) ^ true);
    }

    public int hashCode() {
        int[] nArray = this.originalPageOffsets;
        boolean bl = false;
        int result = Arrays.hashCode(nArray);
        result = 31 * result + ((Object)this.data).hashCode();
        result = 31 * result + this.hintOriginalPageOffset;
        List<Integer> list = this.hintOriginalIndices;
        result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
        return result;
    }

    @NotNull
    public final int[] getOriginalPageOffsets() {
        return this.originalPageOffsets;
    }

    @NotNull
    public final List<T> getData() {
        return this.data;
    }

    public final int getHintOriginalPageOffset() {
        return this.hintOriginalPageOffset;
    }

    @Nullable
    public final List<Integer> getHintOriginalIndices() {
        return this.hintOriginalIndices;
    }

    public TransformablePage(@NotNull int[] originalPageOffsets, @NotNull List<? extends T> data, int hintOriginalPageOffset, @Nullable List<Integer> hintOriginalIndices) {
        Intrinsics.checkNotNullParameter((Object)originalPageOffsets, (String)"originalPageOffsets");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.originalPageOffsets = originalPageOffsets;
        this.data = data;
        this.hintOriginalPageOffset = hintOriginalPageOffset;
        this.hintOriginalIndices = hintOriginalIndices;
        int[] nArray = this.originalPageOffsets;
        boolean bl = false;
        int[] nArray2 = nArray;
        boolean bl2 = false;
        boolean bl3 = !(nArray2.length == 0);
        bl = false;
        boolean bl4 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "originalPageOffsets cannot be empty when constructing TransformablePage";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl3 = this.hintOriginalIndices == null || this.hintOriginalIndices.size() == this.data.size();
        bl = false;
        bl4 = false;
        if (!bl3) {
            boolean bl6 = false;
            StringBuilder stringBuilder = new StringBuilder().append("If originalIndices (size = ");
            List<Integer> list = this.hintOriginalIndices;
            Intrinsics.checkNotNull(list);
            String string = stringBuilder.append(list.size()).append(") is provided,").append(" it must be same length as data (size = ").append(this.data.size()).append(')').toString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public TransformablePage(int originalPageOffset, @NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this(new int[]{originalPageOffset}, data, originalPageOffset, null);
    }

    @NotNull
    public final int[] component1() {
        return this.originalPageOffsets;
    }

    @NotNull
    public final List<T> component2() {
        return this.data;
    }

    public final int component3() {
        return this.hintOriginalPageOffset;
    }

    @Nullable
    public final List<Integer> component4() {
        return this.hintOriginalIndices;
    }

    @NotNull
    public final TransformablePage<T> copy(@NotNull int[] originalPageOffsets, @NotNull List<? extends T> data, int hintOriginalPageOffset, @Nullable List<Integer> hintOriginalIndices) {
        Intrinsics.checkNotNullParameter((Object)originalPageOffsets, (String)"originalPageOffsets");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return new TransformablePage<T>(originalPageOffsets, data, hintOriginalPageOffset, hintOriginalIndices);
    }

    public static /* synthetic */ TransformablePage copy$default(TransformablePage transformablePage, int[] nArray, List list, int n, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            nArray = transformablePage.originalPageOffsets;
        }
        if ((n2 & 2) != 0) {
            list = transformablePage.data;
        }
        if ((n2 & 4) != 0) {
            n = transformablePage.hintOriginalPageOffset;
        }
        if ((n2 & 8) != 0) {
            list2 = transformablePage.hintOriginalIndices;
        }
        return transformablePage.copy(nArray, list, n, list2);
    }

    @NotNull
    public String toString() {
        return "TransformablePage(originalPageOffsets=" + Arrays.toString(this.originalPageOffsets) + ", data=" + this.data + ", hintOriginalPageOffset=" + this.hintOriginalPageOffset + ", hintOriginalIndices=" + this.hintOriginalIndices + ")";
    }
}

