/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.CombinedLoadStates;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002J1\u0010\u000f\u001a\u00020\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0015J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0015\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Landroidx/paging/MutableLoadStateCollection;", "", "()V", "append", "Landroidx/paging/LoadState;", "mediator", "Landroidx/paging/LoadStates;", "prepend", "refresh", "source", "computeHelperState", "previousState", "sourceRefreshState", "sourceState", "remoteState", "forEach", "", "op", "Lkotlin/Function3;", "Landroidx/paging/LoadType;", "", "forEach$paging_common", "get", "type", "remote", "set", "combinedLoadStates", "Landroidx/paging/CombinedLoadStates;", "sourceLoadStates", "remoteLoadStates", "state", "snapshot", "terminates", "loadType", "terminates$paging_common", "updateHelperStates", "paging-common"})
public final class MutableLoadStateCollection {
    private LoadState refresh = LoadState.NotLoading.Companion.getIncomplete$paging_common();
    private LoadState prepend = LoadState.NotLoading.Companion.getIncomplete$paging_common();
    private LoadState append = LoadState.NotLoading.Companion.getIncomplete$paging_common();
    private LoadStates source = LoadStates.Companion.getIDLE();
    private LoadStates mediator;

    @NotNull
    public final CombinedLoadStates snapshot() {
        return new CombinedLoadStates(this.refresh, this.prepend, this.append, this.source, this.mediator);
    }

    public final void set(@NotNull CombinedLoadStates combinedLoadStates) {
        Intrinsics.checkNotNullParameter((Object)combinedLoadStates, (String)"combinedLoadStates");
        this.refresh = combinedLoadStates.getRefresh();
        this.prepend = combinedLoadStates.getPrepend();
        this.append = combinedLoadStates.getAppend();
        this.source = combinedLoadStates.getSource();
        this.mediator = combinedLoadStates.getMediator();
    }

    public final void set(@NotNull LoadStates sourceLoadStates, @Nullable LoadStates remoteLoadStates) {
        Intrinsics.checkNotNullParameter((Object)sourceLoadStates, (String)"sourceLoadStates");
        this.source = sourceLoadStates;
        this.mediator = remoteLoadStates;
        this.updateHelperStates();
    }

    public final boolean set(@NotNull LoadType type, boolean remote, @NotNull LoadState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (remote) {
            LoadStates lastMediator = this.mediator;
            LoadStates loadStates = this.mediator;
            if (loadStates == null) {
                loadStates = LoadStates.Companion.getIDLE();
            }
            this.mediator = loadStates.modifyState$paging_common(type, state);
            bl = Intrinsics.areEqual((Object)this.mediator, (Object)lastMediator) ^ true;
        } else {
            LoadStates lastSource = this.source;
            this.source = this.source.modifyState$paging_common(type, state);
            bl = Intrinsics.areEqual((Object)this.source, (Object)lastSource) ^ true;
        }
        boolean didChange = bl;
        this.updateHelperStates();
        return didChange;
    }

    @Nullable
    public final LoadState get(@NotNull LoadType type, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        LoadStates loadStates = remote ? this.mediator : this.source;
        return loadStates != null ? loadStates.get$paging_common(type) : null;
    }

    private final void updateHelperStates() {
        LoadStates loadStates = this.mediator;
        this.refresh = this.computeHelperState(this.refresh, this.source.getRefresh(), this.source.getRefresh(), loadStates != null ? loadStates.getRefresh() : null);
        LoadStates loadStates2 = this.mediator;
        this.prepend = this.computeHelperState(this.prepend, this.source.getRefresh(), this.source.getPrepend(), loadStates2 != null ? loadStates2.getPrepend() : null);
        LoadStates loadStates3 = this.mediator;
        this.append = this.computeHelperState(this.append, this.source.getRefresh(), this.source.getAppend(), loadStates3 != null ? loadStates3.getAppend() : null);
    }

    private final LoadState computeHelperState(LoadState previousState, LoadState sourceRefreshState, LoadState sourceState, LoadState remoteState) {
        if (remoteState == null) {
            return sourceState;
        }
        LoadState loadState = previousState;
        return loadState instanceof LoadState.Loading ? (sourceRefreshState instanceof LoadState.NotLoading && remoteState instanceof LoadState.NotLoading ? remoteState : (remoteState instanceof LoadState.Error ? remoteState : previousState)) : remoteState;
    }

    public final void forEach$paging_common(@NotNull Function3<? super LoadType, ? super Boolean, ? super LoadState, Unit> op) {
        block0: {
            LoadState state;
            int $i$f$forEach$paging_common = 0;
            Intrinsics.checkNotNullParameter(op, (String)"op");
            LoadStates this_$iv = this.source;
            boolean $i$f$forEach = false;
            LoadState loadState = this_$iv.getRefresh();
            LoadType type = LoadType.REFRESH;
            boolean bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            state = this_$iv.getPrepend();
            type = LoadType.PREPEND;
            bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            state = this_$iv.getAppend();
            type = LoadType.APPEND;
            bl = false;
            op.invoke((Object)type, (Object)false, (Object)state);
            LoadStates loadStates = this.mediator;
            if (loadStates == null) break block0;
            this_$iv = loadStates;
            $i$f$forEach = false;
            state = this_$iv.getRefresh();
            type = LoadType.REFRESH;
            boolean bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
            state = this_$iv.getPrepend();
            type = LoadType.PREPEND;
            bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
            state = this_$iv.getAppend();
            type = LoadType.APPEND;
            bl2 = false;
            op.invoke((Object)type, (Object)true, (Object)state);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean terminates$paging_common(@NotNull LoadType loadType) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        LoadState loadState = this.get(loadType, false);
        Intrinsics.checkNotNull((Object)loadState);
        if (!loadState.getEndOfPaginationReached()) return false;
        LoadState loadState2 = this.get(loadType, true);
        if (loadState2 == null) return true;
        if (!loadState2.getEndOfPaginationReached()) return false;
        return true;
    }

    public static final /* synthetic */ void access$setSource$p(MutableLoadStateCollection $this, LoadStates loadStates) {
        $this.source = loadStates;
    }

    public static final /* synthetic */ void access$setMediator$p(MutableLoadStateCollection $this, LoadStates loadStates) {
        $this.mediator = loadStates;
    }
}

