/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.LegacyPageFetcher;
import androidx.paging.NullPaddedList;
import androidx.paging.PagedList;
import androidx.paging.PagingConfig;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u00020\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0001YB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u0015\b\u0012\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000eJ+\u00100\u001a\u0002012\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n2\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0000\u00a2\u0006\u0002\b4J\u0018\u00105\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u00028\u00002\u0006\u00109\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u00107J\u001a\u0010:\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u0000\u0018\u00010;2\u0006\u0010<\u001a\u00020=JD\u0010>\u001a\u0002012\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u00102\u001a\u0002032\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J:\u0010>\u001a\u0002012\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0002J\u0016\u0010C\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\bJ\u0016\u0010D\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\bJ+\u0010E\u001a\u0002012\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n2\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0000\u00a2\u0006\u0002\bFJ\u001e\u0010G\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010H\u001a\u00020\bJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\b\u0010J\u001a\u00020KH\u0016J`\u0010L\u001a\u0002HM\"\u0004\b\u0001\u0010M2\u0006\u00109\u001a\u00020\b2B\b\u0004\u0010N\u001a<\u0012\u001d\u0012\u001b\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(R\u0012\u0004\u0012\u0002HM0OH\u0082\b\u00a2\u0006\u0002\u0010SJ-\u0010T\u001a\u00020\u00102\u0006\u0010U\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bVJ-\u0010W\u001a\u00020\u00102\u0006\u0010U\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bXR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00028\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00028\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u001e\u0010!\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\n0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R\u001e\u0010&\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017R\u001e\u0010(\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0017R\u0016\u0010*\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013R\u0014\u0010,\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0017R\u001e\u0010.\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0017\u00a8\u0006Z"}, d2={"Landroidx/paging/PagedStorage;", "T", "", "Ljava/util/AbstractList;", "Landroidx/paging/LegacyPageFetcher$KeyProvider;", "Landroidx/paging/NullPaddedList;", "()V", "leadingNulls", "", "page", "Landroidx/paging/PagingSource$LoadResult$Page;", "trailingNulls", "(ILandroidx/paging/PagingSource$LoadResult$Page;I)V", "other", "(Landroidx/paging/PagedStorage;)V", "counted", "", "firstLoadedItem", "getFirstLoadedItem$paging_common", "()Ljava/lang/Object;", "value", "lastLoadAroundIndex", "getLastLoadAroundIndex", "()I", "setLastLoadAroundIndex", "(I)V", "lastLoadAroundLocalIndex", "lastLoadedItem", "getLastLoadedItem$paging_common", "middleOfLoadedRange", "getMiddleOfLoadedRange", "nextKey", "getNextKey", "pages", "", "<set-?>", "placeholdersAfter", "getPlaceholdersAfter", "placeholdersBefore", "getPlaceholdersBefore", "positionOffset", "getPositionOffset", "prevKey", "getPrevKey", "size", "getSize", "storageCount", "getStorageCount", "appendPage", "", "callback", "Landroidx/paging/PagedStorage$Callback;", "appendPage$paging_common", "get", "index", "(I)Ljava/lang/Object;", "getFromStorage", "localIndex", "getRefreshKeyInfo", "Landroidx/paging/PagingState;", "config", "Landroidx/paging/PagedList$Config;", "init", "needsTrim", "maxSize", "requiredRemaining", "localPageIndex", "needsTrimFromEnd", "needsTrimFromFront", "prependPage", "prependPage$paging_common", "shouldPreTrimNewPage", "countToBeAdded", "snapshot", "toString", "", "traversePages", "V", "onLastPage", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "pageInternalIndex", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "trimFromEnd", "insertNulls", "trimFromEnd$paging_common", "trimFromFront", "trimFromFront$paging_common", "Callback", "paging-common"})
public final class PagedStorage<T>
extends AbstractList<T>
implements LegacyPageFetcher.KeyProvider<Object>,
NullPaddedList<T> {
    private final List<PagingSource.LoadResult.Page<?, T>> pages;
    private int placeholdersBefore;
    private int placeholdersAfter;
    private int positionOffset;
    private boolean counted;
    private int storageCount;
    private int lastLoadAroundLocalIndex;

    @NotNull
    public final T getFirstLoadedItem$paging_common() {
        return (T)CollectionsKt.first(((PagingSource.LoadResult.Page)CollectionsKt.first(this.pages)).getData());
    }

    @NotNull
    public final T getLastLoadedItem$paging_common() {
        return (T)CollectionsKt.last(((PagingSource.LoadResult.Page)CollectionsKt.last(this.pages)).getData());
    }

    @Override
    public int getPlaceholdersBefore() {
        return this.placeholdersBefore;
    }

    @Override
    public int getPlaceholdersAfter() {
        return this.placeholdersAfter;
    }

    public final int getPositionOffset() {
        return this.positionOffset;
    }

    @Override
    public int getStorageCount() {
        return this.storageCount;
    }

    public final int getLastLoadAroundIndex() {
        return this.getPlaceholdersBefore() + this.lastLoadAroundLocalIndex;
    }

    public final void setLastLoadAroundIndex(int value) {
        this.lastLoadAroundLocalIndex = RangesKt.coerceIn((int)(value - this.getPlaceholdersBefore()), (int)0, (int)(this.getStorageCount() - 1));
    }

    public final int getMiddleOfLoadedRange() {
        return this.getPlaceholdersBefore() + this.getStorageCount() / 2;
    }

    @NotNull
    public final PagedStorage<T> snapshot() {
        return new PagedStorage<T>(this);
    }

    private final void init(int leadingNulls, PagingSource.LoadResult.Page<?, T> page, int trailingNulls, int positionOffset, boolean counted) {
        this.placeholdersBefore = leadingNulls;
        this.pages.clear();
        this.pages.add(page);
        this.placeholdersAfter = trailingNulls;
        this.positionOffset = positionOffset;
        this.storageCount = page.getData().size();
        this.counted = counted;
        this.lastLoadAroundLocalIndex = page.getData().size() / 2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void init(int leadingNulls, @NotNull PagingSource.LoadResult.Page<?, T> page, int trailingNulls, int positionOffset, @NotNull Callback callback, boolean counted) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.init(leadingNulls, page, trailingNulls, positionOffset, counted);
        callback.onInitialized(this.size());
    }

    public static /* synthetic */ void init$default(PagedStorage pagedStorage, int n, PagingSource.LoadResult.Page page, int n2, int n3, Callback callback, boolean bl, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            bl = true;
        }
        pagedStorage.init(n, page, n2, n3, callback, bl);
    }

    @Override
    @Nullable
    public Object getPrevKey() {
        return !this.counted || this.getPlaceholdersBefore() + this.positionOffset > 0 ? ((PagingSource.LoadResult.Page)CollectionsKt.first(this.pages)).getPrevKey() : null;
    }

    @Override
    @Nullable
    public Object getNextKey() {
        return !this.counted || this.getPlaceholdersAfter() > 0 ? ((PagingSource.LoadResult.Page)CollectionsKt.last(this.pages)).getNextKey() : null;
    }

    private final <V> V traversePages(int localIndex, Function2<? super PagingSource.LoadResult.Page<?, T>, ? super Integer, ? extends V> onLastPage) {
        int pageInternalIndex;
        int pageSize;
        int $i$f$traversePages = 0;
        int localPageIndex = 0;
        int localPageCount = this.pages.size();
        for (pageInternalIndex = localIndex; localPageIndex < localPageCount && (pageSize = ((PagingSource.LoadResult.Page)this.pages.get(localPageIndex)).getData().size()) <= pageInternalIndex; pageInternalIndex -= pageSize, ++localPageIndex) {
        }
        return (V)onLastPage.invoke(this.pages.get(localPageIndex), (Object)pageInternalIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public T getFromStorage(int localIndex) {
        void pageInternalIndex;
        int pageInternalIndex$iv;
        int pageSize$iv;
        PagedStorage this_$iv = this;
        boolean $i$f$traversePages = false;
        int localPageIndex$iv = 0;
        int localPageCount$iv = this_$iv.pages.size();
        for (pageInternalIndex$iv = localIndex; localPageIndex$iv < localPageCount$iv && (pageSize$iv = ((PagingSource.LoadResult.Page)this_$iv.pages.get(localPageIndex$iv)).getData().size()) <= pageInternalIndex$iv; pageInternalIndex$iv -= pageSize$iv, ++localPageIndex$iv) {
        }
        int n = pageInternalIndex$iv;
        PagingSource.LoadResult.Page page = (PagingSource.LoadResult.Page)this_$iv.pages.get(localPageIndex$iv);
        boolean bl = false;
        return (T)page.getData().get((int)pageInternalIndex);
    }

    @Nullable
    public final PagingState<?, T> getRefreshKeyInfo(@NotNull PagedList.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.pages.isEmpty()) {
            return null;
        }
        List list = CollectionsKt.toList((Iterable)this.pages);
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<androidx.paging.PagingSource.LoadResult.Page<kotlin.Any, T>>");
        }
        return new PagingState(list, this.getLastLoadAroundIndex(), new PagingConfig(config.pageSize, config.prefetchDistance, config.enablePlaceholders, config.initialLoadSizeHint, config.maxSize, 0, 32, null), this.getPlaceholdersBefore());
    }

    @Override
    @Nullable
    public T get(int index) {
        int localIndex = index - this.getPlaceholdersBefore();
        if (index < 0 || index >= this.size()) {
            throw (Throwable)new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return localIndex < 0 || localIndex >= this.getStorageCount() ? null : (T)this.getFromStorage(localIndex);
    }

    @Override
    public int getSize() {
        return this.getPlaceholdersBefore() + this.getStorageCount() + this.getPlaceholdersAfter();
    }

    private final boolean needsTrim(int maxSize, int requiredRemaining, int localPageIndex) {
        PagingSource.LoadResult.Page<?, T> page = this.pages.get(localPageIndex);
        return this.getStorageCount() > maxSize && this.pages.size() > 2 && this.getStorageCount() - page.getData().size() >= requiredRemaining;
    }

    public final boolean needsTrimFromFront(int maxSize, int requiredRemaining) {
        return this.needsTrim(maxSize, requiredRemaining, 0);
    }

    public final boolean needsTrimFromEnd(int maxSize, int requiredRemaining) {
        return this.needsTrim(maxSize, requiredRemaining, this.pages.size() - 1);
    }

    public final boolean shouldPreTrimNewPage(int maxSize, int requiredRemaining, int countToBeAdded) {
        return this.getStorageCount() + countToBeAdded > maxSize && this.pages.size() > 1 && this.getStorageCount() >= requiredRemaining;
    }

    public final boolean trimFromFront$paging_common(boolean insertNulls, int maxSize, int requiredRemaining, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        int totalRemoved = 0;
        while (this.needsTrimFromFront(maxSize, requiredRemaining)) {
            PagingSource.LoadResult.Page<?, T> page = this.pages.remove(0);
            int removed = page.getData().size();
            totalRemoved += removed;
            this.storageCount = this.getStorageCount() - removed;
        }
        this.lastLoadAroundLocalIndex = RangesKt.coerceAtLeast((int)(this.lastLoadAroundLocalIndex - totalRemoved), (int)0);
        if (totalRemoved > 0) {
            if (insertNulls) {
                int previousLeadingNulls = this.getPlaceholdersBefore();
                this.placeholdersBefore = this.getPlaceholdersBefore() + totalRemoved;
                callback.onPagesSwappedToPlaceholder(previousLeadingNulls, totalRemoved);
            } else {
                this.positionOffset += totalRemoved;
                callback.onPagesRemoved(this.getPlaceholdersBefore(), totalRemoved);
            }
        }
        return totalRemoved > 0;
    }

    public final boolean trimFromEnd$paging_common(boolean insertNulls, int maxSize, int requiredRemaining, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        int totalRemoved = 0;
        while (this.needsTrimFromEnd(maxSize, requiredRemaining)) {
            PagingSource.LoadResult.Page<?, T> page = this.pages.remove(this.pages.size() - 1);
            int removed = page.getData().size();
            totalRemoved += removed;
            this.storageCount = this.getStorageCount() - removed;
        }
        this.lastLoadAroundLocalIndex = RangesKt.coerceAtMost((int)this.lastLoadAroundLocalIndex, (int)(this.getStorageCount() - 1));
        if (totalRemoved > 0) {
            int newEndPosition = this.getPlaceholdersBefore() + this.getStorageCount();
            if (insertNulls) {
                this.placeholdersAfter = this.getPlaceholdersAfter() + totalRemoved;
                callback.onPagesSwappedToPlaceholder(newEndPosition, totalRemoved);
            } else {
                callback.onPagesRemoved(newEndPosition, totalRemoved);
            }
        }
        return totalRemoved > 0;
    }

    public final void prependPage$paging_common(@NotNull PagingSource.LoadResult.Page<?, T> page, @Nullable Callback callback) {
        block2: {
            Intrinsics.checkNotNullParameter(page, (String)"page");
            int count = page.getData().size();
            if (count == 0) {
                return;
            }
            this.pages.add(0, page);
            this.storageCount = this.getStorageCount() + count;
            int n = this.getPlaceholdersBefore();
            boolean bl = false;
            int changedCount = Math.min(n, count);
            int addedCount = count - changedCount;
            if (changedCount != 0) {
                this.placeholdersBefore = this.getPlaceholdersBefore() - changedCount;
            }
            this.positionOffset -= addedCount;
            Callback callback2 = callback;
            if (callback2 == null) break block2;
            callback2.onPagePrepended(this.getPlaceholdersBefore(), changedCount, addedCount);
        }
    }

    public static /* synthetic */ void prependPage$paging_common$default(PagedStorage pagedStorage, PagingSource.LoadResult.Page page, Callback callback, int n, Object object) {
        if ((n & 2) != 0) {
            callback = null;
        }
        pagedStorage.prependPage$paging_common(page, callback);
    }

    public final void appendPage$paging_common(@NotNull PagingSource.LoadResult.Page<?, T> page, @Nullable Callback callback) {
        block2: {
            Intrinsics.checkNotNullParameter(page, (String)"page");
            int count = page.getData().size();
            if (count == 0) {
                return;
            }
            this.pages.add(page);
            this.storageCount = this.getStorageCount() + count;
            int n = this.getPlaceholdersAfter();
            boolean bl = false;
            int changedCount = Math.min(n, count);
            int addedCount = count - changedCount;
            if (changedCount != 0) {
                this.placeholdersAfter = this.getPlaceholdersAfter() - changedCount;
            }
            Callback callback2 = callback;
            if (callback2 == null) break block2;
            callback2.onPageAppended(this.getPlaceholdersBefore() + this.getStorageCount() - count, changedCount, addedCount);
        }
    }

    public static /* synthetic */ void appendPage$paging_common$default(PagedStorage pagedStorage, PagingSource.LoadResult.Page page, Callback callback, int n, Object object) {
        if ((n & 2) != 0) {
            callback = null;
        }
        pagedStorage.appendPage$paging_common(page, callback);
    }

    @Override
    @NotNull
    public String toString() {
        return "leading " + this.getPlaceholdersBefore() + ", storage " + this.getStorageCount() + ", trailing " + this.getPlaceholdersAfter() + ' ' + CollectionsKt.joinToString$default((Iterable)this.pages, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    public PagedStorage() {
        boolean bl = false;
        this.pages = new ArrayList();
        this.counted = true;
    }

    public PagedStorage(int leadingNulls, @NotNull PagingSource.LoadResult.Page<?, T> page, int trailingNulls) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        this();
        super.init(leadingNulls, page, trailingNulls, 0, true);
    }

    private PagedStorage(PagedStorage<T> other) {
        boolean bl = false;
        this.pages = new ArrayList();
        this.counted = true;
        this.pages.addAll((Collection)other.pages);
        this.placeholdersBefore = other.getPlaceholdersBefore();
        this.placeholdersAfter = other.getPlaceholdersAfter();
        this.positionOffset = other.positionOffset;
        this.counted = other.counted;
        this.storageCount = other.getStorageCount();
        this.lastLoadAroundLocalIndex = other.lastLoadAroundLocalIndex;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H&J \u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u000f"}, d2={"Landroidx/paging/PagedStorage$Callback;", "", "onInitialized", "", "count", "", "onPageAppended", "endPosition", "changed", "added", "onPagePrepended", "leadingNulls", "onPagesRemoved", "startOfDrops", "onPagesSwappedToPlaceholder", "paging-common"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static interface Callback {
        public void onInitialized(int var1);

        public void onPagePrepended(int var1, int var2, int var3);

        public void onPageAppended(int var1, int var2, int var3);

        public void onPagesRemoved(int var1, int var2);

        public void onPagesSwappedToPlaceholder(int var1, int var2);
    }
}

