/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.LoadType;
import androidx.paging.WrapperPositionalDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="PositionalDataSource is deprecated and has been replaced by PagingSource", replaceWith=@ReplaceWith(imports={"androidx.paging.PagingSource"}, expression="PagingSource<Int, T>"))
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b'\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005'()*+B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH'J\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u001dH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH'J*\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H!0#J*\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H!0$J6\u0010%\u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u001e\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0&0#J6\u0010%\u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u001e\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0&0$R\u001a\u0010\u0006\u001a\u00020\u0007X\u0090D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0005\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Landroidx/paging/PositionalDataSource;", "T", "", "Landroidx/paging/DataSource;", "", "()V", "isContiguous", "", "isContiguous$paging_common$annotations", "isContiguous$paging_common", "()Z", "getKeyInternal", "item", "getKeyInternal$paging_common", "(Ljava/lang/Object;)Ljava/lang/Integer;", "load", "Landroidx/paging/DataSource$BaseResult;", "params", "Landroidx/paging/DataSource$Params;", "load$paging_common", "(Landroidx/paging/DataSource$Params;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadInitial", "Landroidx/paging/PositionalDataSource$LoadInitialParams;", "loadInitial$paging_common", "(Landroidx/paging/PositionalDataSource$LoadInitialParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Landroidx/paging/PositionalDataSource$LoadInitialCallback;", "loadRange", "Landroidx/paging/PositionalDataSource$LoadRangeParams;", "(Landroidx/paging/PositionalDataSource$LoadRangeParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroidx/paging/PositionalDataSource$LoadRangeCallback;", "map", "V", "function", "Lkotlin/Function1;", "Landroidx/arch/core/util/Function;", "mapByPage", "", "Companion", "LoadInitialCallback", "LoadInitialParams", "LoadRangeCallback", "LoadRangeParams", "paging-common"})
public abstract class PositionalDataSource<T>
extends DataSource<Integer, T> {
    private final boolean isContiguous;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public final Object load$paging_common(@NotNull DataSource.Params<Integer> params, @NotNull Continuation<? super DataSource.BaseResult<T>> $completion) {
        if (params.getType$paging_common() == LoadType.REFRESH) {
            int initialPosition = 0;
            int initialLoadSize = params.getInitialLoadSize();
            if (params.getKey() != null) {
                initialPosition = ((Number)params.getKey()).intValue();
                if (params.getPlaceholdersEnabled()) {
                    int n = initialLoadSize / params.getPageSize();
                    int n2 = 2;
                    int n3 = 0;
                    initialLoadSize = Math.max(n, n2) * params.getPageSize();
                    int idealStart = initialPosition - initialLoadSize / 2;
                    n2 = 0;
                    n3 = idealStart / params.getPageSize() * params.getPageSize();
                    boolean bl = false;
                    initialPosition = Math.max(n2, n3);
                } else {
                    initialPosition -= initialLoadSize / 2;
                }
            }
            LoadInitialParams initParams = new LoadInitialParams(initialPosition, initialLoadSize, params.getPageSize(), params.getPlaceholdersEnabled());
            return this.loadInitial$paging_common(initParams, $completion);
        }
        Integer n = params.getKey();
        Intrinsics.checkNotNull((Object)n);
        int startIndex = ((Number)n).intValue();
        int loadSize = params.getPageSize();
        if (params.getType$paging_common() == LoadType.PREPEND) {
            boolean bl = false;
            loadSize = Math.min(loadSize, startIndex);
            startIndex -= loadSize;
        }
        return this.loadRange(new LoadRangeParams(startIndex, loadSize), $completion);
    }

    @VisibleForTesting
    @Nullable
    public final Object loadInitial$paging_common(@NotNull LoadInitialParams params, @NotNull Continuation<? super DataSource.BaseResult<T>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DataSource.BaseResult<T>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.loadInitial(params, new LoadInitialCallback<T>(cont, this, params){
            final /* synthetic */ CancellableContinuation $cont;
            final /* synthetic */ PositionalDataSource this$0;
            final /* synthetic */ LoadInitialParams $params$inlined;
            {
                this.$cont = $captured_local_variable$1;
                this.this$0 = positionalDataSource;
                this.$params$inlined = loadInitialParams;
            }

            public void onResult(@NotNull List<? extends T> data, int position, int totalCount) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                if (this.this$0.isInvalid()) {
                    Continuation continuation = (Continuation)this.$cont;
                    DataSource.BaseResult<T> baseResult = DataSource.BaseResult.Companion.empty$paging_common();
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    continuation.resumeWith(Result.constructor-impl(baseResult));
                } else {
                    int nextKey = position + data.size();
                    this.resume(this.$params$inlined, new DataSource.BaseResult<T>(data, position == 0 ? null : Integer.valueOf(position), nextKey == totalCount ? null : Integer.valueOf(nextKey), position, totalCount - data.size() - position));
                }
            }

            public void onResult(@NotNull List<? extends T> data, int position) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                if (this.this$0.isInvalid()) {
                    Continuation continuation = (Continuation)this.$cont;
                    DataSource.BaseResult<T> baseResult = DataSource.BaseResult.Companion.empty$paging_common();
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    continuation.resumeWith(Result.constructor-impl(baseResult));
                } else {
                    this.resume(this.$params$inlined, new DataSource.BaseResult<T>(data, position == 0 ? null : Integer.valueOf(position), position + data.size(), position, Integer.MIN_VALUE));
                }
            }

            private final void resume(LoadInitialParams params, DataSource.BaseResult<T> result) {
                if (params.placeholdersEnabled) {
                    result.validateForInitialTiling$paging_common(params.pageSize);
                }
                Continuation continuation = (Continuation)this.$cont;
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl2 = false;
                continuation.resumeWith(Result.constructor-impl(result));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    final /* synthetic */ Object loadRange(LoadRangeParams params, Continuation<? super DataSource.BaseResult<T>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DataSource.BaseResult<T>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.loadRange(params, new LoadRangeCallback<T>(cont, this, params){
            final /* synthetic */ CancellableContinuation $cont;
            final /* synthetic */ PositionalDataSource this$0;
            final /* synthetic */ LoadRangeParams $params$inlined;
            {
                this.$cont = $captured_local_variable$1;
                this.this$0 = positionalDataSource;
                this.$params$inlined = loadRangeParams;
            }

            public void onResult(@NotNull List<? extends T> data) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Integer prevKey = this.$params$inlined.startPosition == 0 ? null : Integer.valueOf(this.$params$inlined.startPosition);
                if (this.this$0.isInvalid()) {
                    Continuation continuation = (Continuation)this.$cont;
                    DataSource.BaseResult<T> baseResult = DataSource.BaseResult.Companion.empty$paging_common();
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    continuation.resumeWith(Result.constructor-impl(baseResult));
                } else {
                    Continuation continuation = (Continuation)this.$cont;
                    DataSource.BaseResult<Value> baseResult = new DataSource.BaseResult<Value>(data, prevKey, this.$params$inlined.startPosition + data.size(), 0, 0, 24, null);
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl(baseResult));
                }
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @WorkerThread
    public abstract void loadInitial(@NotNull LoadInitialParams var1, @NotNull LoadInitialCallback<T> var2);

    @WorkerThread
    public abstract void loadRange(@NotNull LoadRangeParams var1, @NotNull LoadRangeCallback<T> var2);

    public static /* synthetic */ void isContiguous$paging_common$annotations() {
    }

    @Override
    public boolean isContiguous$paging_common() {
        return this.isContiguous;
    }

    @Override
    @NotNull
    public final Integer getKeyInternal$paging_common(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        throw (Throwable)new IllegalStateException("Cannot get key by item in positionalDataSource");
    }

    @NotNull
    public final <V> PositionalDataSource<V> mapByPage(@NotNull Function<List<T>, List<V>> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return new WrapperPositionalDataSource<T, V>(this, function);
    }

    @NotNull
    public final <V> PositionalDataSource<V> mapByPage(@NotNull Function1<? super List<? extends T>, ? extends List<? extends V>> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.mapByPage(new Function<List<? extends T>, List<? extends V>>(function){
            final /* synthetic */ Function1 $function;

            public final List<V> apply(List<? extends T> it) {
                List<? extends T> list = it;
                Intrinsics.checkNotNullExpressionValue(list, (String)"it");
                return (List)this.$function.invoke(list);
            }
            {
                this.$function = function1;
            }
        });
    }

    @NotNull
    public final <V> PositionalDataSource<V> map(@NotNull Function<T, V> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.mapByPage(new Function<List<? extends T>, List<? extends V>>(function){
            final /* synthetic */ Function $function;

            /*
             * WARNING - void declaration
             */
            public final List<V> apply(List<? extends T> list) {
                void $this$mapTo$iv$iv;
                List<? extends T> list2 = list;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"list");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object object = this.$function.apply((Object)it);
                    collection.add(object);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$function = function;
            }
        });
    }

    @NotNull
    public final <V> PositionalDataSource<V> map(@NotNull Function1<? super T, ? extends V> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.mapByPage(new Function<List<? extends T>, List<? extends V>>(function){
            final /* synthetic */ Function1 $function;

            /*
             * WARNING - void declaration
             */
            public final List<V> apply(List<? extends T> list) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<? extends T> list2 = list;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"list");
                Iterable iterable = list2;
                Function1 transform$iv = this.$function;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
                }
                return (List)destination$iv$iv;
            }
            {
                this.$function = function1;
            }
        });
    }

    public PositionalDataSource() {
        super(DataSource.KeyType.POSITIONAL);
    }

    @JvmStatic
    public static final int computeInitialLoadPosition(@NotNull LoadInitialParams params, int totalCount) {
        return Companion.computeInitialLoadPosition(params, totalCount);
    }

    @JvmStatic
    public static final int computeInitialLoadSize(@NotNull LoadInitialParams params, int initialLoadPosition, int totalCount) {
        return Companion.computeInitialLoadSize(params, initialLoadPosition, totalCount);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/paging/PositionalDataSource$LoadInitialParams;", "", "requestedStartPosition", "", "requestedLoadSize", "pageSize", "placeholdersEnabled", "", "(IIIZ)V", "paging-common"})
    public static class LoadInitialParams {
        @JvmField
        public final int requestedStartPosition;
        @JvmField
        public final int requestedLoadSize;
        @JvmField
        public final int pageSize;
        @JvmField
        public final boolean placeholdersEnabled;

        public LoadInitialParams(int requestedStartPosition, int requestedLoadSize, int pageSize, boolean placeholdersEnabled) {
            this.requestedStartPosition = requestedStartPosition;
            this.requestedLoadSize = requestedLoadSize;
            this.pageSize = pageSize;
            this.placeholdersEnabled = placeholdersEnabled;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/paging/PositionalDataSource$LoadRangeParams;", "", "startPosition", "", "loadSize", "(II)V", "paging-common"})
    public static class LoadRangeParams {
        @JvmField
        public final int startPosition;
        @JvmField
        public final int loadSize;

        public LoadRangeParams(int startPosition, int loadSize) {
            this.startPosition = startPosition;
            this.loadSize = loadSize;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&\u00a8\u0006\u000b"}, d2={"Landroidx/paging/PositionalDataSource$LoadInitialCallback;", "T", "", "()V", "onResult", "", "data", "", "position", "", "totalCount", "paging-common"})
    public static abstract class LoadInitialCallback<T> {
        public abstract void onResult(@NotNull List<? extends T> var1, int var2, int var3);

        public abstract void onResult(@NotNull List<? extends T> var1, int var2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H&\u00a8\u0006\b"}, d2={"Landroidx/paging/PositionalDataSource$LoadRangeCallback;", "T", "", "()V", "onResult", "", "data", "", "paging-common"})
    public static abstract class LoadRangeCallback<T> {
        public abstract void onResult(@NotNull List<? extends T> var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Landroidx/paging/PositionalDataSource$Companion;", "", "()V", "computeInitialLoadPosition", "", "params", "Landroidx/paging/PositionalDataSource$LoadInitialParams;", "totalCount", "computeInitialLoadSize", "initialLoadPosition", "paging-common"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final class Companion {
        @JvmStatic
        public final int computeInitialLoadPosition(@NotNull LoadInitialParams params, int totalCount) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            int position = params.requestedStartPosition;
            int initialLoadSize = params.requestedLoadSize;
            int pageSize = params.pageSize;
            int pageStart = position / pageSize * pageSize;
            int maximumLoadPage = (totalCount - initialLoadSize + pageSize - 1) / pageSize * pageSize;
            int n = 0;
            pageStart = Math.min(maximumLoadPage, pageStart);
            n = 0;
            boolean bl = false;
            pageStart = Math.max(n, pageStart);
            return pageStart;
        }

        @JvmStatic
        public final int computeInitialLoadSize(@NotNull LoadInitialParams params, int initialLoadPosition, int totalCount) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            int n = totalCount - initialLoadPosition;
            int n2 = params.requestedLoadSize;
            boolean bl = false;
            return Math.min(n, n2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

