/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging.multicast;

import androidx.paging.multicast.Buffer;
import androidx.paging.multicast.ChannelManager;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016R \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/paging/multicast/BufferImpl;", "T", "Landroidx/paging/multicast/Buffer;", "limit", "", "(I)V", "items", "Ljava/util/ArrayDeque;", "Landroidx/paging/multicast/ChannelManager$Message$Dispatch$Value;", "getItems", "()Ljava/util/ArrayDeque;", "add", "", "item", "paging-common"})
final class BufferImpl<T>
implements Buffer<T> {
    @NotNull
    private final ArrayDeque<ChannelManager.Message.Dispatch.Value<T>> items;
    private final int limit;

    @Override
    @NotNull
    public ArrayDeque<ChannelManager.Message.Dispatch.Value<T>> getItems() {
        return this.items;
    }

    @Override
    public void add(@NotNull ChannelManager.Message.Dispatch.Value<T> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        while (((ArrayDeque)this.getItems()).size() >= this.limit) {
            ((ArrayDeque)this.getItems()).pollFirst();
        }
        ((ArrayDeque)this.getItems()).offerLast(item);
    }

    public BufferImpl(int limit) {
        this.limit = limit;
        this.items = new ArrayDeque(RangesKt.coerceAtMost((int)this.limit, (int)10));
    }

    @Override
    public boolean isEmpty() {
        return Buffer.DefaultImpls.isEmpty(this);
    }
}

