/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.VisibleForTesting;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.MutableLoadStateCollection;
import androidx.paging.PageEvent;
import androidx.paging.TransformablePage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u0011J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/paging/FlattenedPageEventStorage;", "T", "", "()V", "loadStates", "Landroidx/paging/MutableLoadStateCollection;", "pages", "Ljava/util/ArrayDeque;", "Landroidx/paging/TransformablePage;", "placeholdersAfter", "", "placeholdersBefore", "add", "", "event", "Landroidx/paging/PageEvent;", "getAsEvents", "", "handleInsert", "Landroidx/paging/PageEvent$Insert;", "handleLoadStateUpdate", "Landroidx/paging/PageEvent$LoadStateUpdate;", "handlePageDrop", "Landroidx/paging/PageEvent$Drop;", "paging-common"})
@VisibleForTesting(otherwise=2)
public final class FlattenedPageEventStorage<T> {
    private int placeholdersBefore;
    private int placeholdersAfter;
    @NotNull
    private final ArrayDeque<TransformablePage<T>> pages = new ArrayDeque();
    @NotNull
    private final MutableLoadStateCollection loadStates = new MutableLoadStateCollection();

    public final void add(@NotNull PageEvent<T> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        PageEvent<T> pageEvent = event;
        if (pageEvent instanceof PageEvent.Insert) {
            this.handleInsert((PageEvent.Insert)event);
        } else if (pageEvent instanceof PageEvent.Drop) {
            this.handlePageDrop((PageEvent.Drop)event);
        } else if (pageEvent instanceof PageEvent.LoadStateUpdate) {
            this.handleLoadStateUpdate((PageEvent.LoadStateUpdate)event);
        }
    }

    private final void handlePageDrop(PageEvent.Drop<T> event) {
        this.loadStates.set(event.getLoadType(), false, LoadState.NotLoading.Companion.getIncomplete$paging_common());
        LoadType loadType = event.getLoadType();
        int n = WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()];
        switch (n) {
            case 1: {
                this.placeholdersBefore = event.getPlaceholdersRemaining();
                int n2 = event.getPageCount();
                boolean bl = false;
                int n3 = 0;
                n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    int it = n3++;
                    boolean bl2 = false;
                    this.pages.removeFirst();
                }
                break;
            }
            case 2: {
                this.placeholdersAfter = event.getPlaceholdersRemaining();
                int n5 = event.getPageCount();
                boolean bl = false;
                int n6 = 0;
                n6 = 0;
                int n7 = n5;
                while (n6 < n7) {
                    int it = n6++;
                    boolean bl3 = false;
                    this.pages.removeLast();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Page drop type must be prepend or append");
            }
        }
    }

    private final void handleInsert(PageEvent.Insert<T> event) {
        this.loadStates.set(event.getCombinedLoadStates());
        LoadType loadType = event.getLoadType();
        int n = WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()];
        switch (n) {
            case 3: {
                this.pages.clear();
                this.placeholdersAfter = event.getPlaceholdersAfter();
                this.placeholdersBefore = event.getPlaceholdersBefore();
                this.pages.addAll((Collection)event.getPages());
                break;
            }
            case 1: {
                this.placeholdersBefore = event.getPlaceholdersBefore();
                Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)(event.getPages().size() - 1), (int)0);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    this.pages.addFirst(event.getPages().get(it));
                }
                break;
            }
            case 2: {
                this.placeholdersAfter = event.getPlaceholdersAfter();
                this.pages.addAll((Collection)event.getPages());
            }
        }
    }

    private final void handleLoadStateUpdate(PageEvent.LoadStateUpdate<T> event) {
        this.loadStates.set(event.getLoadType(), event.getFromMediator(), event.getLoadState());
    }

    @NotNull
    public final List<PageEvent<T>> getAsEvents() {
        boolean bl = false;
        List events = new ArrayList();
        Collection collection = this.pages;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            events.add(PageEvent.Insert.Companion.Refresh(CollectionsKt.toList((Iterable)this.pages), this.placeholdersBefore, this.placeholdersAfter, this.loadStates.snapshot()));
        } else {
            boolean fromMediator;
            LoadState state;
            LoadState state$iv;
            MutableLoadStateCollection this_$iv = this.loadStates;
            boolean $i$f$forEach$paging_common = false;
            LoadStates this_$iv$iv = MutableLoadStateCollection.access$getSource$p(this_$iv);
            boolean $i$f$forEach = false;
            LoadState loadState = this_$iv$iv.getRefresh();
            Object type$iv = LoadType.REFRESH;
            boolean bl3 = false;
            void var9_13 = state$iv;
            boolean bl4 = false;
            LoadType type = type$iv;
            boolean bl5 = false;
            if (PageEvent.LoadStateUpdate.Companion.canDispatchWithoutInsert$paging_common(state, fromMediator)) {
                events.add(new PageEvent.LoadStateUpdate(type, fromMediator, state));
            }
            state$iv = this_$iv$iv.getPrepend();
            type$iv = LoadType.PREPEND;
            bl3 = false;
            state = state$iv;
            fromMediator = false;
            type = type$iv;
            bl5 = false;
            if (PageEvent.LoadStateUpdate.Companion.canDispatchWithoutInsert$paging_common(state, fromMediator)) {
                events.add(new PageEvent.LoadStateUpdate(type, fromMediator, state));
            }
            state$iv = this_$iv$iv.getAppend();
            type$iv = LoadType.APPEND;
            bl3 = false;
            state = state$iv;
            fromMediator = false;
            type = type$iv;
            bl5 = false;
            if (PageEvent.LoadStateUpdate.Companion.canDispatchWithoutInsert$paging_common(state, fromMediator)) {
                events.add(new PageEvent.LoadStateUpdate(type, fromMediator, state));
            }
            LoadStates loadStates = MutableLoadStateCollection.access$getMediator$p(this_$iv);
            if (loadStates != null) {
                LoadState state$iv2;
                LoadStates this_$iv$iv2 = loadStates;
                boolean $i$f$forEach2 = false;
                type$iv = this_$iv$iv2.getRefresh();
                LoadType type$iv2 = LoadType.REFRESH;
                boolean bl6 = false;
                state = state$iv2;
                fromMediator = true;
                type = type$iv2;
                bl5 = false;
                if (PageEvent.LoadStateUpdate.Companion.canDispatchWithoutInsert$paging_common(state, fromMediator)) {
                    events.add(new PageEvent.LoadStateUpdate(type, fromMediator, state));
                }
                state$iv2 = this_$iv$iv2.getPrepend();
                type$iv2 = LoadType.PREPEND;
                bl6 = false;
                state = state$iv2;
                fromMediator = true;
                type = type$iv2;
                bl5 = false;
                if (PageEvent.LoadStateUpdate.Companion.canDispatchWithoutInsert$paging_common(state, fromMediator)) {
                    events.add(new PageEvent.LoadStateUpdate(type, fromMediator, state));
                }
                state$iv2 = this_$iv$iv2.getAppend();
                type$iv2 = LoadType.APPEND;
                bl6 = false;
                state = state$iv2;
                fromMediator = true;
                type = type$iv2;
                bl5 = false;
                if (PageEvent.LoadStateUpdate.Companion.canDispatchWithoutInsert$paging_common(state, fromMediator)) {
                    events.add(new PageEvent.LoadStateUpdate(type, fromMediator, state));
                }
            }
        }
        return events;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            nArray[LoadType.PREPEND.ordinal()] = 1;
            nArray[LoadType.APPEND.ordinal()] = 2;
            nArray[LoadType.REFRESH.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

