/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.IntRange;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bBA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/paging/PagingConfig;", "", "pageSize", "", "prefetchDistance", "enablePlaceholders", "", "initialLoadSize", "maxSize", "jumpThreshold", "(IIZIII)V", "Companion", "paging-common"})
public final class PagingConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int pageSize;
    @JvmField
    public final int prefetchDistance;
    @JvmField
    public final boolean enablePlaceholders;
    @JvmField
    public final int initialLoadSize;
    @JvmField
    public final int maxSize;
    @JvmField
    public final int jumpThreshold;
    public static final int MAX_SIZE_UNBOUNDED = Integer.MAX_VALUE;
    public static final int DEFAULT_INITIAL_PAGE_MULTIPLIER = 3;

    @JvmOverloads
    public PagingConfig(int pageSize, @IntRange(from=0L) int prefetchDistance, boolean enablePlaceholders, @IntRange(from=1L) int initialLoadSize, @IntRange(from=2L) int maxSize, int jumpThreshold) {
        this.pageSize = pageSize;
        this.prefetchDistance = prefetchDistance;
        this.enablePlaceholders = enablePlaceholders;
        this.initialLoadSize = initialLoadSize;
        this.maxSize = maxSize;
        this.jumpThreshold = jumpThreshold;
        if (!this.enablePlaceholders && this.prefetchDistance == 0) {
            throw new IllegalArgumentException("Placeholders and prefetch are the only ways to trigger loading of more data in PagingData, so either placeholders must be enabled, or prefetch distance must be > 0.");
        }
        if (this.maxSize != Integer.MAX_VALUE && this.maxSize < this.pageSize + this.prefetchDistance * 2) {
            throw new IllegalArgumentException("Maximum size must be at least pageSize + 2*prefetchDist, pageSize=" + this.pageSize + ", prefetchDist=" + this.prefetchDistance + ", maxSize=" + this.maxSize);
        }
        boolean bl = this.jumpThreshold == Integer.MIN_VALUE || this.jumpThreshold > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "jumpThreshold must be positive to enable jumps or COUNT_UNDEFINED to disable jumping.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PagingConfig(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 2) != 0) {
            n2 = n;
        }
        if ((n6 & 4) != 0) {
            bl = true;
        }
        if ((n6 & 8) != 0) {
            n3 = n * 3;
        }
        if ((n6 & 0x10) != 0) {
            n4 = Integer.MAX_VALUE;
        }
        if ((n6 & 0x20) != 0) {
            n5 = Integer.MIN_VALUE;
        }
        this(n, n2, bl, n3, n4, n5);
    }

    @JvmOverloads
    public PagingConfig(int pageSize, @IntRange(from=0L) int prefetchDistance, boolean enablePlaceholders, @IntRange(from=1L) int initialLoadSize, @IntRange(from=2L) int maxSize) {
        this(pageSize, prefetchDistance, enablePlaceholders, initialLoadSize, maxSize, 0, 32, null);
    }

    @JvmOverloads
    public PagingConfig(int pageSize, @IntRange(from=0L) int prefetchDistance, boolean enablePlaceholders, @IntRange(from=1L) int initialLoadSize) {
        this(pageSize, prefetchDistance, enablePlaceholders, initialLoadSize, 0, 0, 48, null);
    }

    @JvmOverloads
    public PagingConfig(int pageSize, @IntRange(from=0L) int prefetchDistance, boolean enablePlaceholders) {
        this(pageSize, prefetchDistance, enablePlaceholders, 0, 0, 0, 56, null);
    }

    @JvmOverloads
    public PagingConfig(int pageSize, @IntRange(from=0L) int prefetchDistance) {
        this(pageSize, prefetchDistance, false, 0, 0, 0, 60, null);
    }

    @JvmOverloads
    public PagingConfig(int pageSize) {
        this(pageSize, 0, false, 0, 0, 0, 62, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Landroidx/paging/PagingConfig$Companion;", "", "()V", "DEFAULT_INITIAL_PAGE_MULTIPLIER", "", "MAX_SIZE_UNBOUNDED", "getMAX_SIZE_UNBOUNDED$annotations", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getMAX_SIZE_UNBOUNDED$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

