/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.paging.CombinedLoadStates;
import androidx.paging.DifferCallback;
import androidx.paging.ItemSnapshotList;
import androidx.paging.LoadState;
import androidx.paging.LoadType;
import androidx.paging.MutableLoadStateCollection;
import androidx.paging.NullPaddedList;
import androidx.paging.PageEvent;
import androidx.paging.PagePresenter;
import androidx.paging.PagingData;
import androidx.paging.PagingDataDiffer;
import androidx.paging.SingleRunner;
import androidx.paging.TransformablePage;
import androidx.paging.UiReceiver;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000*\u0001\u001e\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010%\u001a\u00020\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\u0019J\u001f\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\nH\u0002J\u001a\u0010-\u001a\u0004\u0018\u00018\u00002\b\b\u0001\u0010.\u001a\u00020\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010/J\u0017\u00100\u001a\u0004\u0018\u00018\u00002\b\b\u0001\u0010.\u001a\u00020\u0010\u00a2\u0006\u0002\u0010/J\b\u00101\u001a\u00020\u0012H\u0016JM\u00102\u001a\u0004\u0018\u00010\u00102\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000042\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u00106\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001a08H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u001aJ\u001a\u0010;\u001a\u00020\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\u0019J\u0006\u0010<\u001a\u00020\u001aJ\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Landroidx/paging/PagingDataDiffer;", "T", "", "differCallback", "Landroidx/paging/DifferCallback;", "mainDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Landroidx/paging/DifferCallback;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_combinedLoadState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Landroidx/paging/CombinedLoadStates;", "collectFromRunner", "Landroidx/paging/SingleRunner;", "combinedLoadStates", "Landroidx/paging/MutableLoadStateCollection;", "lastAccessedIndex", "", "lastAccessedIndexUnfulfilled", "", "loadStateFlow", "Lkotlinx/coroutines/flow/Flow;", "getLoadStateFlow", "()Lkotlinx/coroutines/flow/Flow;", "loadStateListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function1;", "", "presenter", "Landroidx/paging/PagePresenter;", "processPageEventCallback", "androidx/paging/PagingDataDiffer$processPageEventCallback$1", "Landroidx/paging/PagingDataDiffer$processPageEventCallback$1;", "receiver", "Landroidx/paging/UiReceiver;", "size", "getSize", "()I", "addLoadStateListener", "listener", "collectFrom", "pagingData", "Landroidx/paging/PagingData;", "(Landroidx/paging/PagingData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispatchLoadStates", "states", "get", "index", "(I)Ljava/lang/Object;", "peek", "postEvents", "presentNewList", "previousList", "Landroidx/paging/NullPaddedList;", "newList", "newCombinedLoadStates", "onListPresentable", "Lkotlin/Function0;", "(Landroidx/paging/NullPaddedList;Landroidx/paging/NullPaddedList;Landroidx/paging/CombinedLoadStates;ILkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refresh", "removeLoadStateListener", "retry", "snapshot", "Landroidx/paging/ItemSnapshotList;", "paging-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class PagingDataDiffer<T> {
    @NotNull
    private final DifferCallback differCallback;
    @NotNull
    private final CoroutineDispatcher mainDispatcher;
    @NotNull
    private PagePresenter<T> presenter;
    @Nullable
    private UiReceiver receiver;
    @NotNull
    private final MutableLoadStateCollection combinedLoadStates;
    @NotNull
    private final CopyOnWriteArrayList<Function1<CombinedLoadStates, Unit>> loadStateListeners;
    @NotNull
    private final SingleRunner collectFromRunner;
    private volatile boolean lastAccessedIndexUnfulfilled;
    private volatile int lastAccessedIndex;
    @NotNull
    private final processPageEventCallback.1 processPageEventCallback;
    @NotNull
    private final MutableStateFlow<CombinedLoadStates> _combinedLoadState;

    public PagingDataDiffer(@NotNull DifferCallback differCallback, @NotNull CoroutineDispatcher mainDispatcher) {
        Intrinsics.checkNotNullParameter((Object)differCallback, (String)"differCallback");
        Intrinsics.checkNotNullParameter((Object)mainDispatcher, (String)"mainDispatcher");
        this.differCallback = differCallback;
        this.mainDispatcher = mainDispatcher;
        this.presenter = PagePresenter.Companion.initial$paging_common();
        this.combinedLoadStates = new MutableLoadStateCollection();
        this.loadStateListeners = new CopyOnWriteArrayList();
        this.collectFromRunner = new SingleRunner(false, 1, null);
        this.processPageEventCallback = new PagePresenter.ProcessPageEventCallback(this){
            final /* synthetic */ PagingDataDiffer<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onChanged(int position, int count) {
                PagingDataDiffer.access$getDifferCallback$p(this.this$0).onChanged(position, count);
            }

            public void onInserted(int position, int count) {
                PagingDataDiffer.access$getDifferCallback$p(this.this$0).onInserted(position, count);
            }

            public void onRemoved(int position, int count) {
                PagingDataDiffer.access$getDifferCallback$p(this.this$0).onRemoved(position, count);
            }

            public void onStateUpdate(@NotNull LoadType loadType, boolean fromMediator, @NotNull LoadState loadState) {
                Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
                Intrinsics.checkNotNullParameter((Object)loadState, (String)"loadState");
                LoadState currentLoadState = PagingDataDiffer.access$getCombinedLoadStates$p(this.this$0).get(loadType, fromMediator);
                if (Intrinsics.areEqual((Object)currentLoadState, (Object)loadState)) {
                    return;
                }
                PagingDataDiffer.access$getCombinedLoadStates$p(this.this$0).set(loadType, fromMediator, loadState);
                CombinedLoadStates newLoadStates = PagingDataDiffer.access$getCombinedLoadStates$p(this.this$0).snapshot();
                Iterable $this$forEach$iv = PagingDataDiffer.access$getLoadStateListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)newLoadStates);
                }
            }
        };
        this._combinedLoadState = StateFlowKt.MutableStateFlow((Object)this.combinedLoadStates.snapshot());
        this.addLoadStateListener((Function1<CombinedLoadStates, Unit>)((Function1)new Function1<CombinedLoadStates, Unit>(){

            public final void invoke(@NotNull CombinedLoadStates it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                _combinedLoadState.setValue((Object)it);
            }
        }));
    }

    public /* synthetic */ PagingDataDiffer(DifferCallback differCallback, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineDispatcher = (CoroutineDispatcher)Dispatchers.INSTANCE.getMain();
        }
        this(differCallback, coroutineDispatcher);
    }

    private final void dispatchLoadStates(CombinedLoadStates states) {
        if (Intrinsics.areEqual((Object)this.combinedLoadStates.snapshot(), (Object)states)) {
            return;
        }
        this.combinedLoadStates.set(states);
        Iterable $this$forEach$iv = this.loadStateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)states);
        }
    }

    @Nullable
    public abstract Object presentNewList(@NotNull NullPaddedList<T> var1, @NotNull NullPaddedList<T> var2, @NotNull CombinedLoadStates var3, int var4, @NotNull Function0<Unit> var5, @NotNull Continuation<? super Integer> var6);

    public boolean postEvents() {
        return false;
    }

    @Nullable
    public final Object collectFrom(@NotNull PagingData<T> pagingData, @NotNull Continuation<? super Unit> $completion) {
        Object object = SingleRunner.runInIsolation$default(this.collectFromRunner, 0, (Function1)new Function1<Continuation<? super Unit>, Object>(this, pagingData, null){
            int label;
            final /* synthetic */ PagingDataDiffer<T> this$0;
            final /* synthetic */ PagingData<T> $pagingData;
            {
                this.this$0 = $receiver;
                this.$pagingData = $pagingData;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        PagingDataDiffer.access$setReceiver$p(this.this$0, this.$pagingData.getReceiver$paging_common());
                        Flow<PageEvent<T>> flow2 = this.$pagingData.getFlow$paging_common();
                        PagingDataDiffer<T> pagingDataDiffer = this.this$0;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<PageEvent<T>>(pagingDataDiffer){
                            final /* synthetic */ PagingDataDiffer this$0;
                            {
                                this.this$0 = pagingDataDiffer;
                            }

                            @Nullable
                            public Object emit(Object value, @NotNull Continuation continuation) {
                                Continuation continuation2 = continuation;
                                PageEvent event = (PageEvent)value;
                                boolean bl = false;
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)PagingDataDiffer.access$getMainDispatcher$p(this.this$0)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(event, this.this$0, null){
                                    Object L$0;
                                    Object L$1;
                                    int label;
                                    final /* synthetic */ PageEvent<T> $event;
                                    final /* synthetic */ PagingDataDiffer<T> this$0;
                                    {
                                        this.$event = $event;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                if (!(this.$event instanceof PageEvent.Insert) || ((PageEvent.Insert)this.$event).getLoadType() != LoadType.REFRESH) break;
                                                PagingDataDiffer.access$setLastAccessedIndexUnfulfilled$p(this.this$0, false);
                                                newPresenter = new PagePresenter<T>((PageEvent.Insert)this.$event);
                                                onListPresentableCalled = new Ref.BooleanRef();
                                                this.L$0 = newPresenter;
                                                this.L$1 = onListPresentableCalled;
                                                this.label = 1;
                                                v0 = this.this$0.presentNewList(PagingDataDiffer.access$getPresenter$p(this.this$0), newPresenter, ((PageEvent.Insert)this.$event).getCombinedLoadStates(), PagingDataDiffer.access$getLastAccessedIndex$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, newPresenter, onListPresentableCalled){
                                                    final /* synthetic */ PagingDataDiffer<T> this$0;
                                                    final /* synthetic */ PagePresenter<T> $newPresenter;
                                                    final /* synthetic */ Ref.BooleanRef $onListPresentableCalled;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$newPresenter = $newPresenter;
                                                        this.$onListPresentableCalled = $onListPresentableCalled;
                                                        super(0);
                                                    }

                                                    public final void invoke() {
                                                        PagingDataDiffer.access$setPresenter$p(this.this$0, this.$newPresenter);
                                                        this.$onListPresentableCalled.element = true;
                                                    }
                                                }), (Continuation<Integer>)((Continuation)this));
                                                if (v0 == var12_2) {
                                                    return var12_2;
                                                }
                                                ** GOTO lbl21
                                            }
                                            case 1: {
                                                onListPresentableCalled = (Ref.BooleanRef)this.L$1;
                                                newPresenter = (PagePresenter<T>)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl21:
                                                // 2 sources

                                                transformedLastAccessedIndex = (Integer)v0;
                                                var5_9 = onListPresentableCalled.element;
                                                var6_13 = false;
                                                var7_16 = false;
                                                if (!var5_9) {
                                                    $i$a$-check-PagingDataDiffer$collectFrom$2$1$1$1 = false;
                                                    var7_17 = "Missing call to onListPresentable after new list was presented. If you are seeing this exception, it is generally an indication of an issue with Paging. Please file a bug so we can fix it at: https://issuetracker.google.com/issues/new?component=413106";
                                                    throw (Throwable)new IllegalStateException(var7_17.toString());
                                                }
                                                PagingDataDiffer.access$dispatchLoadStates(this.this$0, ((PageEvent.Insert)this.$event).getCombinedLoadStates());
                                                if (transformedLastAccessedIndex == null) {
                                                    var5_10 = PagingDataDiffer.access$getReceiver$p(this.this$0);
                                                    if (var5_10 != null) {
                                                        var5_10.accessHint(newPresenter.initializeHint());
                                                    }
                                                } else {
                                                    PagingDataDiffer.access$setLastAccessedIndex$p(this.this$0, transformedLastAccessedIndex);
                                                    var5_11 = PagingDataDiffer.access$getReceiver$p(this.this$0);
                                                    if (var5_11 != null) {
                                                        var5_11.accessHint(newPresenter.accessHintForPresenterIndex(transformedLastAccessedIndex));
                                                    }
                                                }
                                                ** GOTO lbl79
                                            }
                                        }
                                        if (this.this$0.postEvents()) {
                                            this.label = 2;
                                            v1 = YieldKt.yield((Continuation)((Continuation)this));
                                            if (v1 == var12_2) {
                                                return var12_2;
                                            }
                                        }
                                        ** GOTO lbl49
                                        {
                                            case 2: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl49:
                                                // 2 sources

                                                PagingDataDiffer.access$getPresenter$p(this.this$0).processEvent(this.$event, PagingDataDiffer.access$getProcessPageEventCallback$p(this.this$0));
                                                if (this.$event instanceof PageEvent.Drop) {
                                                    PagingDataDiffer.access$setLastAccessedIndexUnfulfilled$p(this.this$0, false);
                                                }
                                                if (!(this.$event instanceof PageEvent.Insert)) ** GOTO lbl79
                                                prependDone = ((PageEvent.Insert)this.$event).getCombinedLoadStates().getPrepend().getEndOfPaginationReached();
                                                appendDone = ((PageEvent.Insert)this.$event).getCombinedLoadStates().getAppend().getEndOfPaginationReached();
                                                canContinueLoading = !(((PageEvent.Insert)this.$event).getLoadType() == LoadType.PREPEND && prependDone != false || ((PageEvent.Insert)this.$event).getLoadType() == LoadType.APPEND && appendDone != false);
                                                $this$all$iv = ((PageEvent.Insert)this.$event).getPages();
                                                $i$f$all = false;
                                                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl61
                                                v2 = true;
                                                ** GOTO lbl68
lbl61:
                                                // 2 sources

                                                for (T element$iv : $this$all$iv) {
                                                    it = (TransformablePage)element$iv;
                                                    $i$a$-all-PagingDataDiffer$collectFrom$2$1$1$emptyInsert$1 = false;
                                                    if (Boxing.boxBoolean((boolean)it.getData().isEmpty()).booleanValue()) continue;
                                                    v2 = false;
                                                    ** GOTO lbl68
                                                }
                                                v2 = emptyInsert = true;
lbl68:
                                                // 3 sources

                                                if (!canContinueLoading) {
                                                    PagingDataDiffer.access$setLastAccessedIndexUnfulfilled$p(this.this$0, false);
                                                } else if (PagingDataDiffer.access$getLastAccessedIndexUnfulfilled$p(this.this$0) || emptyInsert) {
                                                    v3 = shouldResendHint = emptyInsert != false || PagingDataDiffer.access$getLastAccessedIndex$p(this.this$0) < PagingDataDiffer.access$getPresenter$p(this.this$0).getPlaceholdersBefore() || PagingDataDiffer.access$getLastAccessedIndex$p(this.this$0) > PagingDataDiffer.access$getPresenter$p(this.this$0).getPlaceholdersBefore() + PagingDataDiffer.access$getPresenter$p(this.this$0).getStorageCount();
                                                    if (shouldResendHint) {
                                                        var7_19 = PagingDataDiffer.access$getReceiver$p(this.this$0);
                                                        if (var7_19 != null) {
                                                            var7_19.accessHint(PagingDataDiffer.access$getPresenter$p(this.this$0).accessHintForPresenterIndex(PagingDataDiffer.access$getLastAccessedIndex$p(this.this$0)));
                                                        }
                                                    } else {
                                                        PagingDataDiffer.access$setLastAccessedIndexUnfulfilled$p(this.this$0, false);
                                                    }
                                                }
lbl79:
                                                // 8 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)continuation);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion, 1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final T get(@IntRange(from=0L) int index) {
        this.lastAccessedIndexUnfulfilled = true;
        this.lastAccessedIndex = index;
        UiReceiver uiReceiver = this.receiver;
        if (uiReceiver != null) {
            uiReceiver.accessHint(this.presenter.accessHintForPresenterIndex(index));
        }
        return this.presenter.get(index);
    }

    @Nullable
    public final T peek(@IntRange(from=0L) int index) {
        return this.presenter.get(index);
    }

    @NotNull
    public final ItemSnapshotList<T> snapshot() {
        return this.presenter.snapshot();
    }

    public final void retry() {
        UiReceiver uiReceiver = this.receiver;
        if (uiReceiver != null) {
            uiReceiver.retry();
        }
    }

    public final void refresh() {
        UiReceiver uiReceiver = this.receiver;
        if (uiReceiver != null) {
            uiReceiver.refresh();
        }
    }

    public final int getSize() {
        return this.presenter.getSize();
    }

    @NotNull
    public final Flow<CombinedLoadStates> getLoadStateFlow() {
        return (Flow)this._combinedLoadState;
    }

    public final void addLoadStateListener(@NotNull Function1<? super CombinedLoadStates, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.loadStateListeners.add(listener);
        listener.invoke((Object)this.combinedLoadStates.snapshot());
    }

    public final void removeLoadStateListener(@NotNull Function1<? super CombinedLoadStates, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.loadStateListeners.remove(listener);
    }

    public static final /* synthetic */ void access$setReceiver$p(PagingDataDiffer $this, UiReceiver uiReceiver) {
        $this.receiver = uiReceiver;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getMainDispatcher$p(PagingDataDiffer $this) {
        return $this.mainDispatcher;
    }

    public static final /* synthetic */ void access$setLastAccessedIndexUnfulfilled$p(PagingDataDiffer $this, boolean bl) {
        $this.lastAccessedIndexUnfulfilled = bl;
    }

    public static final /* synthetic */ PagePresenter access$getPresenter$p(PagingDataDiffer $this) {
        return $this.presenter;
    }

    public static final /* synthetic */ int access$getLastAccessedIndex$p(PagingDataDiffer $this) {
        return $this.lastAccessedIndex;
    }

    public static final /* synthetic */ void access$setPresenter$p(PagingDataDiffer $this, PagePresenter pagePresenter) {
        $this.presenter = pagePresenter;
    }

    public static final /* synthetic */ void access$dispatchLoadStates(PagingDataDiffer $this, CombinedLoadStates states) {
        $this.dispatchLoadStates(states);
    }

    public static final /* synthetic */ UiReceiver access$getReceiver$p(PagingDataDiffer $this) {
        return $this.receiver;
    }

    public static final /* synthetic */ void access$setLastAccessedIndex$p(PagingDataDiffer $this, int n) {
        $this.lastAccessedIndex = n;
    }

    public static final /* synthetic */ processPageEventCallback.1 access$getProcessPageEventCallback$p(PagingDataDiffer $this) {
        return $this.processPageEventCallback;
    }

    public static final /* synthetic */ boolean access$getLastAccessedIndexUnfulfilled$p(PagingDataDiffer $this) {
        return $this.lastAccessedIndexUnfulfilled;
    }

    public static final /* synthetic */ DifferCallback access$getDifferCallback$p(PagingDataDiffer $this) {
        return $this.differCallback;
    }

    public static final /* synthetic */ MutableLoadStateCollection access$getCombinedLoadStates$p(PagingDataDiffer $this) {
        return $this.combinedLoadStates;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getLoadStateListeners$p(PagingDataDiffer $this) {
        return $this.loadStateListeners;
    }
}

