/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.VisibleForTesting;
import androidx.paging.LoadType;
import androidx.paging.ViewportHint;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\u0015\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Landroidx/paging/GenerationalViewportHint;", "", "generationId", "", "hint", "Landroidx/paging/ViewportHint;", "(ILandroidx/paging/ViewportHint;)V", "getGenerationId", "()I", "getHint", "()Landroidx/paging/ViewportHint;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "presentedItemsBeyondAnchor", "loadType", "Landroidx/paging/LoadType;", "presentedItemsBeyondAnchor$paging_common", "toString", "", "paging-common"})
@VisibleForTesting
public final class GenerationalViewportHint {
    private final int generationId;
    @NotNull
    private final ViewportHint hint;

    public GenerationalViewportHint(int generationId, @NotNull ViewportHint hint) {
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        this.generationId = generationId;
        this.hint = hint;
    }

    public final int getGenerationId() {
        return this.generationId;
    }

    @NotNull
    public final ViewportHint getHint() {
        return this.hint;
    }

    public final int presentedItemsBeyondAnchor$paging_common(@NotNull LoadType loadType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        LoadType loadType2 = loadType;
        int n2 = WhenMappings.$EnumSwitchMapping$0[loadType2.ordinal()];
        switch (n2) {
            case 1: {
                throw new IllegalArgumentException("Cannot get presentedItems for loadType: REFRESH");
            }
            case 2: {
                n = this.hint.getPresentedItemsBefore();
                break;
            }
            case 3: {
                n = this.hint.getPresentedItemsAfter();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final int component1() {
        return this.generationId;
    }

    @NotNull
    public final ViewportHint component2() {
        return this.hint;
    }

    @NotNull
    public final GenerationalViewportHint copy(int generationId, @NotNull ViewportHint hint) {
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        return new GenerationalViewportHint(generationId, hint);
    }

    public static /* synthetic */ GenerationalViewportHint copy$default(GenerationalViewportHint generationalViewportHint, int n, ViewportHint viewportHint, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = generationalViewportHint.generationId;
        }
        if ((n2 & 2) != 0) {
            viewportHint = generationalViewportHint.hint;
        }
        return generationalViewportHint.copy(n, viewportHint);
    }

    @NotNull
    public String toString() {
        return "GenerationalViewportHint(generationId=" + this.generationId + ", hint=" + this.hint + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.generationId);
        result = result * 31 + this.hint.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenerationalViewportHint)) {
            return false;
        }
        GenerationalViewportHint generationalViewportHint = (GenerationalViewportHint)other;
        if (this.generationId != generationalViewportHint.generationId) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.hint, (Object)generationalViewportHint.hint);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            nArray[LoadType.REFRESH.ordinal()] = 1;
            nArray[LoadType.PREPEND.ordinal()] = 2;
            nArray[LoadType.APPEND.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

