/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.PagingState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001d\u001a\u001c\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014\u0018\u00010\u001eJ\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0014J\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0007J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\nR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/paging/AccessorState;", "Key", "", "Value", "()V", "blockStates", "", "Landroidx/paging/AccessorState$BlockState;", "[Landroidx/paging/AccessorState$BlockState;", "errors", "Landroidx/paging/LoadState$Error;", "[Landroidx/paging/LoadState$Error;", "pendingRequests", "Lkotlin/collections/ArrayDeque;", "Landroidx/paging/AccessorState$PendingRequest;", "add", "", "loadType", "Landroidx/paging/LoadType;", "pagingState", "Landroidx/paging/PagingState;", "clearErrors", "", "clearPendingRequest", "clearPendingRequests", "computeLoadStates", "Landroidx/paging/LoadStates;", "computeLoadTypeState", "Landroidx/paging/LoadState;", "getPendingBoundary", "Lkotlin/Pair;", "getPendingRefresh", "setBlockState", "state", "setError", "errorState", "BlockState", "PendingRequest", "paging-common"})
final class AccessorState<Key, Value> {
    @NotNull
    private final BlockState[] blockStates;
    @NotNull
    private final LoadState.Error[] errors;
    @NotNull
    private final ArrayDeque<PendingRequest<Key, Value>> pendingRequests;

    public AccessorState() {
        int n;
        int n2 = 0;
        int n3 = LoadType.values().length;
        Object[] objectArray = new BlockState[n3];
        AccessorState accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = BlockState.UNBLOCKED;
        }
        accessorState.blockStates = objectArray;
        n2 = 0;
        n3 = LoadType.values().length;
        objectArray = new LoadState.Error[n3];
        accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = null;
        }
        accessorState.errors = objectArray;
        this.pendingRequests = new ArrayDeque();
    }

    @NotNull
    public final LoadStates computeLoadStates() {
        LoadState loadState = this.computeLoadTypeState(LoadType.REFRESH);
        LoadState loadState2 = this.computeLoadTypeState(LoadType.APPEND);
        LoadState loadState3 = this.computeLoadTypeState(LoadType.PREPEND);
        return new LoadStates(loadState, loadState3, loadState2);
    }

    private final LoadState computeLoadTypeState(LoadType loadType) {
        LoadState loadState;
        boolean hasPending;
        Object it;
        BlockState blockState;
        block10: {
            boolean bl;
            blockState = this.blockStates[loadType.ordinal()];
            Iterable $this$any$iv = (Iterable)this.pendingRequests;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PendingRequest)element$iv;
                    boolean bl2 = false;
                    if (!(((PendingRequest)it).getLoadType() == loadType)) continue;
                    bl = true;
                    break block10;
                }
                bl = hasPending = false;
            }
        }
        if (hasPending && blockState != BlockState.REQUIRES_REFRESH) {
            return LoadState.Loading.INSTANCE;
        }
        Object object = this.errors[loadType.ordinal()];
        if (object != null) {
            LoadState.Error error = object;
            boolean bl = false;
            boolean bl3 = false;
            it = error;
            boolean bl4 = false;
            return (LoadState)it;
        }
        object = blockState;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                LoadType loadType2 = loadType;
                int n2 = WhenMappings.$EnumSwitchMapping$1[loadType2.ordinal()];
                loadState = n2 == 1 ? LoadState.NotLoading.Companion.getIncomplete$paging_common() : LoadState.NotLoading.Companion.getComplete$paging_common();
                break;
            }
            case 2: {
                loadState = LoadState.NotLoading.Companion.getIncomplete$paging_common();
                break;
            }
            case 3: {
                loadState = LoadState.NotLoading.Companion.getIncomplete$paging_common();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadState;
    }

    public final boolean add(@NotNull LoadType loadType, @NotNull PagingState<Key, Value> pagingState) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkNotNullParameter(pagingState, (String)"pagingState");
            Iterable $this$firstOrNull$iv = (Iterable)this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() == loadType)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        PendingRequest existing = v0;
        if (existing != null) {
            existing.setPagingState(pagingState);
            return false;
        }
        BlockState blockState = this.blockStates[loadType.ordinal()];
        if (blockState == BlockState.REQUIRES_REFRESH && loadType != LoadType.REFRESH) {
            this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState));
            return false;
        }
        if (blockState != BlockState.UNBLOCKED && loadType != LoadType.REFRESH) {
            return false;
        }
        if (loadType == LoadType.REFRESH) {
            this.setError(LoadType.REFRESH, null);
        }
        return this.errors[loadType.ordinal()] == null ? this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState)) : false;
    }

    public final void setBlockState(@NotNull LoadType loadType, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.blockStates[loadType.ordinal()] = state;
    }

    @Nullable
    public final PagingState<Key, Value> getPendingRefresh() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() == LoadType.REFRESH)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PendingRequest pendingRequest = v0;
        return pendingRequest == null ? null : pendingRequest.getPagingState();
    }

    @Nullable
    public final Pair<LoadType, PagingState<Key, Value>> getPendingBoundary() {
        Pair pair;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = (Iterable)this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() != LoadType.REFRESH && this.blockStates[it.getLoadType().ordinal()] == BlockState.UNBLOCKED)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PendingRequest pendingRequest = v0;
        if (pendingRequest == null) {
            pair = null;
        } else {
            PendingRequest pendingRequest2 = pendingRequest;
            boolean bl = false;
            boolean bl2 = false;
            PendingRequest it = pendingRequest2;
            boolean bl3 = false;
            pair = TuplesKt.to((Object)((Object)it.getLoadType()), it.getPagingState());
        }
        return pair;
    }

    public final void clearPendingRequests() {
        this.pendingRequests.clear();
    }

    public final void clearPendingRequest(@NotNull LoadType loadType) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        CollectionsKt.removeAll((List)((List)this.pendingRequests), (Function1)new Function1<PendingRequest<Key, Value>, Boolean>(loadType){
            final /* synthetic */ LoadType $loadType;
            {
                this.$loadType = $loadType;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PendingRequest<Key, Value> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getLoadType() == this.$loadType;
            }
        });
    }

    public final void clearErrors() {
        int n = 0;
        int n2 = this.errors.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                this.errors[i] = null;
            } while (n <= n2);
        }
    }

    public final void setError(@NotNull LoadType loadType, @Nullable LoadState.Error errorState) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        this.errors[loadType.ordinal()] = errorState;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/paging/AccessorState$PendingRequest;", "Key", "", "Value", "loadType", "Landroidx/paging/LoadType;", "pagingState", "Landroidx/paging/PagingState;", "(Landroidx/paging/LoadType;Landroidx/paging/PagingState;)V", "getLoadType", "()Landroidx/paging/LoadType;", "getPagingState", "()Landroidx/paging/PagingState;", "setPagingState", "(Landroidx/paging/PagingState;)V", "paging-common"})
    public static final class PendingRequest<Key, Value> {
        @NotNull
        private final LoadType loadType;
        @NotNull
        private PagingState<Key, Value> pagingState;

        public PendingRequest(@NotNull LoadType loadType, @NotNull PagingState<Key, Value> pagingState) {
            Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkNotNullParameter(pagingState, (String)"pagingState");
            this.loadType = loadType;
            this.pagingState = pagingState;
        }

        @NotNull
        public final LoadType getLoadType() {
            return this.loadType;
        }

        @NotNull
        public final PagingState<Key, Value> getPagingState() {
            return this.pagingState;
        }

        public final void setPagingState(@NotNull PagingState<Key, Value> pagingState) {
            Intrinsics.checkNotNullParameter(pagingState, (String)"<set-?>");
            this.pagingState = pagingState;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/paging/AccessorState$BlockState;", "", "(Ljava/lang/String;I)V", "UNBLOCKED", "COMPLETED", "REQUIRES_REFRESH", "paging-common"})
    public static final class BlockState
    extends Enum<BlockState> {
        public static final /* enum */ BlockState UNBLOCKED = new BlockState();
        public static final /* enum */ BlockState COMPLETED = new BlockState();
        public static final /* enum */ BlockState REQUIRES_REFRESH = new BlockState();
        private static final /* synthetic */ BlockState[] $VALUES;

        public static BlockState[] values() {
            return (BlockState[])$VALUES.clone();
        }

        public static BlockState valueOf(String value) {
            return Enum.valueOf(BlockState.class, value);
        }

        static {
            $VALUES = blockStateArray = new BlockState[]{BlockState.UNBLOCKED, BlockState.COMPLETED, BlockState.REQUIRES_REFRESH};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BlockState.values().length];
            nArray[BlockState.COMPLETED.ordinal()] = 1;
            nArray[BlockState.REQUIRES_REFRESH.ordinal()] = 2;
            nArray[BlockState.UNBLOCKED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LoadType.values().length];
            nArray[LoadType.REFRESH.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

