/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.CombinedLoadStates;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001b\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010J*\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rJ\u001a\u0010&\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00132\b\u0010)\u001a\u0004\u0018\u00010\u0013J\u001e\u0010'\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0007J\n\u0010+\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010,\u001a\u00020\u0011H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016\u00a8\u0006-"}, d2={"Landroidx/paging/MutableCombinedLoadStateCollection;", "", "()V", "_stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Landroidx/paging/CombinedLoadStates;", "append", "Landroidx/paging/LoadState;", "flow", "Lkotlinx/coroutines/flow/Flow;", "getFlow", "()Lkotlinx/coroutines/flow/Flow;", "isInitialized", "", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function1;", "", "<set-?>", "Landroidx/paging/LoadStates;", "mediator", "getMediator", "()Landroidx/paging/LoadStates;", "prepend", "refresh", "source", "getSource", "addListener", "listener", "computeHelperState", "previousState", "sourceRefreshState", "sourceState", "remoteState", "get", "type", "Landroidx/paging/LoadType;", "remote", "removeListener", "set", "sourceLoadStates", "remoteLoadStates", "state", "snapshot", "updateHelperStatesAndDispatch", "paging-common"})
public final class MutableCombinedLoadStateCollection {
    private boolean isInitialized;
    @NotNull
    private final CopyOnWriteArrayList<Function1<CombinedLoadStates, Unit>> listeners = new CopyOnWriteArrayList();
    @NotNull
    private LoadState refresh = LoadState.NotLoading.Companion.getIncomplete$paging_common();
    @NotNull
    private LoadState prepend = LoadState.NotLoading.Companion.getIncomplete$paging_common();
    @NotNull
    private LoadState append = LoadState.NotLoading.Companion.getIncomplete$paging_common();
    @NotNull
    private LoadStates source = LoadStates.Companion.getIDLE();
    @Nullable
    private LoadStates mediator;
    @NotNull
    private final MutableStateFlow<CombinedLoadStates> _stateFlow = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final Flow<CombinedLoadStates> flow = FlowKt.filterNotNull((Flow)((Flow)this._stateFlow));

    @NotNull
    public final LoadStates getSource() {
        return this.source;
    }

    @Nullable
    public final LoadStates getMediator() {
        return this.mediator;
    }

    @NotNull
    public final Flow<CombinedLoadStates> getFlow() {
        return this.flow;
    }

    public final void set(@NotNull LoadStates sourceLoadStates, @Nullable LoadStates remoteLoadStates) {
        Intrinsics.checkNotNullParameter((Object)sourceLoadStates, (String)"sourceLoadStates");
        this.isInitialized = true;
        this.source = sourceLoadStates;
        this.mediator = remoteLoadStates;
        this.updateHelperStatesAndDispatch();
    }

    public final boolean set(@NotNull LoadType type, boolean remote, @NotNull LoadState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.isInitialized = true;
        if (remote) {
            LoadStates lastMediator = this.mediator;
            LoadStates loadStates = this.mediator;
            if (loadStates == null) {
                loadStates = LoadStates.Companion.getIDLE();
            }
            this.mediator = loadStates.modifyState$paging_common(type, state);
            bl = !Intrinsics.areEqual((Object)this.mediator, (Object)lastMediator);
        } else {
            LoadStates lastSource = this.source;
            this.source = this.source.modifyState$paging_common(type, state);
            bl = !Intrinsics.areEqual((Object)this.source, (Object)lastSource);
        }
        boolean didChange = bl;
        this.updateHelperStatesAndDispatch();
        return didChange;
    }

    @Nullable
    public final LoadState get(@NotNull LoadType type, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        LoadStates loadStates = remote ? this.mediator : this.source;
        return loadStates != null ? loadStates.get$paging_common(type) : null;
    }

    public final void addListener(@NotNull Function1<? super CombinedLoadStates, Unit> listener) {
        block0: {
            CombinedLoadStates combinedLoadStates;
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.listeners.add(listener);
            CombinedLoadStates combinedLoadStates2 = this.snapshot();
            if (combinedLoadStates2 == null) break block0;
            CombinedLoadStates it = combinedLoadStates = combinedLoadStates2;
            boolean bl = false;
            listener.invoke((Object)it);
        }
    }

    public final void removeListener(@NotNull Function1<? super CombinedLoadStates, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.remove(listener);
    }

    private final CombinedLoadStates snapshot() {
        return !this.isInitialized ? null : new CombinedLoadStates(this.refresh, this.prepend, this.append, this.source, this.mediator);
    }

    private final void updateHelperStatesAndDispatch() {
        LoadStates loadStates = this.mediator;
        this.refresh = this.computeHelperState(this.refresh, this.source.getRefresh(), this.source.getRefresh(), loadStates != null ? loadStates.getRefresh() : null);
        LoadStates loadStates2 = this.mediator;
        this.prepend = this.computeHelperState(this.prepend, this.source.getRefresh(), this.source.getPrepend(), loadStates2 != null ? loadStates2.getPrepend() : null);
        LoadStates loadStates3 = this.mediator;
        this.append = this.computeHelperState(this.append, this.source.getRefresh(), this.source.getAppend(), loadStates3 != null ? loadStates3.getAppend() : null);
        CombinedLoadStates snapshot = this.snapshot();
        if (snapshot != null) {
            this._stateFlow.setValue((Object)snapshot);
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)snapshot);
            }
        }
    }

    private final LoadState computeHelperState(LoadState previousState, LoadState sourceRefreshState, LoadState sourceState, LoadState remoteState) {
        if (remoteState == null) {
            return sourceState;
        }
        return previousState instanceof LoadState.Loading ? (sourceRefreshState instanceof LoadState.NotLoading && remoteState instanceof LoadState.NotLoading ? remoteState : (remoteState instanceof LoadState.Error ? remoteState : previousState)) : remoteState;
    }
}

