/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.HintHandlerKt;
import androidx.paging.LoadType;
import androidx.paging.ViewportHint;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/paging/HintHandler;", "", "()V", "lastAccessHint", "Landroidx/paging/ViewportHint$Access;", "getLastAccessHint", "()Landroidx/paging/ViewportHint$Access;", "state", "Landroidx/paging/HintHandler$State;", "forceSetHint", "", "loadType", "Landroidx/paging/LoadType;", "viewportHint", "Landroidx/paging/ViewportHint;", "hintFor", "Lkotlinx/coroutines/flow/Flow;", "processHint", "HintFlow", "State", "paging-common"})
public final class HintHandler {
    @NotNull
    private final State state = new State();

    @Nullable
    public final ViewportHint.Access getLastAccessHint() {
        return this.state.getLastAccessHint();
    }

    @NotNull
    public final Flow<ViewportHint> hintFor(@NotNull LoadType loadType) {
        Flow<ViewportHint> flow2;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
            case 1: {
                flow2 = this.state.getPrependFlow();
                break;
            }
            case 2: {
                flow2 = this.state.getAppendFlow();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid load type for hints");
            }
        }
        return flow2;
    }

    public final void forceSetHint(@NotNull LoadType loadType, @NotNull ViewportHint viewportHint) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        Intrinsics.checkNotNullParameter((Object)viewportHint, (String)"viewportHint");
        if (!(loadType == LoadType.PREPEND || loadType == LoadType.APPEND)) {
            boolean bl = false;
            String string = "invalid load type for reset: " + (Object)((Object)loadType);
            throw new IllegalArgumentException(string.toString());
        }
        this.state.modify(null, (Function2<? super HintFlow, ? super HintFlow, Unit>)((Function2)new Function2<HintFlow, HintFlow, Unit>(loadType, viewportHint){
            final /* synthetic */ LoadType $loadType;
            final /* synthetic */ ViewportHint $viewportHint;
            {
                this.$loadType = $loadType;
                this.$viewportHint = $viewportHint;
                super(2);
            }

            public final void invoke(@NotNull HintFlow prependHint, @NotNull HintFlow appendHint) {
                Intrinsics.checkNotNullParameter((Object)prependHint, (String)"prependHint");
                Intrinsics.checkNotNullParameter((Object)appendHint, (String)"appendHint");
                if (this.$loadType == LoadType.PREPEND) {
                    prependHint.setValue(this.$viewportHint);
                } else {
                    appendHint.setValue(this.$viewportHint);
                }
            }
        }));
    }

    public final void processHint(@NotNull ViewportHint viewportHint) {
        Intrinsics.checkNotNullParameter((Object)viewportHint, (String)"viewportHint");
        this.state.modify(viewportHint instanceof ViewportHint.Access ? (ViewportHint.Access)viewportHint : null, (Function2<? super HintFlow, ? super HintFlow, Unit>)((Function2)new Function2<HintFlow, HintFlow, Unit>(viewportHint){
            final /* synthetic */ ViewportHint $viewportHint;
            {
                this.$viewportHint = $viewportHint;
                super(2);
            }

            public final void invoke(@NotNull HintFlow prependHint, @NotNull HintFlow appendHint) {
                Intrinsics.checkNotNullParameter((Object)prependHint, (String)"prependHint");
                Intrinsics.checkNotNullParameter((Object)appendHint, (String)"appendHint");
                if (HintHandlerKt.shouldPrioritizeOver(this.$viewportHint, prependHint.getValue(), LoadType.PREPEND)) {
                    prependHint.setValue(this.$viewportHint);
                }
                if (HintHandlerKt.shouldPrioritizeOver(this.$viewportHint, appendHint.getValue(), LoadType.APPEND)) {
                    appendHint.setValue(this.$viewportHint);
                }
            }
        }));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\f2>\u0010\u0018\u001a:\u0012\u0017\u0012\u00150\u0004R\u00020\u0005\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0012\u0012\u0017\u0012\u00150\u0004R\u00020\u0005\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u00160\u0019R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u001c"}, d2={"Landroidx/paging/HintHandler$State;", "", "(Landroidx/paging/HintHandler;)V", "append", "Landroidx/paging/HintHandler$HintFlow;", "Landroidx/paging/HintHandler;", "appendFlow", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/paging/ViewportHint;", "getAppendFlow", "()Lkotlinx/coroutines/flow/Flow;", "<set-?>", "Landroidx/paging/ViewportHint$Access;", "lastAccessHint", "getLastAccessHint", "()Landroidx/paging/ViewportHint$Access;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "prepend", "prependFlow", "getPrependFlow", "modify", "", "accessHint", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "paging-common"})
    private final class State {
        @NotNull
        private final HintFlow prepend;
        @NotNull
        private final HintFlow append;
        @Nullable
        private ViewportHint.Access lastAccessHint;
        @NotNull
        private final ReentrantLock lock;

        public State() {
            this.prepend = new HintFlow();
            this.append = new HintFlow();
            this.lock = new ReentrantLock();
        }

        @Nullable
        public final ViewportHint.Access getLastAccessHint() {
            return this.lastAccessHint;
        }

        @NotNull
        public final Flow<ViewportHint> getPrependFlow() {
            return this.prepend.getFlow();
        }

        @NotNull
        public final Flow<ViewportHint> getAppendFlow() {
            return this.append.getFlow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void modify(@Nullable ViewportHint.Access accessHint, @NotNull Function2<? super HintFlow, ? super HintFlow, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                if (accessHint != null) {
                    this.lastAccessHint = accessHint;
                }
                block.invoke((Object)this.prepend, (Object)this.append);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/paging/HintHandler$HintFlow;", "", "(Landroidx/paging/HintHandler;)V", "_flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Landroidx/paging/ViewportHint;", "flow", "Lkotlinx/coroutines/flow/Flow;", "getFlow", "()Lkotlinx/coroutines/flow/Flow;", "value", "getValue", "()Landroidx/paging/ViewportHint;", "setValue", "(Landroidx/paging/ViewportHint;)V", "paging-common"})
    private final class HintFlow {
        @Nullable
        private ViewportHint value;
        @NotNull
        private final MutableSharedFlow<ViewportHint> _flow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);

        @Nullable
        public final ViewportHint getValue() {
            return this.value;
        }

        public final void setValue(@Nullable ViewportHint value) {
            this.value = value;
            if (value != null) {
                this._flow.tryEmit((Object)value);
            }
        }

        @NotNull
        public final Flow<ViewportHint> getFlow() {
            return (Flow)this._flow;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.PREPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.APPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

