/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.IntRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B'\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0013"}, d2={"Landroidx/paging/ItemSnapshotList;", "T", "Lkotlin/collections/AbstractList;", "placeholdersBefore", "", "placeholdersAfter", "items", "", "(IILjava/util/List;)V", "getItems", "()Ljava/util/List;", "getPlaceholdersAfter", "()I", "getPlaceholdersBefore", "size", "getSize", "get", "index", "(I)Ljava/lang/Object;", "paging-common"})
public final class ItemSnapshotList<T>
extends AbstractList<T> {
    private final int placeholdersBefore;
    private final int placeholdersAfter;
    @NotNull
    private final List<T> items;

    public ItemSnapshotList(@IntRange(from=0L) int placeholdersBefore, @IntRange(from=0L) int placeholdersAfter, @NotNull List<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.placeholdersBefore = placeholdersBefore;
        this.placeholdersAfter = placeholdersAfter;
        this.items = items;
    }

    public final int getPlaceholdersBefore() {
        return this.placeholdersBefore;
    }

    public final int getPlaceholdersAfter() {
        return this.placeholdersAfter;
    }

    @NotNull
    public final List<T> getItems() {
        return this.items;
    }

    public int getSize() {
        return this.placeholdersBefore + this.items.size() + this.placeholdersAfter;
    }

    @Nullable
    public T get(int index) {
        Object v1;
        int n = index;
        boolean bl = 0 <= n ? n < this.placeholdersBefore : false;
        if (bl) {
            v1 = null;
        } else {
            int n2 = this.placeholdersBefore;
            boolean bl2 = n < this.placeholdersBefore + this.items.size() ? n2 <= n : false;
            if (bl2) {
                v1 = this.items.get(index - this.placeholdersBefore);
            } else {
                n2 = this.placeholdersBefore + this.items.size();
                boolean bl3 = n < this.size() ? n2 <= n : false;
                if (bl3) {
                    v1 = null;
                } else {
                    throw new IndexOutOfBoundsException("Illegal attempt to access index " + index + " in ItemSnapshotList of size " + this.size());
                }
            }
        }
        return v1;
    }
}

